/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.presto.verifier.framework.QueryStage;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.util.HashMap;
import java.util.Map;

public class QueryActionUtil {
    private QueryActionUtil() {
    }

    public static Map<String, String> mangleSessionProperties(Map<String, String> mainQuerySessionProperty, QueryStage queryStage, Duration queryTimeout, boolean removeMemoryRelatedSessionProperty) {
        HashMap<String, String> sessionProperties = queryStage.isMain() || queryStage == QueryStage.DETERMINISM_ANALYSIS_MAIN ? new HashMap<String, String>(mainQuerySessionProperty) : new HashMap<String, String>();
        sessionProperties.put("query_max_execution_time", queryTimeout.toString());
        sessionProperties.remove("query_max_run_time");
        if (removeMemoryRelatedSessionProperty) {
            sessionProperties.remove("query_max_broadcast_memory");
            sessionProperties.remove("query_max_memory_per_node");
            sessionProperties.remove("query_max_total_memory_per_node");
            sessionProperties.remove("query_max_memory");
            sessionProperties.remove("query_max_total_memory");
        }
        return ImmutableMap.copyOf(sessionProperties);
    }
}

