/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.verifier.resolver.FailureResolver;
import com.facebook.presto.verifier.resolver.FailureResolverFactory;
import com.facebook.presto.verifier.resolver.FailureResolverFactoryContext;
import com.facebook.presto.verifier.resolver.FailureResolverManager;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;

public class FailureResolverManagerFactory {
    private final Set<FailureResolver> failureResolvers;
    private final Set<FailureResolverFactory> failureResolverFactories;

    @Inject
    public FailureResolverManagerFactory(Set<FailureResolver> failureResolvers, Set<FailureResolverFactory> failureResolverFactories) {
        this.failureResolvers = ImmutableSet.copyOf(failureResolvers);
        this.failureResolverFactories = ImmutableSet.copyOf(failureResolverFactories);
    }

    public FailureResolverManager create(FailureResolverFactoryContext context) {
        Set allResolvers = (Set)Stream.concat(this.failureResolvers.stream(), this.failureResolverFactories.stream().map(factory -> factory.create(context))).collect(ImmutableSet.toImmutableSet());
        return new FailureResolverManager(allResolvers);
    }
}

