/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.source;

import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.verifier.annotation.ForHelper;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.PrestoActionFactory;
import com.facebook.presto.verifier.source.PrestoQuerySourceQueryConfig;
import com.facebook.presto.verifier.source.SourceQuerySupplier;
import com.facebook.presto.verifier.source.StringToStringMapColumnMapper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class PrestoQuerySourceQuerySupplier
implements SourceQuerySupplier {
    public static final String PRESTO_QUERY_SOURCE_QUERY_SUPPLIER = "presto-query";
    private static final PrestoAction.ResultSetConverter<SourceQuery> SOURCE_QUERY_CONVERTER = resultSet -> Optional.of(new SourceQuery(resultSet.getString("suite"), resultSet.getString("name"), resultSet.getString("control_query"), resultSet.getString("test_query"), new QueryConfiguration(resultSet.getString("control_catalog"), resultSet.getString("control_schema"), Optional.ofNullable(resultSet.getString("control_username")), Optional.ofNullable(resultSet.getString("control_password")), Optional.ofNullable(resultSet.getString("control_session_properties")).map(arg_0 -> StringToStringMapColumnMapper.CODEC.fromJson(arg_0))), new QueryConfiguration(resultSet.getString("test_catalog"), resultSet.getString("test_schema"), Optional.ofNullable(resultSet.getString("test_username")), Optional.ofNullable(resultSet.getString("test_password")), Optional.ofNullable(resultSet.getString("test_session_properties")).map(arg_0 -> StringToStringMapColumnMapper.CODEC.fromJson(arg_0)))));
    private final PrestoAction helperAction;
    private final SqlParser sqlParser;
    private final String query;

    @Inject
    public PrestoQuerySourceQuerySupplier(@ForHelper PrestoActionFactory helperActionFactory, SqlParser sqlParser, PrestoQuerySourceQueryConfig config) {
        this.helperAction = helperActionFactory.create(new QueryConfiguration(config.getCatalog(), config.getSchema(), config.getUsername(), config.getPassword(), Optional.empty()), VerificationContext.create("", ""));
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.query = Objects.requireNonNull(config.getQuery(), "query is null");
    }

    @Override
    public List<SourceQuery> get() {
        return this.helperAction.execute(this.sqlParser.createStatement(this.query, VerifierUtil.PARSING_OPTIONS), QueryStage.SOURCE, SOURCE_QUERY_CONVERTER).getResults();
    }
}

