/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing.mysql;

import com.facebook.presto.testing.mysql.EmbeddedMySql;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractTestingMySqlServer
implements Closeable {
    private static final Logger log = Logger.get(AbstractTestingMySqlServer.class);
    private final String user;
    private final String password;
    private final Set<String> databases;
    private final int port;
    private final String version;
    private final EmbeddedMySql server;

    public AbstractTestingMySqlServer(EmbeddedMySql server, String user, String password, Iterable<String> databases) throws Exception {
        this.server = Objects.requireNonNull(server, "server is null");
        this.user = Objects.requireNonNull(user, "user is null");
        this.password = Objects.requireNonNull(password, "password is null");
        this.databases = ImmutableSet.copyOf(Objects.requireNonNull(databases, "databases is null"));
        this.port = server.getPort();
        try (Connection connection = server.getMySqlDatabase();){
            this.version = connection.getMetaData().getDatabaseProductVersion();
            try (Statement statement = connection.createStatement();){
                AbstractTestingMySqlServer.execute(statement, String.format("CREATE USER '%s'@'%%' IDENTIFIED BY '%s'", user, password));
                AbstractTestingMySqlServer.execute(statement, String.format("GRANT ALL ON *.* to '%s'@'%%' WITH GRANT OPTION", user));
                for (String database : databases) {
                    AbstractTestingMySqlServer.execute(statement, String.format("CREATE DATABASE %s", database));
                }
            }
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
        log.info("MySQL server ready: %s", new Object[]{this.getJdbcUrl()});
    }

    private static void execute(Statement statement, String sql) throws SQLException {
        log.debug("Executing: %s", new Object[]{sql});
        statement.execute(sql);
    }

    @Override
    public void close() throws IOException {
        this.server.close();
    }

    public String getMySqlVersion() {
        return this.version;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<String> getDatabases() {
        return this.databases;
    }

    public int getPort() {
        return this.port;
    }

    public String getJdbcUrl() {
        return this.getJdbcUrl("");
    }

    public abstract String getJdbcUrl(String var1);
}

