/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.os.Build;
import com.facebook.hermes.intl.Constants;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.IPlatformNumberFormatter;
import com.facebook.hermes.intl.IntlTextUtils;
import com.facebook.hermes.intl.JSObjects;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleMatcher;
import com.facebook.hermes.intl.LocaleResolver;
import com.facebook.hermes.intl.OptionHelpers;
import com.facebook.hermes.intl.PlatformNumberFormatterAndroid;
import com.facebook.hermes.intl.PlatformNumberFormatterICU;
import com.facebook.proguard.annotations.DoNotStrip;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@DoNotStrip
public class NumberFormat {
    private IPlatformNumberFormatter.Style mResolvedStyle;
    private String mResolvedCurrency = null;
    private IPlatformNumberFormatter.CurrencyDisplay mResolvedCurrencyDisplay = IPlatformNumberFormatter.CurrencyDisplay.SYMBOL;
    private IPlatformNumberFormatter.CurrencySign mResolvedCurrencySign = IPlatformNumberFormatter.CurrencySign.STANDARD;
    private String mResolvedUnit = null;
    private IPlatformNumberFormatter.UnitDisplay mResolvedUnitDisplay;
    private boolean mGroupingUsed = true;
    private int mResolvedMinimumIntegerDigits = -1;
    private int mResolvedMinimumFractionDigits = -1;
    private int mResolvedMaximumFractionDigits = -1;
    private int mResolvedMinimumSignificantDigits = -1;
    private int mResolvedMaximumSignificantDigits = -1;
    private IPlatformNumberFormatter.RoundingType mRoundingType;
    private IPlatformNumberFormatter.SignDisplay mResolvedSignDisplay = IPlatformNumberFormatter.SignDisplay.AUTO;
    private IPlatformNumberFormatter mPlatformNumberFormatter = Build.VERSION.SDK_INT >= 24 ? new PlatformNumberFormatterICU() : new PlatformNumberFormatterAndroid();
    private boolean mUseDefaultNumberSystem;
    private String mResolvedNumberingSystem = null;
    private IPlatformNumberFormatter.Notation mResolvedNotation = null;
    private IPlatformNumberFormatter.CompactDisplay mResolvedCompactDisplay;
    private ILocaleObject<?> mResolvedLocaleObject = null;
    private ILocaleObject<?> mResolvedLocaleObjectForResolvedOptions = null;
    private static String[] s_sanctionedSimpleUnitIdentifiers = new String[]{"acre", "bit", "byte", "celsius", "centimeter", "day", "degree", "fahrenheit", "fluid-ounce", "foot", "gallon", "gigabit", "gigabyte", "gram", "hectare", "hour", "inch", "kilobit", "kilobyte", "kilogram", "kilometer", "liter", "megabit", "megabyte", "meter", "mile", "mile-scandinavian", "milliliter", "millimeter", "millisecond", "minute", "month", "ounce", "percent", "petabyte", "pound", "second", "stone", "terabit", "terabyte", "week", "yard", "year"};

    private boolean isSanctionedSimpleUnitIdentifier(String unitIdentifier) {
        return Arrays.binarySearch(s_sanctionedSimpleUnitIdentifiers, unitIdentifier) >= 0;
    }

    private boolean isWellFormedUnitIdentifier(String unitIdentifier) {
        if (this.isSanctionedSimpleUnitIdentifier(unitIdentifier)) {
            return true;
        }
        String per = "-per-";
        int indexOfPer = unitIdentifier.indexOf(per);
        if (indexOfPer < 0) {
            return false;
        }
        if (unitIdentifier.indexOf(per, indexOfPer + 1) >= 0) {
            return false;
        }
        String numerator = unitIdentifier.substring(0, indexOfPer);
        if (!this.isSanctionedSimpleUnitIdentifier(numerator)) {
            return false;
        }
        String denominator = unitIdentifier.substring(indexOfPer + per.length());
        return this.isSanctionedSimpleUnitIdentifier(denominator);
    }

    private String normalizeCurrencyCode(String currencyCode) {
        StringBuilder normalized = new StringBuilder(currencyCode.length());
        int offset = 32;
        for (int idx = 0; idx < currencyCode.length(); ++idx) {
            char c = currencyCode.charAt(idx);
            if (c >= 'a' && c <= 'z') {
                normalized.append((char)(c - offset));
                continue;
            }
            normalized.append(c);
        }
        return normalized.toString();
    }

    private boolean isWellFormedCurrencyCode(String currencyCode) {
        String normalized = this.normalizeCurrencyCode(currencyCode);
        return normalized.matches("^[A-Z][A-Z][A-Z]$");
    }

    private void setNumberFormatUnitOptions(Map<String, Object> options) throws JSRangeErrorException {
        Object style = OptionHelpers.GetOption(options, "style", OptionHelpers.OptionType.STRING, new String[]{"decimal", "percent", "currency", "unit"}, "decimal");
        this.mResolvedStyle = OptionHelpers.searchEnum(IPlatformNumberFormatter.Style.class, JSObjects.getJavaString(style));
        Object currency = OptionHelpers.GetOption(options, "currency", OptionHelpers.OptionType.STRING, JSObjects.Undefined(), JSObjects.Undefined());
        if (JSObjects.isUndefined(currency)) {
            if (this.mResolvedStyle == IPlatformNumberFormatter.Style.CURRENCY) {
                throw new JSRangeErrorException("Expected currency style !");
            }
        } else if (!this.isWellFormedCurrencyCode(JSObjects.getJavaString(currency))) {
            throw new JSRangeErrorException("Malformed currency code !");
        }
        Object currencyDisplay = OptionHelpers.GetOption(options, "currencyDisplay", OptionHelpers.OptionType.STRING, new String[]{"symbol", "narrowSymbol", "code", "name"}, "symbol");
        Object currencySign = OptionHelpers.GetOption(options, "currencySign", OptionHelpers.OptionType.STRING, new String[]{"accounting", "standard"}, "standard");
        Object unit = OptionHelpers.GetOption(options, "unit", OptionHelpers.OptionType.STRING, JSObjects.Undefined(), JSObjects.Undefined());
        if (JSObjects.isUndefined(unit)) {
            if (this.mResolvedStyle == IPlatformNumberFormatter.Style.UNIT) {
                throw new JSRangeErrorException("Expected unit !");
            }
        } else if (!this.isWellFormedUnitIdentifier(JSObjects.getJavaString(unit))) {
            throw new JSRangeErrorException("Malformed unit identifier !");
        }
        Object unitDisplay = OptionHelpers.GetOption(options, "unitDisplay", OptionHelpers.OptionType.STRING, new String[]{"long", "short", "narrow"}, "short");
        if (this.mResolvedStyle == IPlatformNumberFormatter.Style.CURRENCY) {
            this.mResolvedCurrency = this.normalizeCurrencyCode(JSObjects.getJavaString(currency));
            this.mResolvedCurrencyDisplay = OptionHelpers.searchEnum(IPlatformNumberFormatter.CurrencyDisplay.class, JSObjects.getJavaString(currencyDisplay));
            this.mResolvedCurrencySign = OptionHelpers.searchEnum(IPlatformNumberFormatter.CurrencySign.class, JSObjects.getJavaString(currencySign));
        } else if (this.mResolvedStyle == IPlatformNumberFormatter.Style.UNIT) {
            this.mResolvedUnit = JSObjects.getJavaString(unit);
            this.mResolvedUnitDisplay = OptionHelpers.searchEnum(IPlatformNumberFormatter.UnitDisplay.class, JSObjects.getJavaString(unitDisplay));
        }
    }

    private void setNumberFormatDigitOptions(Map<String, Object> options, Object mnfdDefault, Object mxfdDefault) throws JSRangeErrorException {
        Object mnid = OptionHelpers.GetNumberOption(options, "minimumIntegerDigits", JSObjects.newNumber(1.0), JSObjects.newNumber(21.0), JSObjects.newNumber(1.0));
        Object mnfd = JSObjects.Get(options, "minimumFractionDigits");
        Object mxfd = JSObjects.Get(options, "maximumFractionDigits");
        Object mnsd = JSObjects.Get(options, "minimumSignificantDigits");
        Object mxsd = JSObjects.Get(options, "maximumSignificantDigits");
        this.mResolvedMinimumIntegerDigits = (int)Math.floor(JSObjects.getJavaDouble(mnid));
        if (!JSObjects.isUndefined(mnsd) || !JSObjects.isUndefined(mxsd)) {
            this.mRoundingType = IPlatformNumberFormatter.RoundingType.SIGNIFICANT_DIGITS;
            mnsd = OptionHelpers.DefaultNumberOption(mnsd, JSObjects.newNumber(1.0), JSObjects.newNumber(21.0), JSObjects.newNumber(1.0));
            mxsd = OptionHelpers.DefaultNumberOption(mxsd, mnsd, JSObjects.newNumber(21.0), JSObjects.newNumber(21.0));
            this.mResolvedMinimumSignificantDigits = (int)Math.floor(JSObjects.getJavaDouble(mnsd));
            this.mResolvedMaximumSignificantDigits = (int)Math.floor(JSObjects.getJavaDouble(mxsd));
        } else if (!JSObjects.isUndefined(mnfd) || !JSObjects.isUndefined(mxfd)) {
            this.mRoundingType = IPlatformNumberFormatter.RoundingType.FRACTION_DIGITS;
            mnfd = OptionHelpers.DefaultNumberOption(mnfd, JSObjects.newNumber(0.0), JSObjects.newNumber(20.0), mnfdDefault);
            Object mxfdActualDefault = JSObjects.newNumber(Math.max(JSObjects.getJavaDouble(mnfd), JSObjects.getJavaDouble(mxfdDefault)));
            mxfd = OptionHelpers.DefaultNumberOption(mxfd, mnfd, JSObjects.newNumber(20.0), mxfdActualDefault);
            this.mResolvedMinimumFractionDigits = (int)Math.floor(JSObjects.getJavaDouble(mnfd));
            this.mResolvedMaximumFractionDigits = (int)Math.floor(JSObjects.getJavaDouble(mxfd));
        } else if (this.mResolvedNotation == IPlatformNumberFormatter.Notation.COMPACT) {
            this.mRoundingType = IPlatformNumberFormatter.RoundingType.COMPACT_ROUNDING;
        } else if (this.mResolvedNotation == IPlatformNumberFormatter.Notation.ENGINEERING) {
            this.mRoundingType = IPlatformNumberFormatter.RoundingType.FRACTION_DIGITS;
            this.mResolvedMaximumFractionDigits = 5;
        } else {
            this.mRoundingType = IPlatformNumberFormatter.RoundingType.FRACTION_DIGITS;
            this.mResolvedMinimumFractionDigits = (int)Math.floor(JSObjects.getJavaDouble(mnfdDefault));
            this.mResolvedMaximumFractionDigits = (int)Math.floor(JSObjects.getJavaDouble(mxfdDefault));
        }
    }

    private boolean isLocaleIdType(String token) {
        return IntlTextUtils.isUnicodeExtensionKeyTypeItem(token, 0, token.length() - 1);
    }

    private void initializeNumberFormat(List<String> locales, Map<String, Object> options) throws JSRangeErrorException {
        Object mxfdDefault;
        Object mnfdDefault;
        Object opt = JSObjects.newObject();
        Object matcher = OptionHelpers.GetOption(options, "localeMatcher", OptionHelpers.OptionType.STRING, Constants.LOCALEMATCHER_POSSIBLE_VALUES, "best fit");
        JSObjects.Put(opt, "localeMatcher", matcher);
        Object numberingSystem = OptionHelpers.GetOption(options, "numberingSystem", OptionHelpers.OptionType.STRING, JSObjects.Undefined(), JSObjects.Undefined());
        if (!JSObjects.isUndefined(numberingSystem) && !this.isLocaleIdType(JSObjects.getJavaString(numberingSystem))) {
            throw new JSRangeErrorException("Invalid numbering system !");
        }
        JSObjects.Put(opt, "nu", numberingSystem);
        List<String> relevantExtensionKeys = Collections.singletonList("nu");
        HashMap<String, Object> r = LocaleResolver.resolveLocale(locales, opt, relevantExtensionKeys);
        this.mResolvedLocaleObject = (ILocaleObject)JSObjects.getJavaMap(r).get("locale");
        this.mResolvedLocaleObjectForResolvedOptions = this.mResolvedLocaleObject.cloneObject();
        Object numeringSystemResolved = JSObjects.Get(r, "nu");
        if (!JSObjects.isNull(numeringSystemResolved)) {
            this.mUseDefaultNumberSystem = false;
            this.mResolvedNumberingSystem = JSObjects.getJavaString(numeringSystemResolved);
        } else {
            this.mUseDefaultNumberSystem = true;
            this.mResolvedNumberingSystem = this.mPlatformNumberFormatter.getDefaultNumberingSystem(this.mResolvedLocaleObject);
        }
        this.setNumberFormatUnitOptions(options);
        if (this.mResolvedStyle == IPlatformNumberFormatter.Style.CURRENCY) {
            int cDigits = Build.VERSION.SDK_INT >= 24 ? PlatformNumberFormatterICU.getCurrencyDigits(this.mResolvedCurrency) : PlatformNumberFormatterAndroid.getCurrencyDigits(this.mResolvedCurrency);
            mnfdDefault = JSObjects.newNumber(cDigits);
            mxfdDefault = JSObjects.newNumber(cDigits);
        } else {
            mnfdDefault = JSObjects.newNumber(0.0);
            mxfdDefault = this.mResolvedStyle == IPlatformNumberFormatter.Style.PERCENT ? JSObjects.newNumber(0.0) : JSObjects.newNumber(3.0);
        }
        Object notation = OptionHelpers.GetOption(options, "notation", OptionHelpers.OptionType.STRING, new String[]{"standard", "scientific", "engineering", "compact"}, "standard");
        this.mResolvedNotation = OptionHelpers.searchEnum(IPlatformNumberFormatter.Notation.class, JSObjects.getJavaString(notation));
        this.setNumberFormatDigitOptions(options, mnfdDefault, mxfdDefault);
        Object compactDisplay = OptionHelpers.GetOption(options, "compactDisplay", OptionHelpers.OptionType.STRING, new String[]{"short", "long"}, "short");
        if (this.mResolvedNotation == IPlatformNumberFormatter.Notation.COMPACT) {
            this.mResolvedCompactDisplay = OptionHelpers.searchEnum(IPlatformNumberFormatter.CompactDisplay.class, JSObjects.getJavaString(compactDisplay));
        }
        Object groupingUsed = OptionHelpers.GetOption(options, "useGrouping", OptionHelpers.OptionType.BOOLEAN, JSObjects.Undefined(), JSObjects.newBoolean(true));
        this.mGroupingUsed = JSObjects.getJavaBoolean(groupingUsed);
        Object signDisplay = OptionHelpers.GetOption(options, "signDisplay", OptionHelpers.OptionType.STRING, new String[]{"auto", "never", "always", "exceptZero"}, "auto");
        this.mResolvedSignDisplay = OptionHelpers.searchEnum(IPlatformNumberFormatter.SignDisplay.class, JSObjects.getJavaString(signDisplay));
    }

    @DoNotStrip
    public NumberFormat(List<String> locales, Map<String, Object> options) throws JSRangeErrorException {
        this.initializeNumberFormat(locales, options);
        this.mPlatformNumberFormatter.configure(this.mResolvedLocaleObject, this.mUseDefaultNumberSystem ? "" : this.mResolvedNumberingSystem, this.mResolvedStyle, this.mResolvedCurrencySign, this.mResolvedNotation, this.mResolvedCompactDisplay).setCurrency(this.mResolvedCurrency, this.mResolvedCurrencyDisplay).setGrouping(this.mGroupingUsed).setMinIntergerDigits(this.mResolvedMinimumIntegerDigits).setSignificantDigits(this.mRoundingType, this.mResolvedMinimumSignificantDigits, this.mResolvedMaximumSignificantDigits).setFractionDigits(this.mRoundingType, this.mResolvedMinimumFractionDigits, this.mResolvedMaximumFractionDigits).setSignDisplay(this.mResolvedSignDisplay).setUnits(this.mResolvedUnit, this.mResolvedUnitDisplay);
    }

    @DoNotStrip
    public static List<String> supportedLocalesOf(List<String> locales, Map<String, Object> options) throws JSRangeErrorException {
        String matcher = JSObjects.getJavaString(OptionHelpers.GetOption(options, "localeMatcher", OptionHelpers.OptionType.STRING, Constants.LOCALEMATCHER_POSSIBLE_VALUES, "best fit"));
        String[] localeArray = new String[locales.size()];
        if (Build.VERSION.SDK_INT >= 24 && matcher.equals("best fit")) {
            return Arrays.asList(LocaleMatcher.bestFitSupportedLocales(locales.toArray(localeArray)));
        }
        return Arrays.asList(LocaleMatcher.lookupSupportedLocales(locales.toArray(localeArray)));
    }

    @DoNotStrip
    public Map<String, Object> resolvedOptions() throws JSRangeErrorException {
        LinkedHashMap<String, Object> finalResolvedOptions = new LinkedHashMap<String, Object>();
        finalResolvedOptions.put("locale", this.mResolvedLocaleObjectForResolvedOptions.toCanonicalTag());
        finalResolvedOptions.put("numberingSystem", this.mResolvedNumberingSystem);
        finalResolvedOptions.put("style", this.mResolvedStyle.toString());
        if (this.mResolvedStyle == IPlatformNumberFormatter.Style.CURRENCY) {
            finalResolvedOptions.put("currency", this.mResolvedCurrency);
            finalResolvedOptions.put("currencyDisplay", this.mResolvedCurrencyDisplay.toString());
            finalResolvedOptions.put("currencySign", this.mResolvedCurrencySign.toString());
        } else if (this.mResolvedStyle == IPlatformNumberFormatter.Style.UNIT) {
            finalResolvedOptions.put("unit", this.mResolvedUnit);
            finalResolvedOptions.put("unitDisplay", this.mResolvedUnitDisplay.toString());
        }
        if (this.mResolvedMinimumIntegerDigits != -1) {
            finalResolvedOptions.put("minimumIntegerDigits", this.mResolvedMinimumIntegerDigits);
        }
        if (this.mRoundingType == IPlatformNumberFormatter.RoundingType.SIGNIFICANT_DIGITS) {
            if (this.mResolvedMaximumSignificantDigits != -1) {
                finalResolvedOptions.put("minimumSignificantDigits", this.mResolvedMaximumSignificantDigits);
            }
            if (this.mResolvedMinimumSignificantDigits != -1) {
                finalResolvedOptions.put("maximumSignificantDigits", this.mResolvedMinimumSignificantDigits);
            }
        } else if (this.mRoundingType == IPlatformNumberFormatter.RoundingType.FRACTION_DIGITS) {
            if (this.mResolvedMinimumFractionDigits != -1) {
                finalResolvedOptions.put("minimumFractionDigits", this.mResolvedMinimumFractionDigits);
            }
            if (this.mResolvedMaximumFractionDigits != -1) {
                finalResolvedOptions.put("maximumFractionDigits", this.mResolvedMaximumFractionDigits);
            }
        }
        finalResolvedOptions.put("useGrouping", this.mGroupingUsed);
        finalResolvedOptions.put("notation", this.mResolvedNotation.toString());
        if (this.mResolvedNotation == IPlatformNumberFormatter.Notation.COMPACT) {
            finalResolvedOptions.put("compactDisplay", this.mResolvedCompactDisplay.toString());
        }
        finalResolvedOptions.put("signDisplay", this.mResolvedSignDisplay.toString());
        return finalResolvedOptions;
    }

    @DoNotStrip
    public String format(double n) throws JSRangeErrorException {
        return this.mPlatformNumberFormatter.format(n);
    }

    @DoNotStrip
    public List<Map<String, String>> formatToParts(double n) throws JSRangeErrorException {
        ArrayList<Map<String, String>> parts = new ArrayList<Map<String, String>>();
        AttributedCharacterIterator iterator = this.mPlatformNumberFormatter.formatToParts(n);
        StringBuilder sb = new StringBuilder();
        char ch = iterator.first();
        while (ch != '\uffff') {
            sb.append(ch);
            if (iterator.getIndex() + 1 == iterator.getRunLimit()) {
                Iterator<AttributedCharacterIterator.Attribute> keyIterator = iterator.getAttributes().keySet().iterator();
                String key = keyIterator.hasNext() ? this.mPlatformNumberFormatter.fieldToString(keyIterator.next(), n) : "literal";
                String value = sb.toString();
                sb.setLength(0);
                HashMap<String, String> part = new HashMap<String, String>();
                part.put("type", key);
                part.put("value", value);
                parts.add(part);
            }
            ch = iterator.next();
        }
        return parts;
    }
}

