/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.os.Build;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.IPlatformNumberFormatter;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleObjectAndroid;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Locale;

public class PlatformNumberFormatterAndroid
implements IPlatformNumberFormatter {
    private Format mFinalFormat;
    private DecimalFormat mDecimalFormat;
    private LocaleObjectAndroid mLocaleObject;
    private IPlatformNumberFormatter.Style mStyle;

    PlatformNumberFormatterAndroid() {
    }

    private void initialize(DecimalFormat decimalFormat, ILocaleObject<?> localeObject, IPlatformNumberFormatter.Style style) {
        this.mDecimalFormat = decimalFormat;
        this.mFinalFormat = decimalFormat;
        this.mLocaleObject = (LocaleObjectAndroid)localeObject;
        this.mStyle = style;
    }

    @Override
    public PlatformNumberFormatterAndroid setCurrency(String currencyCode, IPlatformNumberFormatter.CurrencyDisplay currencyDisplay) throws JSRangeErrorException {
        if (this.mStyle == IPlatformNumberFormatter.Style.CURRENCY) {
            String currencySymbol;
            Currency currency = Currency.getInstance(currencyCode);
            this.mDecimalFormat.setCurrency(currency);
            switch (currencyDisplay) {
                case NAME: {
                    if (Build.VERSION.SDK_INT >= 19) {
                        currencySymbol = currency.getDisplayName(this.mLocaleObject.getLocale());
                        break;
                    }
                    currencySymbol = currency.getSymbol(this.mLocaleObject.getLocale());
                    break;
                }
                case CODE: {
                    currencySymbol = currencyCode;
                    break;
                }
                default: {
                    currencySymbol = currency.getSymbol(this.mLocaleObject.getLocale());
                }
            }
            DecimalFormatSymbols symbols = this.mDecimalFormat.getDecimalFormatSymbols();
            symbols.setCurrencySymbol(currencySymbol);
            this.mDecimalFormat.setDecimalFormatSymbols(symbols);
            this.mDecimalFormat.getDecimalFormatSymbols().setCurrencySymbol(currencySymbol);
        }
        return this;
    }

    @Override
    public PlatformNumberFormatterAndroid setGrouping(boolean mGroupingUsed) {
        this.mDecimalFormat.setGroupingUsed(mGroupingUsed);
        return this;
    }

    @Override
    public PlatformNumberFormatterAndroid setMinIntergerDigits(int minimumIntegerDigits) {
        if (minimumIntegerDigits != -1) {
            this.mDecimalFormat.setMinimumIntegerDigits(minimumIntegerDigits);
        }
        return this;
    }

    @Override
    public PlatformNumberFormatterAndroid setSignificantDigits(IPlatformNumberFormatter.RoundingType roundingType, int minimumSignificantDigits, int maximumSignificantDigits) {
        return this;
    }

    @Override
    public PlatformNumberFormatterAndroid setFractionDigits(IPlatformNumberFormatter.RoundingType roundingType, int minimumFractionDigits, int maximumFractionDigits) {
        if (roundingType == IPlatformNumberFormatter.RoundingType.FRACTION_DIGITS) {
            if (minimumFractionDigits >= 0) {
                this.mDecimalFormat.setMinimumFractionDigits(minimumFractionDigits);
            }
            if (maximumFractionDigits >= 0) {
                this.mDecimalFormat.setMaximumFractionDigits(maximumFractionDigits);
            }
        }
        return this;
    }

    @Override
    public PlatformNumberFormatterAndroid setSignDisplay(IPlatformNumberFormatter.SignDisplay signDisplay) {
        if (signDisplay == IPlatformNumberFormatter.SignDisplay.NEVER) {
            this.mDecimalFormat.setPositivePrefix("");
            this.mDecimalFormat.setPositiveSuffix("");
            this.mDecimalFormat.setNegativePrefix("");
            this.mDecimalFormat.setNegativeSuffix("");
        }
        return this;
    }

    public static int getCurrencyDigits(String currencyCode) throws JSRangeErrorException {
        try {
            return Currency.getInstance(currencyCode).getDefaultFractionDigits();
        }
        catch (IllegalArgumentException ex) {
            throw new JSRangeErrorException("Invalid currency code !");
        }
    }

    @Override
    public String format(double n) {
        return this.mFinalFormat.format(n);
    }

    @Override
    public String fieldToString(AttributedCharacterIterator.Attribute attribute, double x) {
        return "literal";
    }

    @Override
    public AttributedCharacterIterator formatToParts(double n) {
        return this.mFinalFormat.formatToCharacterIterator(n);
    }

    @Override
    public PlatformNumberFormatterAndroid setUnits(String unit, IPlatformNumberFormatter.UnitDisplay unitDisplay) {
        return this;
    }

    @Override
    public PlatformNumberFormatterAndroid configure(ILocaleObject<?> localeObject, String numberingSystem, IPlatformNumberFormatter.Style style, IPlatformNumberFormatter.CurrencySign currencySign, IPlatformNumberFormatter.Notation notation, IPlatformNumberFormatter.CompactDisplay compactDisplay) throws JSRangeErrorException {
        NumberFormat numberFormat = NumberFormat.getInstance((Locale)localeObject.getLocale());
        numberFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.initialize((DecimalFormat)numberFormat, localeObject, style);
        return this;
    }

    @Override
    public String[] getAvailableLocales() {
        Locale[] availableLocales;
        if (Build.VERSION.SDK_INT < 21) {
            return new String[]{"en"};
        }
        ArrayList<String> availableLocaleIds = new ArrayList<String>();
        for (Locale locale : availableLocales = NumberFormat.getAvailableLocales()) {
            availableLocaleIds.add(locale.toLanguageTag());
        }
        String[] availableLocaleIdsArray = new String[availableLocaleIds.size()];
        return availableLocaleIds.toArray(availableLocaleIdsArray);
    }

    @Override
    public String getDefaultNumberingSystem(ILocaleObject<?> localeObject) {
        return "latn";
    }
}

