/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text.frescosupport;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactTextInlineImageShadowNode;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.text.frescosupport.FrescoBasedReactTextInlineImageSpan;
import java.util.Locale;

public class FrescoBasedReactTextInlineImageShadowNode
extends ReactTextInlineImageShadowNode {
    @Nullable
    private Uri mUri;
    private ReadableMap mHeaders;
    private final AbstractDraweeControllerBuilder mDraweeControllerBuilder;
    @Nullable
    private final Object mCallerContext;
    private float mWidth = Float.NaN;
    @Nullable
    private String mResizeMode;
    private float mHeight = Float.NaN;
    private int mTintColor = 0;

    public FrescoBasedReactTextInlineImageShadowNode(AbstractDraweeControllerBuilder draweeControllerBuilder, @Nullable Object callerContext) {
        this.mDraweeControllerBuilder = draweeControllerBuilder;
        this.mCallerContext = callerContext;
    }

    @ReactProp(name="src")
    public void setSource(@Nullable ReadableArray sources) {
        String source = sources == null || sources.size() == 0 ? null : sources.getMap(0).getString("uri");
        Uri uri = null;
        if (source != null) {
            try {
                uri = Uri.parse((String)source);
                if (uri.getScheme() == null) {
                    uri = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uri == null) {
                uri = FrescoBasedReactTextInlineImageShadowNode.getResourceDrawableUri((Context)this.getThemedContext(), source);
            }
        }
        if (uri != this.mUri) {
            this.markUpdated();
        }
        this.mUri = uri;
    }

    @ReactProp(name="headers")
    public void setHeaders(ReadableMap headers) {
        this.mHeaders = headers;
    }

    @ReactProp(name="tintColor", customType="Color")
    public void setTintColor(int tintColor) {
        this.mTintColor = tintColor;
    }

    @Override
    public void setWidth(Dynamic width) {
        if (width.getType() != ReadableType.Number) {
            throw new JSApplicationIllegalArgumentException("Inline images must not have percentage based width");
        }
        this.mWidth = (float)width.asDouble();
    }

    @Override
    public void setHeight(Dynamic height) {
        if (height.getType() != ReadableType.Number) {
            throw new JSApplicationIllegalArgumentException("Inline images must not have percentage based height");
        }
        this.mHeight = (float)height.asDouble();
    }

    @ReactProp(name="resizeMode")
    public void setResizeMode(@Nullable String resizeMode) {
        this.mResizeMode = resizeMode;
    }

    @Nullable
    public Uri getUri() {
        return this.mUri;
    }

    public ReadableMap getHeaders() {
        return this.mHeaders;
    }

    @Nullable
    private static Uri getResourceDrawableUri(Context context, @Nullable String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        name = name.toLowerCase(Locale.getDefault()).replace("-", "_");
        int resId = context.getResources().getIdentifier(name, "drawable", context.getPackageName());
        return new Uri.Builder().scheme("res").path(String.valueOf(resId)).build();
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public TextInlineImageSpan buildInlineImageSpan() {
        Resources resources = this.getThemedContext().getResources();
        int width = (int)Math.ceil(this.mWidth);
        int height = (int)Math.ceil(this.mHeight);
        return new FrescoBasedReactTextInlineImageSpan(resources, height, width, this.mTintColor, this.getUri(), this.getHeaders(), this.getDraweeControllerBuilder(), this.getCallerContext(), this.mResizeMode);
    }

    public AbstractDraweeControllerBuilder getDraweeControllerBuilder() {
        return this.mDraweeControllerBuilder;
    }

    @Nullable
    public Object getCallerContext() {
        return this.mCallerContext;
    }
}

