/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.common.logging.FLog;
import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.build.ReactBuildConfig;

class FrameBasedAnimationDriver
extends AnimationDriver {
    private static final double FRAME_TIME_MILLIS = 16.666666666666668;
    private long mStartFrameTimeNanos;
    private double[] mFrames;
    private double mToValue;
    private double mFromValue;
    private int mIterations;
    private int mCurrentLoop;

    FrameBasedAnimationDriver(ReadableMap config) {
        this.resetConfig(config);
    }

    @Override
    public void resetConfig(ReadableMap config) {
        ReadableArray frames = config.getArray("frames");
        int numberOfFrames = frames.size();
        if (this.mFrames == null || this.mFrames.length != numberOfFrames) {
            this.mFrames = new double[numberOfFrames];
        }
        for (int i = 0; i < numberOfFrames; ++i) {
            this.mFrames[i] = frames.getDouble(i);
        }
        this.mToValue = config.hasKey("toValue") ? (config.getType("toValue") == ReadableType.Number ? config.getDouble("toValue") : 0.0) : 0.0;
        this.mIterations = config.hasKey("iterations") ? (config.getType("iterations") == ReadableType.Number ? config.getInt("iterations") : 1) : 1;
        this.mCurrentLoop = 1;
        this.mHasFinished = this.mIterations == 0;
        this.mStartFrameTimeNanos = -1L;
    }

    @Override
    public void runAnimationStep(long frameTimeNanos) {
        double nextValue;
        long timeFromStartMillis;
        int frameIndex;
        if (this.mStartFrameTimeNanos < 0L) {
            this.mStartFrameTimeNanos = frameTimeNanos;
            if (this.mCurrentLoop == 1) {
                this.mFromValue = this.mAnimatedValue.mValue;
            }
        }
        if ((frameIndex = (int)Math.round((double)(timeFromStartMillis = (frameTimeNanos - this.mStartFrameTimeNanos) / 1000000L) / 16.666666666666668)) < 0) {
            String message = "Calculated frame index should never be lower than 0. Called with frameTimeNanos " + frameTimeNanos + " and mStartFrameTimeNanos " + this.mStartFrameTimeNanos;
            if (ReactBuildConfig.DEBUG) {
                throw new IllegalStateException(message);
            }
            FLog.w((String)"ReactNative", (String)message);
            return;
        }
        if (this.mHasFinished) {
            return;
        }
        if (frameIndex >= this.mFrames.length - 1) {
            nextValue = this.mToValue;
            if (this.mIterations == -1 || this.mCurrentLoop < this.mIterations) {
                this.mStartFrameTimeNanos = -1L;
                ++this.mCurrentLoop;
            } else {
                this.mHasFinished = true;
            }
        } else {
            nextValue = this.mFromValue + this.mFrames[frameIndex] * (this.mToValue - this.mFromValue);
        }
        this.mAnimatedValue.mValue = nextValue;
    }
}

