/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.Nullable;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.JavaMethodWrapper;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReactModuleWithSpec;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@DoNotStrip
public class JavaModuleWrapper {
    private final JSInstance mJSInstance;
    private final ModuleHolder mModuleHolder;
    private final ArrayList<NativeModule.NativeMethod> mMethods;
    private final ArrayList<MethodDescriptor> mDescs;
    private static final String TAG = JavaModuleWrapper.class.getSimpleName();

    public JavaModuleWrapper(JSInstance jsInstance, ModuleHolder moduleHolder) {
        this.mJSInstance = jsInstance;
        this.mModuleHolder = moduleHolder;
        this.mMethods = new ArrayList();
        this.mDescs = new ArrayList();
    }

    @DoNotStrip
    public BaseJavaModule getModule() {
        return (BaseJavaModule)this.mModuleHolder.getModule();
    }

    @DoNotStrip
    public String getName() {
        return this.mModuleHolder.getName();
    }

    @DoNotStrip
    private void findMethods() {
        Method[] targetMethods;
        Systrace.beginSection(0L, "findMethods");
        HashSet methodNames = new HashSet();
        Class<?> classForMethods = this.mModuleHolder.getModule().getClass();
        Class<?> superClass = classForMethods.getSuperclass();
        if (ReactModuleWithSpec.class.isAssignableFrom(superClass)) {
            classForMethods = superClass;
        }
        for (Method targetMethod : targetMethods = classForMethods.getDeclaredMethods()) {
            ReactMethod annotation = targetMethod.getAnnotation(ReactMethod.class);
            if (annotation == null) continue;
            String methodName = targetMethod.getName();
            if (methodNames.contains(methodName)) {
                throw new IllegalArgumentException("Java Module " + this.getName() + " method name already registered: " + methodName);
            }
            MethodDescriptor md = new MethodDescriptor();
            JavaMethodWrapper method = new JavaMethodWrapper(this, targetMethod, annotation.isBlockingSynchronousMethod());
            md.name = methodName;
            md.type = method.getType();
            if (md.type == "sync") {
                md.signature = method.getSignature();
                md.method = targetMethod;
            }
            this.mMethods.add(method);
            this.mDescs.add(md);
        }
        Systrace.endSection(0L);
    }

    @DoNotStrip
    public List<MethodDescriptor> getMethodDescriptors() {
        if (this.mDescs.isEmpty()) {
            this.findMethods();
        }
        return this.mDescs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    @Nullable
    public NativeMap getConstants() {
        if (ReactFeatureFlags.warnOnLegacyNativeModuleSystemUse) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Calling getConstants() on Java NativeModule (name = \"" + this.mModuleHolder.getName() + "\", className = " + this.mModuleHolder.getClassName() + ")."));
        }
        if (!this.mModuleHolder.getHasConstants()) {
            return null;
        }
        String moduleName = this.getName();
        SystraceMessage.beginSection(0L, "JavaModuleWrapper.getConstants").arg("moduleName", moduleName).flush();
        ReactMarker.logMarker(ReactMarkerConstants.GET_CONSTANTS_START, moduleName);
        BaseJavaModule baseJavaModule = this.getModule();
        Systrace.beginSection(0L, "module.getConstants");
        Map<String, Object> map = baseJavaModule.getConstants();
        Systrace.endSection(0L);
        Systrace.beginSection(0L, "create WritableNativeMap");
        ReactMarker.logMarker(ReactMarkerConstants.CONVERT_CONSTANTS_START, moduleName);
        try {
            WritableNativeMap writableNativeMap = Arguments.makeNativeMap(map);
            return writableNativeMap;
        }
        finally {
            ReactMarker.logMarker(ReactMarkerConstants.CONVERT_CONSTANTS_END, moduleName);
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.GET_CONSTANTS_END, moduleName);
            SystraceMessage.endSection(0L).flush();
        }
    }

    @DoNotStrip
    public void invoke(int methodId, ReadableNativeArray parameters) {
        if (ReactFeatureFlags.warnOnLegacyNativeModuleSystemUse) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Calling method on Java NativeModule (name = \"" + this.mModuleHolder.getName() + "\", className = " + this.mModuleHolder.getClassName() + ")."));
        }
        if (this.mMethods == null || methodId >= this.mMethods.size()) {
            return;
        }
        if (ReactFeatureFlags.warnOnLegacyNativeModuleSystemUse) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Calling " + this.mDescs.get((int)methodId).name + "() on Java NativeModule (name = \"" + this.mModuleHolder.getName() + "\", className = " + this.mModuleHolder.getClassName() + ")."));
        }
        this.mMethods.get(methodId).invoke(this.mJSInstance, parameters);
    }

    @DoNotStrip
    public class MethodDescriptor {
        @DoNotStrip
        Method method;
        @DoNotStrip
        String signature;
        @DoNotStrip
        String name;
        @DoNotStrip
        String type;
    }
}

