/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.clipboard;

import android.content.ClipData;
import android.content.ClipboardManager;
import com.facebook.fbreact.specs.NativeClipboardSpec;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="Clipboard")
public class ClipboardModule
extends NativeClipboardSpec {
    public static final String NAME = "Clipboard";

    public ClipboardModule(ReactApplicationContext context) {
        super(context);
    }

    @Override
    public String getName() {
        return NAME;
    }

    private ClipboardManager getClipboardService() {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        this.getReactApplicationContext();
        return (ClipboardManager)reactApplicationContext.getSystemService("clipboard");
    }

    @Override
    public void getString(Promise promise) {
        try {
            ClipboardManager clipboard = this.getClipboardService();
            ClipData clipData = clipboard.getPrimaryClip();
            if (clipData != null && clipData.getItemCount() >= 1) {
                ClipData.Item firstItem = clipboard.getPrimaryClip().getItemAt(0);
                promise.resolve("" + firstItem.getText());
            } else {
                promise.resolve("");
            }
        }
        catch (Exception e) {
            promise.reject(e);
        }
    }

    @Override
    public void setString(String text) {
        ClipData clipdata = ClipData.newPlainText(null, (CharSequence)text);
        ClipboardManager clipboard = this.getClipboardService();
        clipboard.setPrimaryClip(clipdata);
    }
}

