/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.viewmanagers;

import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.BaseViewManagerDelegate;
import com.facebook.react.uimanager.BaseViewManagerInterface;
import com.facebook.react.viewmanagers.ProgressViewManagerInterface;

public class ProgressViewManagerDelegate<T extends View, U extends BaseViewManagerInterface<T> & ProgressViewManagerInterface<T>>
extends BaseViewManagerDelegate<T, U> {
    public ProgressViewManagerDelegate(U viewManager) {
        super(viewManager);
    }

    @Override
    public void setProperty(T view, String propName, @Nullable Object value) {
        switch (propName) {
            case "progressViewStyle": {
                ((ProgressViewManagerInterface)((Object)this.mViewManager)).setProgressViewStyle(view, (String)value);
                break;
            }
            case "progress": {
                ((ProgressViewManagerInterface)((Object)this.mViewManager)).setProgress(view, value == null ? 0.0f : ((Double)value).floatValue());
                break;
            }
            case "progressTintColor": {
                ((ProgressViewManagerInterface)((Object)this.mViewManager)).setProgressTintColor(view, ColorPropConverter.getColor(value, view.getContext()));
                break;
            }
            case "trackTintColor": {
                ((ProgressViewManagerInterface)((Object)this.mViewManager)).setTrackTintColor(view, ColorPropConverter.getColor(value, view.getContext()));
                break;
            }
            case "progressImage": {
                ((ProgressViewManagerInterface)((Object)this.mViewManager)).setProgressImage(view, (ReadableMap)value);
                break;
            }
            case "trackImage": {
                ((ProgressViewManagerInterface)((Object)this.mViewManager)).setTrackImage(view, (ReadableMap)value);
                break;
            }
            default: {
                super.setProperty(view, propName, value);
            }
        }
    }
}

