/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.IViewManagerWithChildren;
import com.facebook.react.uimanager.LayoutShadowNode;
import java.util.List;
import java.util.WeakHashMap;

public abstract class ViewGroupManager<T extends ViewGroup>
extends BaseViewManager<T, LayoutShadowNode>
implements IViewManagerWithChildren {
    private static WeakHashMap<View, Integer> mZIndexHash = new WeakHashMap();

    @Override
    public LayoutShadowNode createShadowNodeInstance() {
        return new LayoutShadowNode();
    }

    @Override
    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return LayoutShadowNode.class;
    }

    @Override
    public void updateExtraData(T root, Object extraData) {
    }

    public void addView(T parent, View child, int index) {
        parent.addView(child, index);
    }

    public void addViews(T parent, List<View> views) {
        UiThreadUtil.assertOnUiThread();
        int size = views.size();
        for (int i = 0; i < size; ++i) {
            this.addView(parent, views.get(i), i);
        }
    }

    public static void setViewZIndex(View view, int zIndex) {
        mZIndexHash.put(view, zIndex);
    }

    @Nullable
    public static Integer getViewZIndex(View view) {
        return mZIndexHash.get(view);
    }

    public int getChildCount(T parent) {
        return parent.getChildCount();
    }

    public View getChildAt(T parent, int index) {
        return parent.getChildAt(index);
    }

    public void removeViewAt(T parent, int index) {
        UiThreadUtil.assertOnUiThread();
        parent.removeViewAt(index);
    }

    public void removeView(T parent, View view) {
        UiThreadUtil.assertOnUiThread();
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (this.getChildAt(parent, i) != view) continue;
            this.removeViewAt(parent, i);
            break;
        }
    }

    public void removeAllViews(T parent) {
        UiThreadUtil.assertOnUiThread();
        for (int i = this.getChildCount(parent) - 1; i >= 0; --i) {
            this.removeViewAt(parent, i);
        }
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return false;
    }

    public boolean shouldPromoteGrandchildren() {
        return false;
    }
}

