/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.yoga;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaConfig;
import com.facebook.yoga.YogaConfigJNIBase;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaDisplay;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaGutter;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaNative;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.YogaOverflow;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaValue;
import com.facebook.yoga.YogaWrap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@DoNotStrip
public abstract class YogaNodeJNIBase
extends YogaNode
implements Cloneable {
    private static final byte MARGIN = 1;
    private static final byte PADDING = 2;
    private static final byte BORDER = 4;
    private static final byte DOES_LEGACY_STRETCH_BEHAVIOUR = 8;
    private static final byte HAS_NEW_LAYOUT = 16;
    private static final byte LAYOUT_EDGE_SET_FLAG_INDEX = 0;
    private static final byte LAYOUT_WIDTH_INDEX = 1;
    private static final byte LAYOUT_HEIGHT_INDEX = 2;
    private static final byte LAYOUT_LEFT_INDEX = 3;
    private static final byte LAYOUT_TOP_INDEX = 4;
    private static final byte LAYOUT_DIRECTION_INDEX = 5;
    private static final byte LAYOUT_MARGIN_START_INDEX = 6;
    private static final byte LAYOUT_PADDING_START_INDEX = 10;
    private static final byte LAYOUT_BORDER_START_INDEX = 14;
    @Nullable
    private YogaNodeJNIBase mOwner;
    @Nullable
    private List<YogaNodeJNIBase> mChildren;
    @Nullable
    private YogaMeasureFunction mMeasureFunction;
    @Nullable
    private YogaBaselineFunction mBaselineFunction;
    protected long mNativePointer;
    @Nullable
    private Object mData;
    @Nullable
    @DoNotStrip
    private float[] arr = null;
    @DoNotStrip
    private int mLayoutDirection = 0;
    private boolean mHasNewLayout = true;

    private YogaNodeJNIBase(long nativePointer) {
        if (nativePointer == 0L) {
            throw new IllegalStateException("Failed to allocate native memory");
        }
        this.mNativePointer = nativePointer;
    }

    YogaNodeJNIBase() {
        this(YogaNative.jni_YGNodeNewJNI());
    }

    YogaNodeJNIBase(YogaConfig config) {
        this(YogaNative.jni_YGNodeNewWithConfigJNI(((YogaConfigJNIBase)config).mNativePointer));
    }

    @Override
    public void reset() {
        this.mMeasureFunction = null;
        this.mBaselineFunction = null;
        this.mData = null;
        this.arr = null;
        this.mHasNewLayout = true;
        this.mLayoutDirection = 0;
        YogaNative.jni_YGNodeResetJNI(this.mNativePointer);
    }

    @Override
    public int getChildCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    @Override
    public YogaNodeJNIBase getChildAt(int i) {
        if (this.mChildren == null) {
            throw new IllegalStateException("YogaNode does not have children");
        }
        return this.mChildren.get(i);
    }

    @Override
    public void addChildAt(YogaNode c, int i) {
        if (!(c instanceof YogaNodeJNIBase)) {
            return;
        }
        YogaNodeJNIBase child = (YogaNodeJNIBase)c;
        if (child.mOwner != null) {
            throw new IllegalStateException("Child already has a parent, it must be removed first.");
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList<YogaNodeJNIBase>(4);
        }
        this.mChildren.add(i, child);
        child.mOwner = this;
        YogaNative.jni_YGNodeInsertChildJNI(this.mNativePointer, child.mNativePointer, i);
    }

    @Override
    public void setIsReferenceBaseline(boolean isReferenceBaseline) {
        YogaNative.jni_YGNodeSetIsReferenceBaselineJNI(this.mNativePointer, isReferenceBaseline);
    }

    @Override
    public boolean isReferenceBaseline() {
        return YogaNative.jni_YGNodeIsReferenceBaselineJNI(this.mNativePointer);
    }

    public void swapChildAt(YogaNode newChild, int position) {
        if (!(newChild instanceof YogaNodeJNIBase)) {
            return;
        }
        YogaNodeJNIBase child = (YogaNodeJNIBase)newChild;
        this.mChildren.remove(position);
        this.mChildren.add(position, child);
        child.mOwner = this;
        YogaNative.jni_YGNodeSwapChildJNI(this.mNativePointer, child.mNativePointer, position);
    }

    @Override
    public YogaNodeJNIBase cloneWithChildren() {
        try {
            YogaNodeJNIBase clonedYogaNode = (YogaNodeJNIBase)super.clone();
            if (clonedYogaNode.mChildren != null) {
                clonedYogaNode.mChildren = new ArrayList<YogaNodeJNIBase>(clonedYogaNode.mChildren);
            }
            long clonedNativePointer = YogaNative.jni_YGNodeCloneJNI(this.mNativePointer);
            clonedYogaNode.mOwner = null;
            clonedYogaNode.mNativePointer = clonedNativePointer;
            for (int i = 0; i < clonedYogaNode.getChildCount(); ++i) {
                clonedYogaNode.swapChildAt(clonedYogaNode.getChildAt(i).cloneWithChildren(), i);
            }
            return clonedYogaNode;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public YogaNodeJNIBase cloneWithoutChildren() {
        try {
            YogaNodeJNIBase clonedYogaNode = (YogaNodeJNIBase)super.clone();
            long clonedNativePointer = YogaNative.jni_YGNodeCloneJNI(this.mNativePointer);
            clonedYogaNode.mOwner = null;
            clonedYogaNode.mNativePointer = clonedNativePointer;
            clonedYogaNode.clearChildren();
            return clonedYogaNode;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void clearChildren() {
        this.mChildren = null;
        YogaNative.jni_YGNodeClearChildrenJNI(this.mNativePointer);
    }

    @Override
    public YogaNodeJNIBase removeChildAt(int i) {
        if (this.mChildren == null) {
            throw new IllegalStateException("Trying to remove a child of a YogaNode that does not have children");
        }
        YogaNodeJNIBase child = this.mChildren.remove(i);
        child.mOwner = null;
        YogaNative.jni_YGNodeRemoveChildJNI(this.mNativePointer, child.mNativePointer);
        return child;
    }

    @Override
    @Nullable
    public YogaNodeJNIBase getOwner() {
        return this.mOwner;
    }

    @Override
    @Deprecated
    @Nullable
    public YogaNodeJNIBase getParent() {
        return this.getOwner();
    }

    @Override
    public int indexOf(YogaNode child) {
        return this.mChildren == null ? -1 : this.mChildren.indexOf(child);
    }

    @Override
    public void calculateLayout(float width, float height) {
        int i;
        long[] nativePointers = null;
        YogaNodeJNIBase[] nodes = null;
        this.freeze(null);
        ArrayList<YogaNodeJNIBase> n = new ArrayList<YogaNodeJNIBase>();
        n.add(this);
        for (i = 0; i < n.size(); ++i) {
            YogaNodeJNIBase parent = (YogaNodeJNIBase)n.get(i);
            List<YogaNodeJNIBase> children = parent.mChildren;
            if (children == null) continue;
            for (YogaNodeJNIBase child : children) {
                child.freeze(parent);
                n.add(child);
            }
        }
        nodes = n.toArray(new YogaNodeJNIBase[n.size()]);
        nativePointers = new long[nodes.length];
        for (i = 0; i < nodes.length; ++i) {
            nativePointers[i] = nodes[i].mNativePointer;
        }
        YogaNative.jni_YGNodeCalculateLayoutJNI(this.mNativePointer, width, height, nativePointers, nodes);
    }

    private void freeze(YogaNode parent) {
        Object data = this.getData();
        if (data instanceof YogaNode.Inputs) {
            ((YogaNode.Inputs)data).freeze(this, parent);
        }
    }

    @Override
    public void dirty() {
        YogaNative.jni_YGNodeMarkDirtyJNI(this.mNativePointer);
    }

    public void dirtyAllDescendants() {
        YogaNative.jni_YGNodeMarkDirtyAndPropogateToDescendantsJNI(this.mNativePointer);
    }

    @Override
    public boolean isDirty() {
        return YogaNative.jni_YGNodeIsDirtyJNI(this.mNativePointer);
    }

    @Override
    public void copyStyle(YogaNode srcNode) {
        if (!(srcNode instanceof YogaNodeJNIBase)) {
            return;
        }
        YogaNative.jni_YGNodeCopyStyleJNI(this.mNativePointer, ((YogaNodeJNIBase)srcNode).mNativePointer);
    }

    @Override
    public YogaDirection getStyleDirection() {
        return YogaDirection.fromInt(YogaNative.jni_YGNodeStyleGetDirectionJNI(this.mNativePointer));
    }

    @Override
    public void setDirection(YogaDirection direction) {
        YogaNative.jni_YGNodeStyleSetDirectionJNI(this.mNativePointer, direction.intValue());
    }

    @Override
    public YogaFlexDirection getFlexDirection() {
        return YogaFlexDirection.fromInt(YogaNative.jni_YGNodeStyleGetFlexDirectionJNI(this.mNativePointer));
    }

    @Override
    public void setFlexDirection(YogaFlexDirection flexDirection) {
        YogaNative.jni_YGNodeStyleSetFlexDirectionJNI(this.mNativePointer, flexDirection.intValue());
    }

    @Override
    public YogaJustify getJustifyContent() {
        return YogaJustify.fromInt(YogaNative.jni_YGNodeStyleGetJustifyContentJNI(this.mNativePointer));
    }

    @Override
    public void setJustifyContent(YogaJustify justifyContent) {
        YogaNative.jni_YGNodeStyleSetJustifyContentJNI(this.mNativePointer, justifyContent.intValue());
    }

    @Override
    public YogaAlign getAlignItems() {
        return YogaAlign.fromInt(YogaNative.jni_YGNodeStyleGetAlignItemsJNI(this.mNativePointer));
    }

    @Override
    public void setAlignItems(YogaAlign alignItems) {
        YogaNative.jni_YGNodeStyleSetAlignItemsJNI(this.mNativePointer, alignItems.intValue());
    }

    @Override
    public YogaAlign getAlignSelf() {
        return YogaAlign.fromInt(YogaNative.jni_YGNodeStyleGetAlignSelfJNI(this.mNativePointer));
    }

    @Override
    public void setAlignSelf(YogaAlign alignSelf) {
        YogaNative.jni_YGNodeStyleSetAlignSelfJNI(this.mNativePointer, alignSelf.intValue());
    }

    @Override
    public YogaAlign getAlignContent() {
        return YogaAlign.fromInt(YogaNative.jni_YGNodeStyleGetAlignContentJNI(this.mNativePointer));
    }

    @Override
    public void setAlignContent(YogaAlign alignContent) {
        YogaNative.jni_YGNodeStyleSetAlignContentJNI(this.mNativePointer, alignContent.intValue());
    }

    @Override
    public YogaPositionType getPositionType() {
        return YogaPositionType.fromInt(YogaNative.jni_YGNodeStyleGetPositionTypeJNI(this.mNativePointer));
    }

    @Override
    public void setPositionType(YogaPositionType positionType) {
        YogaNative.jni_YGNodeStyleSetPositionTypeJNI(this.mNativePointer, positionType.intValue());
    }

    @Override
    public YogaWrap getWrap() {
        return YogaWrap.fromInt(YogaNative.jni_YGNodeStyleGetFlexWrapJNI(this.mNativePointer));
    }

    @Override
    public void setWrap(YogaWrap flexWrap) {
        YogaNative.jni_YGNodeStyleSetFlexWrapJNI(this.mNativePointer, flexWrap.intValue());
    }

    @Override
    public YogaOverflow getOverflow() {
        return YogaOverflow.fromInt(YogaNative.jni_YGNodeStyleGetOverflowJNI(this.mNativePointer));
    }

    @Override
    public void setOverflow(YogaOverflow overflow) {
        YogaNative.jni_YGNodeStyleSetOverflowJNI(this.mNativePointer, overflow.intValue());
    }

    @Override
    public YogaDisplay getDisplay() {
        return YogaDisplay.fromInt(YogaNative.jni_YGNodeStyleGetDisplayJNI(this.mNativePointer));
    }

    @Override
    public void setDisplay(YogaDisplay display) {
        YogaNative.jni_YGNodeStyleSetDisplayJNI(this.mNativePointer, display.intValue());
    }

    @Override
    public float getFlex() {
        return YogaNative.jni_YGNodeStyleGetFlexJNI(this.mNativePointer);
    }

    @Override
    public void setFlex(float flex) {
        YogaNative.jni_YGNodeStyleSetFlexJNI(this.mNativePointer, flex);
    }

    @Override
    public float getFlexGrow() {
        return YogaNative.jni_YGNodeStyleGetFlexGrowJNI(this.mNativePointer);
    }

    @Override
    public void setFlexGrow(float flexGrow) {
        YogaNative.jni_YGNodeStyleSetFlexGrowJNI(this.mNativePointer, flexGrow);
    }

    @Override
    public float getFlexShrink() {
        return YogaNative.jni_YGNodeStyleGetFlexShrinkJNI(this.mNativePointer);
    }

    @Override
    public void setFlexShrink(float flexShrink) {
        YogaNative.jni_YGNodeStyleSetFlexShrinkJNI(this.mNativePointer, flexShrink);
    }

    @Override
    public YogaValue getFlexBasis() {
        return YogaNodeJNIBase.valueFromLong(YogaNative.jni_YGNodeStyleGetFlexBasisJNI(this.mNativePointer));
    }

    @Override
    public void setFlexBasis(float flexBasis) {
        YogaNative.jni_YGNodeStyleSetFlexBasisJNI(this.mNativePointer, flexBasis);
    }

    @Override
    public void setFlexBasisPercent(float percent) {
        YogaNative.jni_YGNodeStyleSetFlexBasisPercentJNI(this.mNativePointer, percent);
    }

    @Override
    public void setFlexBasisAuto() {
        YogaNative.jni_YGNodeStyleSetFlexBasisAutoJNI(this.mNativePointer);
    }

    @Override
    public YogaValue getMargin(YogaEdge edge) {
        return YogaNodeJNIBase.valueFromLong(YogaNative.jni_YGNodeStyleGetMarginJNI(this.mNativePointer, edge.intValue()));
    }

    @Override
    public void setMargin(YogaEdge edge, float margin) {
        YogaNative.jni_YGNodeStyleSetMarginJNI(this.mNativePointer, edge.intValue(), margin);
    }

    @Override
    public void setMarginPercent(YogaEdge edge, float percent) {
        YogaNative.jni_YGNodeStyleSetMarginPercentJNI(this.mNativePointer, edge.intValue(), percent);
    }

    @Override
    public void setMarginAuto(YogaEdge edge) {
        YogaNative.jni_YGNodeStyleSetMarginAutoJNI(this.mNativePointer, edge.intValue());
    }

    @Override
    public YogaValue getPadding(YogaEdge edge) {
        return YogaNodeJNIBase.valueFromLong(YogaNative.jni_YGNodeStyleGetPaddingJNI(this.mNativePointer, edge.intValue()));
    }

    @Override
    public void setPadding(YogaEdge edge, float padding) {
        YogaNative.jni_YGNodeStyleSetPaddingJNI(this.mNativePointer, edge.intValue(), padding);
    }

    @Override
    public void setPaddingPercent(YogaEdge edge, float percent) {
        YogaNative.jni_YGNodeStyleSetPaddingPercentJNI(this.mNativePointer, edge.intValue(), percent);
    }

    @Override
    public float getBorder(YogaEdge edge) {
        return YogaNative.jni_YGNodeStyleGetBorderJNI(this.mNativePointer, edge.intValue());
    }

    @Override
    public void setBorder(YogaEdge edge, float border) {
        YogaNative.jni_YGNodeStyleSetBorderJNI(this.mNativePointer, edge.intValue(), border);
    }

    @Override
    public YogaValue getPosition(YogaEdge edge) {
        return YogaNodeJNIBase.valueFromLong(YogaNative.jni_YGNodeStyleGetPositionJNI(this.mNativePointer, edge.intValue()));
    }

    @Override
    public void setPosition(YogaEdge edge, float position) {
        YogaNative.jni_YGNodeStyleSetPositionJNI(this.mNativePointer, edge.intValue(), position);
    }

    @Override
    public void setPositionPercent(YogaEdge edge, float percent) {
        YogaNative.jni_YGNodeStyleSetPositionPercentJNI(this.mNativePointer, edge.intValue(), percent);
    }

    @Override
    public YogaValue getWidth() {
        return YogaNodeJNIBase.valueFromLong(YogaNative.jni_YGNodeStyleGetWidthJNI(this.mNativePointer));
    }

    @Override
    public void setWidth(float width) {
        YogaNative.jni_YGNodeStyleSetWidthJNI(this.mNativePointer, width);
    }

    @Override
    public void setWidthPercent(float percent) {
        YogaNative.jni_YGNodeStyleSetWidthPercentJNI(this.mNativePointer, percent);
    }

    @Override
    public void setWidthAuto() {
        YogaNative.jni_YGNodeStyleSetWidthAutoJNI(this.mNativePointer);
    }

    @Override
    public YogaValue getHeight() {
        return YogaNodeJNIBase.valueFromLong(YogaNative.jni_YGNodeStyleGetHeightJNI(this.mNativePointer));
    }

    @Override
    public void setHeight(float height) {
        YogaNative.jni_YGNodeStyleSetHeightJNI(this.mNativePointer, height);
    }

    @Override
    public void setHeightPercent(float percent) {
        YogaNative.jni_YGNodeStyleSetHeightPercentJNI(this.mNativePointer, percent);
    }

    @Override
    public void setHeightAuto() {
        YogaNative.jni_YGNodeStyleSetHeightAutoJNI(this.mNativePointer);
    }

    @Override
    public YogaValue getMinWidth() {
        return YogaNodeJNIBase.valueFromLong(YogaNative.jni_YGNodeStyleGetMinWidthJNI(this.mNativePointer));
    }

    @Override
    public void setMinWidth(float minWidth) {
        YogaNative.jni_YGNodeStyleSetMinWidthJNI(this.mNativePointer, minWidth);
    }

    @Override
    public void setMinWidthPercent(float percent) {
        YogaNative.jni_YGNodeStyleSetMinWidthPercentJNI(this.mNativePointer, percent);
    }

    @Override
    public YogaValue getMinHeight() {
        return YogaNodeJNIBase.valueFromLong(YogaNative.jni_YGNodeStyleGetMinHeightJNI(this.mNativePointer));
    }

    @Override
    public void setMinHeight(float minHeight) {
        YogaNative.jni_YGNodeStyleSetMinHeightJNI(this.mNativePointer, minHeight);
    }

    @Override
    public void setMinHeightPercent(float percent) {
        YogaNative.jni_YGNodeStyleSetMinHeightPercentJNI(this.mNativePointer, percent);
    }

    @Override
    public YogaValue getMaxWidth() {
        return YogaNodeJNIBase.valueFromLong(YogaNative.jni_YGNodeStyleGetMaxWidthJNI(this.mNativePointer));
    }

    @Override
    public void setMaxWidth(float maxWidth) {
        YogaNative.jni_YGNodeStyleSetMaxWidthJNI(this.mNativePointer, maxWidth);
    }

    @Override
    public void setMaxWidthPercent(float percent) {
        YogaNative.jni_YGNodeStyleSetMaxWidthPercentJNI(this.mNativePointer, percent);
    }

    @Override
    public YogaValue getMaxHeight() {
        return YogaNodeJNIBase.valueFromLong(YogaNative.jni_YGNodeStyleGetMaxHeightJNI(this.mNativePointer));
    }

    @Override
    public void setMaxHeight(float maxheight) {
        YogaNative.jni_YGNodeStyleSetMaxHeightJNI(this.mNativePointer, maxheight);
    }

    @Override
    public void setMaxHeightPercent(float percent) {
        YogaNative.jni_YGNodeStyleSetMaxHeightPercentJNI(this.mNativePointer, percent);
    }

    @Override
    public float getAspectRatio() {
        return YogaNative.jni_YGNodeStyleGetAspectRatioJNI(this.mNativePointer);
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        YogaNative.jni_YGNodeStyleSetAspectRatioJNI(this.mNativePointer, aspectRatio);
    }

    @Override
    public void setMeasureFunction(YogaMeasureFunction measureFunction) {
        this.mMeasureFunction = measureFunction;
        YogaNative.jni_YGNodeSetHasMeasureFuncJNI(this.mNativePointer, measureFunction != null);
    }

    @DoNotStrip
    public final long measure(float width, int widthMode, float height, int heightMode) {
        if (!this.isMeasureDefined()) {
            throw new RuntimeException("Measure function isn't defined!");
        }
        return this.mMeasureFunction.measure(this, width, YogaMeasureMode.fromInt(widthMode), height, YogaMeasureMode.fromInt(heightMode));
    }

    @Override
    public void setBaselineFunction(YogaBaselineFunction baselineFunction) {
        this.mBaselineFunction = baselineFunction;
        YogaNative.jni_YGNodeSetHasBaselineFuncJNI(this.mNativePointer, baselineFunction != null);
    }

    @DoNotStrip
    public final float baseline(float width, float height) {
        return this.mBaselineFunction.baseline(this, width, height);
    }

    @Override
    public boolean isMeasureDefined() {
        return this.mMeasureFunction != null;
    }

    @Override
    public boolean isBaselineDefined() {
        return this.mBaselineFunction != null;
    }

    @Override
    public void setData(Object data) {
        this.mData = data;
    }

    @Override
    @Nullable
    public Object getData() {
        return this.mData;
    }

    @Override
    public void print() {
        YogaNative.jni_YGNodePrintJNI(this.mNativePointer);
    }

    @DoNotStrip
    private final long replaceChild(YogaNodeJNIBase newNode, int childIndex) {
        if (this.mChildren == null) {
            throw new IllegalStateException("Cannot replace child. YogaNode does not have children");
        }
        this.mChildren.remove(childIndex);
        this.mChildren.add(childIndex, newNode);
        newNode.mOwner = this;
        return newNode.mNativePointer;
    }

    private static YogaValue valueFromLong(long raw) {
        return new YogaValue(Float.intBitsToFloat((int)raw), (int)(raw >> 32));
    }

    @Override
    public float getLayoutX() {
        return this.arr != null ? this.arr[3] : 0.0f;
    }

    @Override
    public float getLayoutY() {
        return this.arr != null ? this.arr[4] : 0.0f;
    }

    @Override
    public float getLayoutWidth() {
        return this.arr != null ? this.arr[1] : 0.0f;
    }

    @Override
    public float getLayoutHeight() {
        return this.arr != null ? this.arr[2] : 0.0f;
    }

    public boolean getDoesLegacyStretchFlagAffectsLayout() {
        return this.arr != null && ((int)this.arr[0] & 8) == 8;
    }

    @Override
    public float getLayoutMargin(YogaEdge edge) {
        if (this.arr != null && ((int)this.arr[0] & 1) == 1) {
            switch (edge) {
                case LEFT: {
                    return this.arr[6];
                }
                case TOP: {
                    return this.arr[7];
                }
                case RIGHT: {
                    return this.arr[8];
                }
                case BOTTOM: {
                    return this.arr[9];
                }
                case START: {
                    return this.getLayoutDirection() == YogaDirection.RTL ? this.arr[8] : this.arr[6];
                }
                case END: {
                    return this.getLayoutDirection() == YogaDirection.RTL ? this.arr[6] : this.arr[8];
                }
            }
            throw new IllegalArgumentException("Cannot get layout margins of multi-edge shorthands");
        }
        return 0.0f;
    }

    @Override
    public float getLayoutPadding(YogaEdge edge) {
        if (this.arr != null && ((int)this.arr[0] & 2) == 2) {
            int paddingStartIndex = 10 - (((int)this.arr[0] & 1) == 1 ? 0 : 4);
            switch (edge) {
                case LEFT: {
                    return this.arr[paddingStartIndex];
                }
                case TOP: {
                    return this.arr[paddingStartIndex + 1];
                }
                case RIGHT: {
                    return this.arr[paddingStartIndex + 2];
                }
                case BOTTOM: {
                    return this.arr[paddingStartIndex + 3];
                }
                case START: {
                    return this.getLayoutDirection() == YogaDirection.RTL ? this.arr[paddingStartIndex + 2] : this.arr[paddingStartIndex];
                }
                case END: {
                    return this.getLayoutDirection() == YogaDirection.RTL ? this.arr[paddingStartIndex] : this.arr[paddingStartIndex + 2];
                }
            }
            throw new IllegalArgumentException("Cannot get layout paddings of multi-edge shorthands");
        }
        return 0.0f;
    }

    @Override
    public float getLayoutBorder(YogaEdge edge) {
        if (this.arr != null && ((int)this.arr[0] & 4) == 4) {
            int borderStartIndex = 14 - (((int)this.arr[0] & 1) == 1 ? 0 : 4) - (((int)this.arr[0] & 2) == 2 ? 0 : 4);
            switch (edge) {
                case LEFT: {
                    return this.arr[borderStartIndex];
                }
                case TOP: {
                    return this.arr[borderStartIndex + 1];
                }
                case RIGHT: {
                    return this.arr[borderStartIndex + 2];
                }
                case BOTTOM: {
                    return this.arr[borderStartIndex + 3];
                }
                case START: {
                    return this.getLayoutDirection() == YogaDirection.RTL ? this.arr[borderStartIndex + 2] : this.arr[borderStartIndex];
                }
                case END: {
                    return this.getLayoutDirection() == YogaDirection.RTL ? this.arr[borderStartIndex] : this.arr[borderStartIndex + 2];
                }
            }
            throw new IllegalArgumentException("Cannot get layout border of multi-edge shorthands");
        }
        return 0.0f;
    }

    @Override
    public YogaDirection getLayoutDirection() {
        return YogaDirection.fromInt(this.arr != null ? (int)this.arr[5] : this.mLayoutDirection);
    }

    @Override
    public boolean hasNewLayout() {
        if (this.arr != null) {
            return ((int)this.arr[0] & 0x10) == 16;
        }
        return this.mHasNewLayout;
    }

    @Override
    public void markLayoutSeen() {
        if (this.arr != null) {
            this.arr[0] = (int)this.arr[0] & 0xFFFFFFEF;
        }
        this.mHasNewLayout = false;
    }

    @Override
    public float getGap(YogaGutter gutter) {
        return YogaNative.jni_YGNodeStyleGetGapJNI(this.mNativePointer, gutter.intValue());
    }

    @Override
    public void setGap(YogaGutter gutter, float gapLength) {
        YogaNative.jni_YGNodeStyleSetGapJNI(this.mNativePointer, gutter.intValue(), gapLength);
    }
}

