/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.intent;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.facebook.fbreact.specs.NativeIntentAndroidSpec;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.module.annotations.ReactModule;
import java.io.Serializable;

@ReactModule(name="IntentAndroid")
public class IntentModule
extends NativeIntentAndroidSpec {
    public static final String NAME = "IntentAndroid";
    private static final String EXTRA_MAP_KEY_FOR_VALUE = "value";

    public IntentModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void getInitialURL(Promise promise) {
        try {
            Activity currentActivity = this.getCurrentActivity();
            String initialURL = null;
            if (currentActivity != null) {
                Intent intent = currentActivity.getIntent();
                String action = intent.getAction();
                Uri uri = intent.getData();
                if (uri != null && ("android.intent.action.VIEW".equals(action) || "android.nfc.action.NDEF_DISCOVERED".equals(action))) {
                    initialURL = uri.toString();
                }
            }
            promise.resolve(initialURL);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not get the initial URL : " + e.getMessage()));
        }
    }

    @Override
    public void openURL(String url, Promise promise) {
        if (url == null || url.isEmpty()) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid URL: " + url));
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url).normalizeScheme());
            this.sendOSIntent(intent, false);
            promise.resolve(true);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not open URL '" + url + "': " + e.getMessage()));
        }
    }

    @Override
    public void canOpenURL(String url, Promise promise) {
        if (url == null || url.isEmpty()) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid URL: " + url));
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            boolean canOpen = intent.resolveActivity(this.getReactApplicationContext().getPackageManager()) != null;
            promise.resolve(canOpen);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not check if URL '" + url + "' can be opened: " + e.getMessage()));
        }
    }

    @Override
    public void openSettings(Promise promise) {
        try {
            Intent intent = new Intent();
            Activity currentActivity = this.getCurrentActivity();
            String selfPackageName = this.getReactApplicationContext().getPackageName();
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.setData(Uri.parse((String)("package:" + selfPackageName)));
            intent.addFlags(0x10000000);
            intent.addFlags(0x40000000);
            intent.addFlags(0x800000);
            currentActivity.startActivity(intent);
            promise.resolve(true);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not open the Settings: " + e.getMessage()));
        }
    }

    @Override
    public void sendIntent(String action, @Nullable ReadableArray extras, Promise promise) {
        if (action == null || action.isEmpty()) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid Action: " + action + "."));
            return;
        }
        Intent intent = new Intent(action);
        PackageManager packageManager = this.getReactApplicationContext().getPackageManager();
        if (intent.resolveActivity(packageManager) == null) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not launch Intent with action " + action + "."));
            return;
        }
        if (extras != null) {
            block5: for (int i = 0; i < extras.size(); ++i) {
                ReadableMap map = extras.getMap(i);
                String name = map.getString("key");
                ReadableType type = map.getType(EXTRA_MAP_KEY_FOR_VALUE);
                switch (type) {
                    case String: {
                        intent.putExtra(name, map.getString(EXTRA_MAP_KEY_FOR_VALUE));
                        continue block5;
                    }
                    case Number: {
                        Double number = map.getDouble(EXTRA_MAP_KEY_FOR_VALUE);
                        intent.putExtra(name, (Serializable)number);
                        continue block5;
                    }
                    case Boolean: {
                        intent.putExtra(name, map.getBoolean(EXTRA_MAP_KEY_FOR_VALUE));
                        continue block5;
                    }
                    default: {
                        promise.reject(new JSApplicationIllegalArgumentException("Extra type for " + name + " not supported."));
                        return;
                    }
                }
            }
        }
        this.sendOSIntent(intent, true);
    }

    private void sendOSIntent(Intent intent, Boolean useNewTaskFlag) {
        String otherPackageName;
        Activity currentActivity = this.getCurrentActivity();
        String selfPackageName = this.getReactApplicationContext().getPackageName();
        ComponentName componentName = intent.resolveActivity(this.getReactApplicationContext().getPackageManager());
        String string2 = otherPackageName = componentName != null ? componentName.getPackageName() : "";
        if (useNewTaskFlag.booleanValue() || currentActivity == null || !selfPackageName.equals(otherPackageName)) {
            intent.addFlags(0x10000000);
        }
        if (currentActivity != null) {
            currentActivity.startActivity(intent);
        } else {
            this.getReactApplicationContext().startActivity(intent);
        }
    }
}

