/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.ValueCallback;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.ReactContext;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ForwardingCookieHandler
extends CookieHandler {
    private static final String VERSION_ZERO_HEADER = "Set-cookie";
    private static final String VERSION_ONE_HEADER = "Set-cookie2";
    private static final String COOKIE_HEADER = "Cookie";
    private final CookieSaver mCookieSaver;
    private final ReactContext mContext;
    @Nullable
    private CookieManager mCookieManager;

    public ForwardingCookieHandler(ReactContext context) {
        this.mContext = context;
        this.mCookieSaver = new CookieSaver();
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> headers) throws IOException {
        CookieManager cookieManager = this.getCookieManager();
        if (cookieManager == null) {
            return Collections.emptyMap();
        }
        String cookies = cookieManager.getCookie(uri.toString());
        if (TextUtils.isEmpty((CharSequence)cookies)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(COOKIE_HEADER, Collections.singletonList(cookies));
    }

    @Override
    public void put(URI uri, Map<String, List<String>> headers) throws IOException {
        String url = uri.toString();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null || !ForwardingCookieHandler.isCookieHeader(key)) continue;
            this.addCookies(url, entry.getValue());
        }
    }

    public void clearCookies(Callback callback) {
        this.clearCookiesAsync(callback);
    }

    @TargetApi(value=21)
    private void clearCookiesAsync(final Callback callback) {
        CookieManager cookieManager = this.getCookieManager();
        if (cookieManager != null) {
            cookieManager.removeAllCookies((ValueCallback)new ValueCallback<Boolean>(){

                public void onReceiveValue(Boolean value) {
                    ForwardingCookieHandler.this.mCookieSaver.onCookiesModified();
                    callback.invoke(value);
                }
            });
        }
    }

    public void destroy() {
    }

    public void addCookies(String url, List<String> cookies) {
        CookieManager cookieManager = this.getCookieManager();
        if (cookieManager == null) {
            return;
        }
        for (String cookie : cookies) {
            this.addCookieAsync(url, cookie);
        }
        cookieManager.flush();
        this.mCookieSaver.onCookiesModified();
    }

    @TargetApi(value=21)
    private void addCookieAsync(String url, String cookie) {
        CookieManager cookieManager = this.getCookieManager();
        if (cookieManager != null) {
            cookieManager.setCookie(url, cookie, null);
        }
    }

    private static boolean isCookieHeader(String name) {
        return name.equalsIgnoreCase(VERSION_ZERO_HEADER) || name.equalsIgnoreCase(VERSION_ONE_HEADER);
    }

    private void runInBackground(final Runnable runnable) {
        new GuardedAsyncTask<Void, Void>(this.mContext){

            protected void doInBackgroundGuarded(Void ... params) {
                runnable.run();
            }
        }.execute(new Void[0]);
    }

    @Nullable
    private CookieManager getCookieManager() {
        if (this.mCookieManager == null) {
            ForwardingCookieHandler.possiblyWorkaroundSyncManager((Context)this.mContext);
            try {
                this.mCookieManager = CookieManager.getInstance();
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.mCookieManager;
    }

    private static void possiblyWorkaroundSyncManager(Context context) {
    }

    private class CookieSaver {
        private static final int MSG_PERSIST_COOKIES = 1;
        private static final int TIMEOUT = 30000;
        private final Handler mHandler;

        public CookieSaver() {
            this.mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    if (msg.what == 1) {
                        CookieSaver.this.persistCookies();
                        return true;
                    }
                    return false;
                }
            });
        }

        public void onCookiesModified() {
        }

        public void persistCookies() {
            this.mHandler.removeMessages(1);
            ForwardingCookieHandler.this.runInBackground(new Runnable(){

                @Override
                public void run() {
                    CookieSaver.this.flush();
                }
            });
        }

        @TargetApi(value=21)
        private void flush() {
            CookieManager cookieManager = ForwardingCookieHandler.this.getCookieManager();
            if (cookieManager != null) {
                cookieManager.flush();
            }
        }
    }
}

