/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.turbomodule.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.CxxModuleWrapper;
import com.facebook.react.bridge.JSIModule;
import com.facebook.react.bridge.RuntimeExecutor;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.turbomodule.core.CallInvokerHolderImpl;
import com.facebook.react.turbomodule.core.TurboModuleManagerDelegate;
import com.facebook.react.turbomodule.core.TurboModulePerfLogger;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.react.turbomodule.core.interfaces.TurboModuleRegistry;
import com.facebook.soloader.SoLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TurboModuleManager
implements JSIModule,
TurboModuleRegistry {
    private static volatile boolean sIsSoLibraryLoaded;
    private final List<String> mEagerInitModuleNames;
    private final TurboModuleProvider mJavaModuleProvider;
    private final TurboModuleProvider mCxxModuleProvider;
    private final Object mTurboModuleCleanupLock = new Object();
    @GuardedBy(value="mTurboModuleCleanupLock")
    private boolean mTurboModuleCleanupStarted = false;
    @GuardedBy(value="mTurboModuleCleanupLock")
    private final Map<String, TurboModuleHolder> mTurboModuleHolders = new HashMap<String, TurboModuleHolder>();
    @DoNotStrip
    private final HybridData mHybridData;

    public TurboModuleManager(RuntimeExecutor runtimeExecutor, final @Nullable TurboModuleManagerDelegate delegate, CallInvokerHolder jsCallInvokerHolder, CallInvokerHolder nativeCallInvokerHolder) {
        TurboModuleManager.maybeLoadSoLibrary();
        this.mHybridData = this.initHybrid(runtimeExecutor, (CallInvokerHolderImpl)jsCallInvokerHolder, (CallInvokerHolderImpl)nativeCallInvokerHolder, delegate, ReactFeatureFlags.useGlobalCallbackCleanupScopeUsingRetainJSCallback, ReactFeatureFlags.useTurboModuleManagerCallbackCleanupScope);
        this.installJSIBindings();
        this.mEagerInitModuleNames = delegate == null ? new ArrayList() : delegate.getEagerInitModuleNames();
        this.mJavaModuleProvider = new TurboModuleProvider(){

            @Override
            @Nullable
            public TurboModule getModule(String moduleName) {
                if (delegate == null) {
                    return null;
                }
                return delegate.getModule(moduleName);
            }
        };
        this.mCxxModuleProvider = new TurboModuleProvider(){

            @Override
            @Nullable
            public TurboModule getModule(String moduleName) {
                if (delegate == null) {
                    return null;
                }
                CxxModuleWrapper nativeModule = delegate.getLegacyCxxModule(moduleName);
                if (nativeModule != null) {
                    Assertions.assertCondition((boolean)(nativeModule instanceof TurboModule), (String)("CxxModuleWrapper \"" + moduleName + "\" is not a TurboModule"));
                    return (TurboModule)((Object)nativeModule);
                }
                return null;
            }
        };
    }

    @Override
    public List<String> getEagerInitModuleNames() {
        return this.mEagerInitModuleNames;
    }

    @DoNotStrip
    @Nullable
    private CxxModuleWrapper getLegacyCxxModule(String moduleName) {
        TurboModule turboModule = this.getModule(moduleName);
        if (!(turboModule instanceof CxxModuleWrapper)) {
            return null;
        }
        return (CxxModuleWrapper)((Object)turboModule);
    }

    @DoNotStrip
    @Nullable
    private TurboModule getJavaModule(String moduleName) {
        TurboModule turboModule = this.getModule(moduleName);
        if (turboModule instanceof CxxModuleWrapper) {
            return null;
        }
        return turboModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TurboModule getModule(String moduleName) {
        TurboModuleHolder moduleHolder;
        Object object = this.mTurboModuleCleanupLock;
        synchronized (object) {
            if (this.mTurboModuleCleanupStarted) {
                return null;
            }
            if (!this.mTurboModuleHolders.containsKey(moduleName)) {
                this.mTurboModuleHolders.put(moduleName, new TurboModuleHolder());
            }
            moduleHolder = this.mTurboModuleHolders.get(moduleName);
        }
        TurboModulePerfLogger.moduleCreateStart(moduleName, moduleHolder.getModuleId());
        TurboModule module = this.getModule(moduleName, moduleHolder, true);
        if (module != null) {
            TurboModulePerfLogger.moduleCreateEnd(moduleName, moduleHolder.getModuleId());
        } else {
            TurboModulePerfLogger.moduleCreateFail(moduleName, moduleHolder.getModuleId());
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TurboModule getModule(String moduleName, @NonNull TurboModuleHolder moduleHolder, boolean shouldPerfLog) {
        boolean shouldCreateModule = false;
        TurboModuleHolder turboModuleHolder = moduleHolder;
        synchronized (turboModuleHolder) {
            if (moduleHolder.isDoneCreatingModule()) {
                if (shouldPerfLog) {
                    TurboModulePerfLogger.moduleCreateCacheHit(moduleName, moduleHolder.getModuleId());
                }
                return moduleHolder.getModule();
            }
            if (!moduleHolder.isCreatingModule()) {
                shouldCreateModule = true;
                moduleHolder.startCreatingModule();
            }
        }
        if (shouldCreateModule) {
            TurboModuleHolder turboModuleHolder2;
            TurboModulePerfLogger.moduleCreateConstructStart(moduleName, moduleHolder.getModuleId());
            TurboModule turboModule = this.mJavaModuleProvider.getModule(moduleName);
            if (turboModule == null) {
                turboModule = this.mCxxModuleProvider.getModule(moduleName);
            }
            TurboModulePerfLogger.moduleCreateConstructEnd(moduleName, moduleHolder.getModuleId());
            TurboModulePerfLogger.moduleCreateSetUpStart(moduleName, moduleHolder.getModuleId());
            if (turboModule != null) {
                turboModuleHolder2 = moduleHolder;
                synchronized (turboModuleHolder2) {
                    moduleHolder.setModule(turboModule);
                }
                turboModule.initialize();
            }
            TurboModulePerfLogger.moduleCreateSetUpEnd(moduleName, moduleHolder.getModuleId());
            turboModuleHolder2 = moduleHolder;
            synchronized (turboModuleHolder2) {
                moduleHolder.endCreatingModule();
                moduleHolder.notifyAll();
            }
            return turboModule;
        }
        turboModuleHolder = moduleHolder;
        synchronized (turboModuleHolder) {
            boolean wasInterrupted = false;
            while (moduleHolder.isCreatingModule()) {
                try {
                    moduleHolder.wait();
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            return moduleHolder.getModule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TurboModule> getModules() {
        ArrayList<TurboModuleHolder> turboModuleHolders = new ArrayList<TurboModuleHolder>();
        Object object = this.mTurboModuleCleanupLock;
        synchronized (object) {
            turboModuleHolders.addAll(this.mTurboModuleHolders.values());
        }
        ArrayList<TurboModule> turboModules = new ArrayList<TurboModule>();
        Iterator iterator2 = turboModuleHolders.iterator();
        while (iterator2.hasNext()) {
            TurboModuleHolder moduleHolder;
            TurboModuleHolder turboModuleHolder = moduleHolder = (TurboModuleHolder)iterator2.next();
            synchronized (turboModuleHolder) {
                if (moduleHolder.getModule() != null) {
                    turboModules.add(moduleHolder.getModule());
                }
            }
        }
        return turboModules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasModule(String moduleName) {
        TurboModuleHolder moduleHolder;
        Object object = this.mTurboModuleCleanupLock;
        synchronized (object) {
            moduleHolder = this.mTurboModuleHolders.get(moduleName);
        }
        if (moduleHolder != null) {
            object = moduleHolder;
            synchronized (object) {
                if (moduleHolder.getModule() != null) {
                    return true;
                }
            }
        }
        return false;
    }

    private native HybridData initHybrid(RuntimeExecutor var1, CallInvokerHolderImpl var2, CallInvokerHolderImpl var3, TurboModuleManagerDelegate var4, boolean var5, boolean var6);

    private native void installJSIBindings();

    @Override
    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCatalystInstanceDestroy() {
        Iterator<Map.Entry<String, TurboModuleHolder>> iterator2 = this.mTurboModuleCleanupLock;
        synchronized (iterator2) {
            this.mTurboModuleCleanupStarted = true;
        }
        for (Map.Entry<String, TurboModuleHolder> moduleHolderEntry : this.mTurboModuleHolders.entrySet()) {
            TurboModuleHolder moduleHolder;
            String moduleName = moduleHolderEntry.getKey();
            TurboModule turboModule = this.getModule(moduleName, moduleHolder = moduleHolderEntry.getValue(), false);
            if (turboModule == null) continue;
            turboModule.invalidate();
        }
        this.mTurboModuleHolders.clear();
        this.mHybridData.resetNative();
    }

    private static synchronized void maybeLoadSoLibrary() {
        if (!sIsSoLibraryLoaded) {
            SoLoader.loadLibrary((String)"turbomodulejsijni");
            sIsSoLibraryLoaded = true;
        }
    }

    private static interface TurboModuleProvider {
        @Nullable
        public TurboModule getModule(String var1);
    }

    private static class TurboModuleHolder {
        private volatile TurboModule mModule = null;
        private volatile boolean mIsTryingToCreate = false;
        private volatile boolean mIsDoneCreatingModule = false;
        private static volatile int sHolderCount = 0;
        private volatile int mModuleId = sHolderCount++;

        int getModuleId() {
            return this.mModuleId;
        }

        void setModule(@NonNull TurboModule module) {
            this.mModule = module;
        }

        @Nullable
        TurboModule getModule() {
            return this.mModule;
        }

        void startCreatingModule() {
            this.mIsTryingToCreate = true;
        }

        void endCreatingModule() {
            this.mIsTryingToCreate = false;
            this.mIsDoneCreatingModule = true;
        }

        boolean isDoneCreatingModule() {
            return this.mIsDoneCreatingModule;
        }

        boolean isCreatingModule() {
            return this.mIsTryingToCreate;
        }
    }
}

