/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.graphics.Typeface;
import android.os.Build;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class TypefaceStyle {
    public static final int BOLD = 700;
    public static final int NORMAL = 400;
    private static final int MIN_WEIGHT = 1;
    private static final int MAX_WEIGHT = 1000;
    private final boolean mItalic;
    private final int mWeight;

    public TypefaceStyle(int weight, boolean italic) {
        this.mItalic = italic;
        this.mWeight = weight == -1 ? 400 : weight;
    }

    public TypefaceStyle(int style2) {
        if (style2 == -1) {
            style2 = 0;
        }
        this.mItalic = (style2 & 2) != 0;
        this.mWeight = (style2 & 1) != 0 ? 700 : 400;
    }

    public TypefaceStyle(int style2, int weight) {
        if (style2 == -1) {
            style2 = 0;
        }
        boolean bl = this.mItalic = (style2 & 2) != 0;
        this.mWeight = weight == -1 ? ((style2 & 1) != 0 ? 700 : 400) : weight;
    }

    public int getNearestStyle() {
        if (this.mWeight < 700) {
            return this.mItalic ? 2 : 0;
        }
        return this.mItalic ? 3 : 1;
    }

    public Typeface apply(Typeface typeface) {
        if (Build.VERSION.SDK_INT < 28) {
            return Typeface.create((Typeface)typeface, (int)this.getNearestStyle());
        }
        return Typeface.create((Typeface)typeface, (int)this.mWeight, (boolean)this.mItalic);
    }
}

