/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.react.CoreModulesPackage;
import com.facebook.react.DebugCorePackage;
import com.facebook.react.MemoryPressureRouter;
import com.facebook.react.NativeModuleRegistryBuilder;
import com.facebook.react.ReactInstanceManagerBuilder;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageLogger;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.ReactRootView;
import com.facebook.react.ViewManagerOnDemandReactPackage;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.CatalystInstanceImpl;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JSExceptionHandler;
import com.facebook.react.bridge.JSIModulePackage;
import com.facebook.react.bridge.JSIModuleType;
import com.facebook.react.bridge.JavaJSExecutor;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptExecutorFactory;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ProxyJavaScriptExecutor;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactCxxErrorHandler;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.common.SurfaceDelegateFactory;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.devsupport.DevSupportManagerFactory;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import com.facebook.react.modules.appearance.AppearanceModule;
import com.facebook.react.modules.appregistry.AppRegistry;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.modules.fabric.ReactFabric;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.turbomodule.core.TurboModuleManager;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.soloader.SoLoader;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public class ReactInstanceManager {
    private static final String TAG = ReactInstanceManager.class.getSimpleName();
    private final Set<ReactRoot> mAttachedReactRoots = Collections.synchronizedSet(new HashSet());
    private volatile LifecycleState mLifecycleState;
    @Nullable
    @ThreadConfined(value="UI")
    private ReactContextInitParams mPendingReactContextInitParams;
    @Nullable
    private volatile Thread mCreateReactContextThread;
    private final JavaScriptExecutorFactory mJavaScriptExecutorFactory;
    @Nullable
    private Collection<String> mViewManagerNames = null;
    @Nullable
    private final JSBundleLoader mBundleLoader;
    @Nullable
    private final String mJSMainModulePath;
    private final List<ReactPackage> mPackages;
    private final DevSupportManager mDevSupportManager;
    private final boolean mUseDeveloperSupport;
    private final boolean mRequireActivity;
    @Nullable
    private final NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
    private final Object mReactContextLock = new Object();
    @Nullable
    private volatile ReactContext mCurrentReactContext;
    private final Context mApplicationContext;
    @Nullable
    @ThreadConfined(value="UI")
    private DefaultHardwareBackBtnHandler mDefaultBackButtonImpl;
    @Nullable
    private Activity mCurrentActivity;
    private final Collection<com.facebook.react.ReactInstanceEventListener> mReactInstanceEventListeners = Collections.synchronizedList(new ArrayList());
    private volatile boolean mHasStartedCreatingInitialContext = false;
    private volatile Boolean mHasStartedDestroying = false;
    private final MemoryPressureRouter mMemoryPressureRouter;
    @Nullable
    private final JSExceptionHandler mJSExceptionHandler;
    @Nullable
    private final JSIModulePackage mJSIModulePackage;
    @Nullable
    private final ReactPackageTurboModuleManagerDelegate.Builder mTMMDelegateBuilder;
    private List<ViewManager> mViewManagers;
    private boolean mUseFallbackBundle = false;

    public static ReactInstanceManagerBuilder builder() {
        return new ReactInstanceManagerBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReactInstanceManager(Context applicationContext, @Nullable Activity currentActivity, @Nullable DefaultHardwareBackBtnHandler defaultHardwareBackBtnHandler, JavaScriptExecutorFactory javaScriptExecutorFactory, @Nullable JSBundleLoader bundleLoader, @Nullable String jsMainModulePath, List<ReactPackage> packages, boolean useDeveloperSupport, DevSupportManagerFactory devSupportManagerFactory, boolean requireActivity, @Nullable NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener, LifecycleState initialLifecycleState, JSExceptionHandler jSExceptionHandler, @Nullable RedBoxHandler redBoxHandler, boolean lazyViewManagersEnabled, @Nullable DevBundleDownloadListener devBundleDownloadListener, int minNumShakes, int minTimeLeftInFrameForNonBatchedOperationMs, @Nullable JSIModulePackage jsiModulePackage, @Nullable Map<String, RequestHandler> customPackagerCommandHandlers, @Nullable ReactPackageTurboModuleManagerDelegate.Builder tmmDelegateBuilder, @Nullable SurfaceDelegateFactory surfaceDelegateFactory) {
        FLog.d((String)TAG, (String)"ReactInstanceManager.ctor()");
        ReactInstanceManager.initializeSoLoaderIfNecessary(applicationContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(applicationContext);
        this.mApplicationContext = applicationContext;
        this.mCurrentActivity = currentActivity;
        this.mDefaultBackButtonImpl = defaultHardwareBackBtnHandler;
        this.mJavaScriptExecutorFactory = javaScriptExecutorFactory;
        this.mBundleLoader = bundleLoader;
        this.mJSMainModulePath = jsMainModulePath;
        this.mPackages = new ArrayList<ReactPackage>();
        this.mUseDeveloperSupport = useDeveloperSupport;
        this.mRequireActivity = requireActivity;
        Systrace.beginSection(0L, "ReactInstanceManager.initDevSupportManager");
        this.mDevSupportManager = devSupportManagerFactory.create(applicationContext, this.createDevHelperInterface(), this.mJSMainModulePath, useDeveloperSupport, redBoxHandler, devBundleDownloadListener, minNumShakes, customPackagerCommandHandlers, surfaceDelegateFactory);
        Systrace.endSection(0L);
        this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
        this.mLifecycleState = initialLifecycleState;
        this.mMemoryPressureRouter = new MemoryPressureRouter(applicationContext);
        this.mJSExceptionHandler = jSExceptionHandler;
        this.mTMMDelegateBuilder = tmmDelegateBuilder;
        List<ReactPackage> list = this.mPackages;
        synchronized (list) {
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: Use Split Packages");
            this.mPackages.add(new CoreModulesPackage(this, new DefaultHardwareBackBtnHandler(){

                @Override
                public void invokeDefaultOnBackPressed() {
                    ReactInstanceManager.this.invokeDefaultOnBackPressed();
                }
            }, lazyViewManagersEnabled, minTimeLeftInFrameForNonBatchedOperationMs));
            if (this.mUseDeveloperSupport) {
                this.mPackages.add(new DebugCorePackage());
            }
            this.mPackages.addAll(packages);
        }
        this.mJSIModulePackage = jsiModulePackage;
        ReactChoreographer.initialize();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.startInspector();
        }
        this.registerCxxErrorHandlerFunc();
    }

    private ReactInstanceDevHelper createDevHelperInterface() {
        return new ReactInstanceDevHelper(){

            @Override
            public void onReloadWithJSDebugger(JavaJSExecutor.Factory jsExecutorFactory) {
                ReactInstanceManager.this.onReloadWithJSDebugger(jsExecutorFactory);
            }

            @Override
            public void onJSBundleLoadedFromServer() {
                ReactInstanceManager.this.onJSBundleLoadedFromServer();
            }

            @Override
            public void toggleElementInspector() {
                ReactInstanceManager.this.toggleElementInspector();
            }

            @Override
            @Nullable
            public Activity getCurrentActivity() {
                return ReactInstanceManager.this.mCurrentActivity;
            }

            @Override
            public JavaScriptExecutorFactory getJavaScriptExecutorFactory() {
                return ReactInstanceManager.this.getJSExecutorFactory();
            }

            @Override
            @Nullable
            public View createRootView(String appKey) {
                Activity currentActivity = this.getCurrentActivity();
                if (currentActivity != null) {
                    ReactRootView rootView = new ReactRootView((Context)currentActivity);
                    rootView.setIsFabric(ReactFeatureFlags.enableFabricRenderer);
                    rootView.startReactApplication(ReactInstanceManager.this, appKey, null);
                    return rootView;
                }
                return null;
            }

            @Override
            public void destroyRootView(View rootView) {
                FLog.e((String)TAG, (String)"destroyRootView called");
                if (rootView instanceof ReactRootView) {
                    FLog.e((String)TAG, (String)"destroyRootView called, unmountReactApplication");
                    ((ReactRootView)rootView).unmountReactApplication();
                }
            }
        };
    }

    public synchronized void setUseFallbackBundle(boolean useFallbackBundle) {
        this.mUseFallbackBundle = useFallbackBundle;
    }

    private JavaScriptExecutorFactory getJSExecutorFactory() {
        return this.mJavaScriptExecutorFactory;
    }

    public DevSupportManager getDevSupportManager() {
        return this.mDevSupportManager;
    }

    public MemoryPressureRouter getMemoryPressureRouter() {
        return this.mMemoryPressureRouter;
    }

    public List<ReactPackage> getPackages() {
        return new ArrayList<ReactPackage>(this.mPackages);
    }

    public void handleCxxError(Exception e) {
        this.mDevSupportManager.handleException(e);
    }

    public void registerCxxErrorHandlerFunc() {
        Class[] parameterTypes = new Class[]{Exception.class};
        Method handleCxxErrorFunc = null;
        try {
            handleCxxErrorFunc = ReactInstanceManager.class.getMethod("handleCxxError", parameterTypes);
        }
        catch (NoSuchMethodException e) {
            FLog.e((String)"ReactInstanceHolder", (String)"Failed to set cxx error hanlder function", (Throwable)e);
        }
        ReactCxxErrorHandler.setHandleErrorFunc(this, handleCxxErrorFunc);
    }

    static void initializeSoLoaderIfNecessary(Context applicationContext) {
        SoLoader.init((Context)applicationContext, (boolean)false);
    }

    @ThreadConfined(value="UI")
    public void createReactContextInBackground() {
        FLog.d((String)TAG, (String)"ReactInstanceManager.createReactContextInBackground()");
        UiThreadUtil.assertOnUiThread();
        if (!this.mHasStartedCreatingInitialContext) {
            this.mHasStartedCreatingInitialContext = true;
            this.recreateReactContextInBackgroundInner();
        }
    }

    @ThreadConfined(value="UI")
    public void recreateReactContextInBackground() {
        Assertions.assertCondition((boolean)this.mHasStartedCreatingInitialContext, (String)"recreateReactContextInBackground should only be called after the initial createReactContextInBackground call.");
        this.recreateReactContextInBackgroundInner();
    }

    @ThreadConfined(value="UI")
    private void recreateReactContextInBackgroundInner() {
        FLog.d((String)TAG, (String)"ReactInstanceManager.recreateReactContextInBackgroundInner()");
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: recreateReactContextInBackground");
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport && this.mJSMainModulePath != null) {
            final DeveloperSettings devSettings = this.mDevSupportManager.getDevSettings();
            if (!Systrace.isTracing(0L)) {
                if (this.mBundleLoader == null) {
                    this.mDevSupportManager.handleReloadJS();
                } else {
                    this.mDevSupportManager.isPackagerRunning(new PackagerStatusCallback(){

                        @Override
                        public void onPackagerStatusFetched(final boolean packagerIsRunning) {
                            UiThreadUtil.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (packagerIsRunning) {
                                        ReactInstanceManager.this.mDevSupportManager.handleReloadJS();
                                    } else if (ReactInstanceManager.this.mDevSupportManager.hasUpToDateJSBundleInCache() && !devSettings.isRemoteJSDebugEnabled() && !ReactInstanceManager.this.mUseFallbackBundle) {
                                        ReactInstanceManager.this.onJSBundleLoadedFromServer();
                                    } else {
                                        devSettings.setRemoteJSDebugEnabled(false);
                                        ReactInstanceManager.this.recreateReactContextInBackgroundFromBundleLoader();
                                    }
                                }
                            });
                        }
                    });
                }
                return;
            }
        }
        this.recreateReactContextInBackgroundFromBundleLoader();
    }

    @ThreadConfined(value="UI")
    private void recreateReactContextInBackgroundFromBundleLoader() {
        FLog.d((String)TAG, (String)"ReactInstanceManager.recreateReactContextInBackgroundFromBundleLoader()");
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: load from BundleLoader");
        this.recreateReactContextInBackground(this.mJavaScriptExecutorFactory, this.mBundleLoader);
    }

    public boolean hasStartedCreatingInitialContext() {
        return this.mHasStartedCreatingInitialContext;
    }

    public void onBackPressed() {
        UiThreadUtil.assertOnUiThread();
        ReactContext reactContext = this.mCurrentReactContext;
        if (reactContext == null) {
            FLog.w((String)TAG, (String)"Instance detached from instance manager");
            this.invokeDefaultOnBackPressed();
        } else {
            DeviceEventManagerModule deviceEventManagerModule = reactContext.getNativeModule(DeviceEventManagerModule.class);
            if (deviceEventManagerModule != null) {
                deviceEventManagerModule.emitHardwareBackPressed();
            }
        }
    }

    private void invokeDefaultOnBackPressed() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDefaultBackButtonImpl != null) {
            this.mDefaultBackButtonImpl.invokeDefaultOnBackPressed();
        }
    }

    @ThreadConfined(value="UI")
    public void onNewIntent(Intent intent) {
        UiThreadUtil.assertOnUiThread();
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext == null) {
            FLog.w((String)TAG, (String)"Instance detached from instance manager");
        } else {
            DeviceEventManagerModule deviceEventManagerModule;
            String action = intent.getAction();
            Uri uri = intent.getData();
            if (uri != null && ("android.intent.action.VIEW".equals(action) || "android.nfc.action.NDEF_DISCOVERED".equals(action)) && (deviceEventManagerModule = currentContext.getNativeModule(DeviceEventManagerModule.class)) != null) {
                deviceEventManagerModule.emitNewIntentReceived(uri);
            }
            currentContext.onNewIntent(this.mCurrentActivity, intent);
        }
    }

    private void toggleElementInspector() {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null && currentContext.hasActiveReactInstance()) {
            currentContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("toggleElementInspector", null);
        } else {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot toggleElementInspector, CatalystInstance not available"));
        }
    }

    @ThreadConfined(value="UI")
    public void onHostPause() {
        UiThreadUtil.assertOnUiThread();
        this.mDefaultBackButtonImpl = null;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeResumeLifecycleState();
    }

    @ThreadConfined(value="UI")
    public void onHostPause(@Nullable Activity activity) {
        if (this.mRequireActivity) {
            Assertions.assertCondition((this.mCurrentActivity != null ? 1 : 0) != 0);
        }
        if (this.mCurrentActivity != null) {
            Assertions.assertCondition((activity == this.mCurrentActivity ? 1 : 0) != 0, (String)("Pausing an activity that is not the current activity, this is incorrect! Current activity: " + this.mCurrentActivity.getClass().getSimpleName() + " Paused activity: " + activity.getClass().getSimpleName()));
        }
        this.onHostPause();
    }

    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity, DefaultHardwareBackBtnHandler defaultBackButtonImpl) {
        UiThreadUtil.assertOnUiThread();
        this.mDefaultBackButtonImpl = defaultBackButtonImpl;
        this.onHostResume(activity);
    }

    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity) {
        UiThreadUtil.assertOnUiThread();
        this.mCurrentActivity = activity;
        if (this.mUseDeveloperSupport) {
            if (this.mCurrentActivity != null) {
                final View decorView = this.mCurrentActivity.getWindow().getDecorView();
                if (!ViewCompat.isAttachedToWindow((View)decorView)) {
                    decorView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                        public void onViewAttachedToWindow(View v) {
                            decorView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                            ReactInstanceManager.this.mDevSupportManager.setDevSupportEnabled(true);
                        }

                        public void onViewDetachedFromWindow(View v) {
                        }
                    });
                } else {
                    this.mDevSupportManager.setDevSupportEnabled(true);
                }
            } else if (!this.mRequireActivity) {
                this.mDevSupportManager.setDevSupportEnabled(true);
            }
        }
        this.moveToResumedLifecycleState(false);
    }

    @ThreadConfined(value="UI")
    public void onHostDestroy() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeCreateLifecycleState();
        this.mCurrentActivity = null;
    }

    @ThreadConfined(value="UI")
    public void onHostDestroy(@Nullable Activity activity) {
        if (activity == this.mCurrentActivity) {
            this.onHostDestroy();
        }
    }

    private void logOnDestroy() {
        FLog.d((String)TAG, (String)"ReactInstanceManager.destroy called", (Throwable)new RuntimeException("ReactInstanceManager.destroy called"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    public void destroy() {
        UiThreadUtil.assertOnUiThread();
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: Destroy");
        this.logOnDestroy();
        if (this.mHasStartedDestroying.booleanValue()) {
            FLog.e((String)"ReactNative", (String)"ReactInstanceManager.destroy called: bail out, already destroying");
            return;
        }
        this.mHasStartedDestroying = true;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
            this.mDevSupportManager.stopInspector();
        }
        this.moveToBeforeCreateLifecycleState();
        if (this.mCreateReactContextThread != null) {
            this.mCreateReactContextThread = null;
        }
        this.mMemoryPressureRouter.destroy(this.mApplicationContext);
        List<ReactPackage> list = this.mReactContextLock;
        synchronized (list) {
            if (this.mCurrentReactContext != null) {
                this.mCurrentReactContext.destroy();
                this.mCurrentReactContext = null;
            }
        }
        this.mHasStartedCreatingInitialContext = false;
        this.mCurrentActivity = null;
        ResourceDrawableIdHelper.getInstance().clear();
        this.mHasStartedDestroying = false;
        list = this.mHasStartedDestroying;
        synchronized (list) {
            this.mHasStartedDestroying.notifyAll();
        }
        list = this.mPackages;
        synchronized (list) {
            this.mViewManagerNames = null;
        }
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager has been destroyed");
    }

    private synchronized void moveToResumedLifecycleState(boolean force) {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null && (force || this.mLifecycleState == LifecycleState.BEFORE_RESUME || this.mLifecycleState == LifecycleState.BEFORE_CREATE)) {
            currentContext.onHostResume(this.mCurrentActivity);
        }
        this.mLifecycleState = LifecycleState.RESUMED;
    }

    private synchronized void moveToBeforeResumeLifecycleState() {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            if (this.mLifecycleState == LifecycleState.BEFORE_CREATE) {
                currentContext.onHostResume(this.mCurrentActivity);
                currentContext.onHostPause();
            } else if (this.mLifecycleState == LifecycleState.RESUMED) {
                currentContext.onHostPause();
            }
        }
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
    }

    private synchronized void moveToBeforeCreateLifecycleState() {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            if (this.mLifecycleState == LifecycleState.RESUMED) {
                currentContext.onHostPause();
                this.mLifecycleState = LifecycleState.BEFORE_RESUME;
            }
            if (this.mLifecycleState == LifecycleState.BEFORE_RESUME) {
                currentContext.onHostDestroy();
            }
        }
        this.mLifecycleState = LifecycleState.BEFORE_CREATE;
    }

    private synchronized void moveReactContextToCurrentLifecycleState() {
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            this.moveToResumedLifecycleState(true);
        }
    }

    @ThreadConfined(value="UI")
    public void onActivityResult(Activity activity, int requestCode, int resultCode, @Nullable Intent data) {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            currentContext.onActivityResult(activity, requestCode, resultCode, data);
        }
    }

    @ThreadConfined(value="UI")
    public void onWindowFocusChange(boolean hasFocus) {
        UiThreadUtil.assertOnUiThread();
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            currentContext.onWindowFocusChange(hasFocus);
        }
    }

    @ThreadConfined(value="UI")
    public void onConfigurationChanged(Context updatedContext, @Nullable Configuration newConfig) {
        AppearanceModule appearanceModule;
        UiThreadUtil.assertOnUiThread();
        ReactContext currentReactContext = this.getCurrentReactContext();
        if (currentReactContext != null && (appearanceModule = currentReactContext.getNativeModule(AppearanceModule.class)) != null) {
            appearanceModule.onConfigurationChanged(updatedContext);
        }
    }

    @ThreadConfined(value="UI")
    public void showDevOptionsDialog() {
        UiThreadUtil.assertOnUiThread();
        this.mDevSupportManager.showDevOptionsDialog();
    }

    @ThreadConfined(value="UI")
    private void clearReactRoot(ReactRoot reactRoot) {
        UiThreadUtil.assertOnUiThread();
        reactRoot.getState().compareAndSet(1, 0);
        ViewGroup rootViewGroup = reactRoot.getRootViewGroup();
        rootViewGroup.removeAllViews();
        rootViewGroup.setId(-1);
    }

    @ThreadConfined(value="UI")
    public void attachRootView(ReactRoot reactRoot) {
        UiThreadUtil.assertOnUiThread();
        if (this.mAttachedReactRoots.add(reactRoot)) {
            this.clearReactRoot(reactRoot);
        }
        ReactContext currentContext = this.getCurrentReactContext();
        if (this.mCreateReactContextThread == null && currentContext != null && reactRoot.getState().compareAndSet(0, 1)) {
            this.attachRootViewToInstance(reactRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    public void detachRootView(ReactRoot reactRoot) {
        UiThreadUtil.assertOnUiThread();
        Set<ReactRoot> set = this.mAttachedReactRoots;
        synchronized (set) {
            if (this.mAttachedReactRoots.contains(reactRoot)) {
                ReactContext currentContext = this.getCurrentReactContext();
                this.mAttachedReactRoots.remove(reactRoot);
                if (currentContext != null && currentContext.hasActiveReactInstance()) {
                    this.detachViewFromInstance(reactRoot, currentContext.getCatalystInstance());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ViewManager> getOrCreateViewManagers(ReactApplicationContext catalystApplicationContext) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_VIEW_MANAGERS_START);
        Systrace.beginSection(0L, "createAllViewManagers");
        try {
            if (this.mViewManagers == null) {
                List<ReactPackage> list = this.mPackages;
                synchronized (list) {
                    if (this.mViewManagers == null) {
                        this.mViewManagers = new ArrayList<ViewManager>();
                        Object object = this.mPackages.iterator();
                        while (true) {
                            if (!object.hasNext()) {
                                object = this.mViewManagers;
                                return object;
                            }
                            ReactPackage reactPackage = object.next();
                            this.mViewManagers.addAll(reactPackage.createViewManagers(catalystApplicationContext));
                        }
                    }
                }
            }
            List<ViewManager> list = this.mViewManagers;
            return list;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_VIEW_MANAGERS_END);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ViewManager createViewManager(String viewManagerName) {
        ReactApplicationContext context;
        List<ReactPackage> list = this.mReactContextLock;
        synchronized (list) {
            context = (ReactApplicationContext)this.getCurrentReactContext();
            if (context == null || !context.hasActiveReactInstance()) {
                return null;
            }
        }
        list = this.mPackages;
        synchronized (list) {
            for (ReactPackage reactPackage : this.mPackages) {
                ViewManager viewManager;
                if (!(reactPackage instanceof ViewManagerOnDemandReactPackage) || (viewManager = ((ViewManagerOnDemandReactPackage)((Object)reactPackage)).createViewManager(context, viewManagerName)) == null) continue;
                return viewManager;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<String> getViewManagerNames() {
        Systrace.beginSection(0L, "ReactInstanceManager.getViewManagerNames");
        try {
            ReactApplicationContext context;
            Collection<String> viewManagerNames = this.mViewManagerNames;
            if (viewManagerNames != null) {
                Collection<String> collection = viewManagerNames;
                return collection;
            }
            List<ReactPackage> list = this.mReactContextLock;
            synchronized (list) {
                context = (ReactApplicationContext)this.getCurrentReactContext();
                if (context == null || !context.hasActiveReactInstance()) {
                    FLog.w((String)"ReactNative", (String)"Calling getViewManagerNames without active context");
                    List<String> list2 = Collections.emptyList();
                    return list2;
                }
            }
            list = this.mPackages;
            synchronized (list) {
                if (this.mViewManagerNames == null) {
                    HashSet<String> uniqueNames = new HashSet<String>();
                    for (ReactPackage reactPackage : this.mPackages) {
                        Collection<String> names;
                        SystraceMessage.beginSection(0L, "ReactInstanceManager.getViewManagerName").arg("Package", reactPackage.getClass().getSimpleName()).flush();
                        if (reactPackage instanceof ViewManagerOnDemandReactPackage && (names = ((ViewManagerOnDemandReactPackage)((Object)reactPackage)).getViewManagerNames(context)) != null) {
                            uniqueNames.addAll(names);
                        }
                        Systrace.endSection(0L);
                    }
                    this.mViewManagerNames = uniqueNames;
                }
                Collection<String> collection = this.mViewManagerNames;
                return collection;
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void addReactInstanceEventListener(com.facebook.react.ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.add(listener);
    }

    public void removeReactInstanceEventListener(com.facebook.react.ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    public ReactContext getCurrentReactContext() {
        Object object = this.mReactContextLock;
        synchronized (object) {
            return this.mCurrentReactContext;
        }
    }

    public LifecycleState getLifecycleState() {
        return this.mLifecycleState;
    }

    public String getJsExecutorName() {
        return this.mJavaScriptExecutorFactory.toString();
    }

    @ThreadConfined(value="UI")
    private void onReloadWithJSDebugger(JavaJSExecutor.Factory jsExecutorFactory) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.onReloadWithJSDebugger()");
        this.recreateReactContextInBackground(new ProxyJavaScriptExecutor.Factory(jsExecutorFactory), JSBundleLoader.createRemoteDebuggerBundleLoader(this.mDevSupportManager.getJSBundleURLForRemoteDebugging(), this.mDevSupportManager.getSourceUrl()));
    }

    @ThreadConfined(value="UI")
    private void onJSBundleLoadedFromServer() {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.onJSBundleLoadedFromServer()");
        JSBundleLoader bundleLoader = JSBundleLoader.createCachedBundleFromNetworkLoader(this.mDevSupportManager.getSourceUrl(), this.mDevSupportManager.getDownloadedJSBundleFile());
        this.recreateReactContextInBackground(this.mJavaScriptExecutorFactory, bundleLoader);
    }

    @ThreadConfined(value="UI")
    private void recreateReactContextInBackground(JavaScriptExecutorFactory jsExecutorFactory, JSBundleLoader jsBundleLoader) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.recreateReactContextInBackground()");
        UiThreadUtil.assertOnUiThread();
        ReactContextInitParams initParams = new ReactContextInitParams(jsExecutorFactory, jsBundleLoader);
        if (this.mCreateReactContextThread == null) {
            this.runCreateReactContextOnNewThread(initParams);
        } else {
            this.mPendingReactContextInitParams = initParams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    private void runCreateReactContextOnNewThread(final ReactContextInitParams initParams) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.runCreateReactContextOnNewThread()");
        UiThreadUtil.assertOnUiThread();
        ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGE_LOADING_START);
        Set<ReactRoot> set = this.mAttachedReactRoots;
        synchronized (set) {
            Object object = this.mReactContextLock;
            synchronized (object) {
                if (this.mCurrentReactContext != null) {
                    this.tearDownReactContext(this.mCurrentReactContext);
                    this.mCurrentReactContext = null;
                }
            }
        }
        this.mCreateReactContextThread = new Thread(null, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ReactApplicationContext reactApplicationContext;
                ReactMarker.logMarker(ReactMarkerConstants.REACT_CONTEXT_THREAD_END);
                Boolean bl = ReactInstanceManager.this.mHasStartedDestroying;
                synchronized (bl) {
                    while (ReactInstanceManager.this.mHasStartedDestroying.booleanValue()) {
                        try {
                            ReactInstanceManager.this.mHasStartedDestroying.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
                ReactInstanceManager.this.mHasStartedCreatingInitialContext = true;
                try {
                    Process.setThreadPriority((int)-4);
                    ReactMarker.logMarker(ReactMarkerConstants.VM_INIT);
                    reactApplicationContext = ReactInstanceManager.this.createReactContext(initParams.getJsExecutorFactory().create(), initParams.getJsBundleLoader());
                }
                catch (Exception e) {
                    ReactInstanceManager.this.mHasStartedCreatingInitialContext = false;
                    ReactInstanceManager.this.mCreateReactContextThread = null;
                    ReactInstanceManager.this.mDevSupportManager.handleException(e);
                    return;
                }
                try {
                    ReactInstanceManager.this.mCreateReactContextThread = null;
                    ReactMarker.logMarker(ReactMarkerConstants.PRE_SETUP_REACT_CONTEXT_START);
                    Runnable maybeRecreateReactContextRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (ReactInstanceManager.this.mPendingReactContextInitParams != null) {
                                ReactInstanceManager.this.runCreateReactContextOnNewThread(ReactInstanceManager.this.mPendingReactContextInitParams);
                                ReactInstanceManager.this.mPendingReactContextInitParams = null;
                            }
                        }
                    };
                    Runnable setupReactContextRunnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ReactInstanceManager.this.setupReactContext(reactApplicationContext);
                            }
                            catch (Exception e) {
                                FLog.e((String)"ReactNative", (String)"ReactInstanceManager caught exception in setupReactContext", (Throwable)e);
                                ReactInstanceManager.this.mDevSupportManager.handleException(e);
                            }
                        }
                    };
                    reactApplicationContext.runOnNativeModulesQueueThread(setupReactContextRunnable);
                    UiThreadUtil.runOnUiThread(maybeRecreateReactContextRunnable);
                }
                catch (Exception e) {
                    ReactInstanceManager.this.mDevSupportManager.handleException(e);
                }
            }
        }, "create_react_context");
        ReactMarker.logMarker(ReactMarkerConstants.REACT_CONTEXT_THREAD_START);
        this.mCreateReactContextThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupReactContext(final ReactApplicationContext reactContext) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.setupReactContext()");
        ReactMarker.logMarker(ReactMarkerConstants.PRE_SETUP_REACT_CONTEXT_END);
        ReactMarker.logMarker(ReactMarkerConstants.SETUP_REACT_CONTEXT_START);
        Systrace.beginSection(0L, "setupReactContext");
        Set<ReactRoot> set = this.mAttachedReactRoots;
        synchronized (set) {
            Object object = this.mReactContextLock;
            synchronized (object) {
                this.mCurrentReactContext = (ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)));
            }
            CatalystInstance catalystInstance = (CatalystInstance)Assertions.assertNotNull((Object)reactContext.getCatalystInstance());
            catalystInstance.initialize();
            this.mDevSupportManager.onNewReactContextCreated(reactContext);
            this.mMemoryPressureRouter.addMemoryPressureListener(catalystInstance);
            ReactMarker.logMarker(ReactMarkerConstants.ATTACH_MEASURED_ROOT_VIEWS_START);
            for (ReactRoot reactRoot : this.mAttachedReactRoots) {
                if (!reactRoot.getState().compareAndSet(0, 1)) continue;
                this.attachRootViewToInstance(reactRoot);
            }
            ReactMarker.logMarker(ReactMarkerConstants.ATTACH_MEASURED_ROOT_VIEWS_END);
        }
        com.facebook.react.ReactInstanceEventListener[] listeners = new com.facebook.react.ReactInstanceEventListener[this.mReactInstanceEventListeners.size()];
        final com.facebook.react.ReactInstanceEventListener[] finalListeners = this.mReactInstanceEventListeners.toArray(listeners);
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReactInstanceManager.this.moveReactContextToCurrentLifecycleState();
                for (com.facebook.react.ReactInstanceEventListener listener : finalListeners) {
                    if (listener == null) continue;
                    listener.onReactContextInitialized(reactContext);
                }
            }
        });
        reactContext.runOnJSQueueThread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)0);
                ReactMarker.logMarker(ReactMarkerConstants.CHANGE_THREAD_PRIORITY, "js_default");
            }
        });
        reactContext.runOnNativeModulesQueueThread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)0);
            }
        });
        Systrace.endSection(0L);
        ReactMarker.logMarker(ReactMarkerConstants.SETUP_REACT_CONTEXT_END);
        ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGE_LOADING_END);
    }

    private void attachRootViewToInstance(final ReactRoot reactRoot) {
        int rootTag;
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.attachRootViewToInstance()");
        Systrace.beginSection(0L, "attachRootViewToInstance");
        UIManager uiManager = UIManagerHelper.getUIManager(this.mCurrentReactContext, reactRoot.getUIManagerType());
        if (uiManager == null) {
            throw new IllegalStateException("Unable to attach a rootView to ReactInstance when UIManager is not properly initialized.");
        }
        Bundle initialProperties = reactRoot.getAppProperties();
        if (reactRoot.getUIManagerType() == 2) {
            rootTag = uiManager.startSurface(reactRoot.getRootViewGroup(), reactRoot.getJSModuleName(), initialProperties == null ? new WritableNativeMap() : Arguments.fromBundle(initialProperties), reactRoot.getWidthMeasureSpec(), reactRoot.getHeightMeasureSpec());
            reactRoot.setShouldLogContentAppeared(true);
        } else {
            rootTag = uiManager.addRootView(reactRoot.getRootViewGroup(), initialProperties == null ? new WritableNativeMap() : Arguments.fromBundle(initialProperties), reactRoot.getInitialUITemplate());
            reactRoot.setRootViewTag(rootTag);
            reactRoot.runApplication();
        }
        Systrace.beginAsyncSection(0L, "pre_rootView.onAttachedToReactInstance", rootTag);
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Systrace.endAsyncSection(0L, "pre_rootView.onAttachedToReactInstance", rootTag);
                reactRoot.onStage(101);
            }
        });
        Systrace.endSection(0L);
    }

    private void detachViewFromInstance(ReactRoot reactRoot, CatalystInstance catalystInstance) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.detachViewFromInstance()");
        UiThreadUtil.assertOnUiThread();
        if (reactRoot.getUIManagerType() == 2) {
            catalystInstance.getJSModule(ReactFabric.class).unmountComponentAtNode(reactRoot.getRootViewTag());
        } else {
            catalystInstance.getJSModule(AppRegistry.class).unmountApplicationComponentAtRootTag(reactRoot.getRootViewTag());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    private void tearDownReactContext(ReactContext reactContext) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.tearDownReactContext()");
        UiThreadUtil.assertOnUiThread();
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            reactContext.onHostPause();
        }
        Set<ReactRoot> set = this.mAttachedReactRoots;
        synchronized (set) {
            for (ReactRoot reactRoot : this.mAttachedReactRoots) {
                this.clearReactRoot(reactRoot);
            }
        }
        this.mMemoryPressureRouter.removeMemoryPressureListener(reactContext.getCatalystInstance());
        reactContext.destroy();
        this.mDevSupportManager.onReactInstanceDestroyed(reactContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReactApplicationContext createReactContext(JavaScriptExecutor jsExecutor, JSBundleLoader jsBundleLoader) {
        CatalystInstanceImpl catalystInstance;
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.createReactContext()");
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_REACT_CONTEXT_START, jsExecutor.getName());
        ReactApplicationContext reactContext = new ReactApplicationContext(this.mApplicationContext);
        JSExceptionHandler exceptionHandler = this.mJSExceptionHandler != null ? this.mJSExceptionHandler : this.mDevSupportManager;
        reactContext.setJSExceptionHandler(exceptionHandler);
        NativeModuleRegistry nativeModuleRegistry = this.processPackages(reactContext, this.mPackages, false);
        CatalystInstanceImpl.Builder catalystInstanceBuilder = new CatalystInstanceImpl.Builder().setReactQueueConfigurationSpec(ReactQueueConfigurationSpec.createDefault()).setJSExecutor(jsExecutor).setRegistry(nativeModuleRegistry).setJSBundleLoader(jsBundleLoader).setJSExceptionHandler(exceptionHandler);
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_CATALYST_INSTANCE_START);
        Systrace.beginSection(0L, "createCatalystInstance");
        try {
            catalystInstance = catalystInstanceBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_CATALYST_INSTANCE_END);
        }
        reactContext.initializeWithInstance(catalystInstance);
        if (ReactFeatureFlags.useTurboModules && this.mTMMDelegateBuilder != null) {
            ReactPackageTurboModuleManagerDelegate tmmDelegate = this.mTMMDelegateBuilder.setPackages(this.mPackages).setReactApplicationContext(reactContext).build();
            TurboModuleManager turboModuleManager = new TurboModuleManager(catalystInstance.getRuntimeExecutor(), tmmDelegate, catalystInstance.getJSCallInvokerHolder(), catalystInstance.getNativeCallInvokerHolder());
            catalystInstance.setTurboModuleManager(turboModuleManager);
            TurboModuleManager registry = turboModuleManager;
            for (String moduleName : registry.getEagerInitModuleNames()) {
                registry.getModule(moduleName);
            }
        }
        if (this.mJSIModulePackage != null) {
            catalystInstance.addJSIModules(this.mJSIModulePackage.getJSIModules(reactContext, catalystInstance.getJavaScriptContextHolder()));
        }
        if (ReactFeatureFlags.enableFabricRenderer) {
            catalystInstance.getJSIModule(JSIModuleType.UIManager);
        }
        if (this.mBridgeIdleDebugListener != null) {
            catalystInstance.addBridgeIdleDebugListener(this.mBridgeIdleDebugListener);
        }
        if (Systrace.isTracing(0L)) {
            catalystInstance.setGlobalVariable("__RCTProfileIsProfiling", "true");
        }
        ReactMarker.logMarker(ReactMarkerConstants.PRE_RUN_JS_BUNDLE_START);
        Systrace.beginSection(0L, "runJSBundle");
        catalystInstance.runJSBundle();
        Systrace.endSection(0L);
        return reactContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeModuleRegistry processPackages(ReactApplicationContext reactContext, List<ReactPackage> packages, boolean checkAndUpdatePackageMembership) {
        NativeModuleRegistry nativeModuleRegistry;
        NativeModuleRegistryBuilder nativeModuleRegistryBuilder = new NativeModuleRegistryBuilder(reactContext, this);
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_PACKAGES_START);
        List<ReactPackage> list = this.mPackages;
        synchronized (list) {
            for (ReactPackage reactPackage : packages) {
                if (checkAndUpdatePackageMembership && this.mPackages.contains(reactPackage)) continue;
                Systrace.beginSection(0L, "createAndProcessCustomReactPackage");
                try {
                    if (checkAndUpdatePackageMembership) {
                        this.mPackages.add(reactPackage);
                    }
                    this.processPackage(reactPackage, nativeModuleRegistryBuilder);
                }
                finally {
                    Systrace.endSection(0L);
                }
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_PACKAGES_END);
        ReactMarker.logMarker(ReactMarkerConstants.BUILD_NATIVE_MODULE_REGISTRY_START);
        Systrace.beginSection(0L, "buildNativeModuleRegistry");
        try {
            nativeModuleRegistry = nativeModuleRegistryBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.BUILD_NATIVE_MODULE_REGISTRY_END);
        }
        return nativeModuleRegistry;
    }

    private void processPackage(ReactPackage reactPackage, NativeModuleRegistryBuilder nativeModuleRegistryBuilder) {
        SystraceMessage.beginSection(0L, "processPackage").arg("className", reactPackage.getClass().getSimpleName()).flush();
        if (reactPackage instanceof ReactPackageLogger) {
            ((ReactPackageLogger)((Object)reactPackage)).startProcessPackage();
        }
        nativeModuleRegistryBuilder.processPackage(reactPackage);
        if (reactPackage instanceof ReactPackageLogger) {
            ((ReactPackageLogger)((Object)reactPackage)).endProcessPackage();
        }
        SystraceMessage.endSection(0L).flush();
    }

    private class ReactContextInitParams {
        private final JavaScriptExecutorFactory mJsExecutorFactory;
        private final JSBundleLoader mJsBundleLoader;

        public ReactContextInitParams(JavaScriptExecutorFactory jsExecutorFactory, JSBundleLoader jsBundleLoader) {
            this.mJsExecutorFactory = (JavaScriptExecutorFactory)Assertions.assertNotNull((Object)jsExecutorFactory);
            this.mJsBundleLoader = (JSBundleLoader)Assertions.assertNotNull((Object)jsBundleLoader);
        }

        public JavaScriptExecutorFactory getJsExecutorFactory() {
            return this.mJsExecutorFactory;
        }

        public JSBundleLoader getJsBundleLoader() {
            return this.mJsBundleLoader;
        }
    }

    @Deprecated
    public static interface ReactInstanceEventListener
    extends com.facebook.react.ReactInstanceEventListener {
    }
}

