/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.camera;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Base64OutputStream;
import com.facebook.fbreact.specs.NativeImageStoreAndroidSpec;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.module.annotations.ReactModule;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@ReactModule(name="ImageStoreManager")
public class ImageStoreManager
extends NativeImageStoreAndroidSpec {
    public static final String NAME = "ImageStoreManager";
    private static final int BUFFER_SIZE = 8192;

    public ImageStoreManager(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void getBase64ForTag(String uri, Callback success, Callback error) {
        new GetBase64Task(this.getReactApplicationContext(), uri, success, error).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String convertInputStreamToBase64OutputStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Base64OutputStream b64os = new Base64OutputStream((OutputStream)baos, 2);
        byte[] buffer = new byte[8192];
        try {
            int bytesRead;
            while ((bytesRead = is.read(buffer)) > -1) {
                b64os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            ImageStoreManager.closeQuietly((Closeable)b64os);
        }
        return baos.toString();
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class GetBase64Task
    extends GuardedAsyncTask<Void, Void> {
        private final String mUri;
        private final Callback mSuccess;
        private final Callback mError;

        private GetBase64Task(ReactContext reactContext, String uri, Callback success, Callback error) {
            super(reactContext);
            this.mUri = uri;
            this.mSuccess = success;
            this.mError = error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInBackgroundGuarded(Void ... params) {
            try {
                ContentResolver contentResolver = ImageStoreManager.this.getReactApplicationContext().getContentResolver();
                Uri uri = Uri.parse((String)this.mUri);
                InputStream is = contentResolver.openInputStream(uri);
                try {
                    this.mSuccess.invoke(ImageStoreManager.this.convertInputStreamToBase64OutputStream(is));
                }
                catch (IOException e) {
                    this.mError.invoke(e.getMessage());
                }
                finally {
                    ImageStoreManager.closeQuietly(is);
                }
            }
            catch (FileNotFoundException e) {
                this.mError.invoke(e.getMessage());
            }
        }
    }
}

