/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.fbreact.specs.NativeTimingSpec;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.jstasks.HeadlessJsTaskEventListener;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.JSTimers;
import com.facebook.react.modules.core.JavaScriptTimerExecutor;
import com.facebook.react.modules.core.JavaTimerManager;
import com.facebook.react.modules.core.ReactChoreographer;

@ReactModule(name="Timing")
public final class TimingModule
extends NativeTimingSpec
implements LifecycleEventListener,
HeadlessJsTaskEventListener {
    public static final String NAME = "Timing";
    private final JavaTimerManager mJavaTimerManager;

    public TimingModule(ReactApplicationContext reactContext, DevSupportManager devSupportManager) {
        super(reactContext);
        this.mJavaTimerManager = new JavaTimerManager(reactContext, new BridgeTimerExecutor(), ReactChoreographer.getInstance(), devSupportManager);
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        headlessJsTaskContext.addTaskEventListener(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void createTimer(double callbackIDDouble, double durationDouble, double jsSchedulingTime, boolean repeat) {
        int callbackID = (int)callbackIDDouble;
        int duration = (int)durationDouble;
        this.mJavaTimerManager.createAndMaybeCallTimer(callbackID, duration, jsSchedulingTime, repeat);
    }

    @Override
    public void deleteTimer(double timerIdDouble) {
        int timerId = (int)timerIdDouble;
        this.mJavaTimerManager.deleteTimer(timerId);
    }

    @Override
    public void setSendIdleEvents(boolean sendIdleEvents) {
        this.mJavaTimerManager.setSendIdleEvents(sendIdleEvents);
    }

    @Override
    public void onHostResume() {
        this.mJavaTimerManager.onHostResume();
    }

    @Override
    public void onHostPause() {
        this.mJavaTimerManager.onHostPause();
    }

    @Override
    public void onHostDestroy() {
        this.mJavaTimerManager.onHostDestroy();
    }

    @Override
    public void onHeadlessJsTaskStart(int taskId) {
        this.mJavaTimerManager.onHeadlessJsTaskStart(taskId);
    }

    @Override
    public void onHeadlessJsTaskFinish(int taskId) {
        this.mJavaTimerManager.onHeadlessJsTaskFinish(taskId);
    }

    @Override
    public void invalidate() {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(reactApplicationContext);
        headlessJsTaskContext.removeTaskEventListener(this);
        this.mJavaTimerManager.onInstanceDestroy();
        reactApplicationContext.removeLifecycleEventListener(this);
    }

    @VisibleForTesting
    public boolean hasActiveTimersInRange(long rangeMs) {
        return this.mJavaTimerManager.hasActiveTimersInRange(rangeMs);
    }

    public class BridgeTimerExecutor
    implements JavaScriptTimerExecutor {
        @Override
        public void callTimers(WritableArray timerIDs) {
            ReactApplicationContext reactApplicationContext = TimingModule.this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                reactApplicationContext.getJSModule(JSTimers.class).callTimers(timerIDs);
            }
        }

        @Override
        public void callIdleCallbacks(double frameTime) {
            ReactApplicationContext reactApplicationContext = TimingModule.this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                reactApplicationContext.getJSModule(JSTimers.class).callIdleCallbacks(frameTime);
            }
        }

        @Override
        public void emitTimeDriftWarning(String warningMessage) {
            ReactApplicationContext reactApplicationContext = TimingModule.this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                reactApplicationContext.getJSModule(JSTimers.class).emitTimeDriftWarning(warningMessage);
            }
        }
    }
}

