/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class InterpolationAnimatedNode
extends ValueAnimatedNode {
    public static final String EXTRAPOLATE_TYPE_IDENTITY = "identity";
    public static final String EXTRAPOLATE_TYPE_CLAMP = "clamp";
    public static final String EXTRAPOLATE_TYPE_EXTEND = "extend";
    private static final Pattern sNumericPattern = Pattern.compile("[+-]?(\\d+\\.?\\d*|\\.\\d+)([eE][+-]?\\d+)?");
    private static final String COLOR_OUTPUT_TYPE = "color";
    private final double[] mInputRange;
    private final Object mOutputRange;
    private final OutputType mOutputType;
    @Nullable
    private final String mPattern;
    private final String mExtrapolateLeft;
    private final String mExtrapolateRight;
    @Nullable
    private ValueAnimatedNode mParent;
    private Object mObjectValue;

    private static double[] fromDoubleArray(ReadableArray ary) {
        double[] res = new double[ary.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = ary.getDouble(i);
        }
        return res;
    }

    private static int[] fromIntArray(ReadableArray ary) {
        int[] res = new int[ary.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = ary.getInt(i);
        }
        return res;
    }

    private static double[][] fromStringPattern(ReadableArray array) {
        int i;
        int size = array.size();
        double[][] outputRange = new double[size][];
        Matcher m = sNumericPattern.matcher(array.getString(0));
        ArrayList<Double> firstOutputRange = new ArrayList<Double>();
        while (m.find()) {
            firstOutputRange.add(Double.parseDouble(m.group()));
        }
        double[] firstOutputRangeArr = new double[firstOutputRange.size()];
        for (i = 0; i < firstOutputRange.size(); ++i) {
            firstOutputRangeArr[i] = (Double)firstOutputRange.get(i);
        }
        outputRange[0] = firstOutputRangeArr;
        for (i = 1; i < size; ++i) {
            double[] outputArr = new double[firstOutputRangeArr.length];
            int j = 0;
            m = sNumericPattern.matcher(array.getString(i));
            while (m.find() && j < firstOutputRangeArr.length) {
                outputArr[j++] = Double.parseDouble(m.group());
            }
            outputRange[i] = outputArr;
        }
        return outputRange;
    }

    private static double interpolate(double value, double inputMin, double inputMax, double outputMin, double outputMax, String extrapolateLeft, String extrapolateRight) {
        double result = value;
        if (result < inputMin) {
            switch (extrapolateLeft) {
                case "identity": {
                    return result;
                }
                case "clamp": {
                    result = inputMin;
                    break;
                }
                case "extend": {
                    break;
                }
                default: {
                    throw new JSApplicationIllegalArgumentException("Invalid extrapolation type " + extrapolateLeft + "for left extrapolation");
                }
            }
        }
        if (result > inputMax) {
            switch (extrapolateRight) {
                case "identity": {
                    return result;
                }
                case "clamp": {
                    result = inputMax;
                    break;
                }
                case "extend": {
                    break;
                }
                default: {
                    throw new JSApplicationIllegalArgumentException("Invalid extrapolation type " + extrapolateRight + "for right extrapolation");
                }
            }
        }
        if (outputMin == outputMax) {
            return outputMin;
        }
        if (inputMin == inputMax) {
            if (value <= inputMin) {
                return outputMin;
            }
            return outputMax;
        }
        return outputMin + (outputMax - outputMin) * (result - inputMin) / (inputMax - inputMin);
    }

    static double interpolate(double value, double[] inputRange, double[] outputRange, String extrapolateLeft, String extrapolateRight) {
        int rangeIndex = InterpolationAnimatedNode.findRangeIndex(value, inputRange);
        return InterpolationAnimatedNode.interpolate(value, inputRange[rangeIndex], inputRange[rangeIndex + 1], outputRange[rangeIndex], outputRange[rangeIndex + 1], extrapolateLeft, extrapolateRight);
    }

    static int interpolateColor(double value, double[] inputRange, int[] outputRange) {
        int outputMax;
        int rangeIndex = InterpolationAnimatedNode.findRangeIndex(value, inputRange);
        int outputMin = outputRange[rangeIndex];
        if (outputMin == (outputMax = outputRange[rangeIndex + 1])) {
            return outputMin;
        }
        double inputMin = inputRange[rangeIndex];
        double inputMax = inputRange[rangeIndex + 1];
        if (inputMin == inputMax) {
            if (value <= inputMin) {
                return outputMin;
            }
            return outputMax;
        }
        double ratio = (value - inputMin) / (inputMax - inputMin);
        return ColorUtils.blendARGB((int)outputMin, (int)outputMax, (float)((float)ratio));
    }

    static String interpolateString(String pattern, double value, double[] inputRange, double[][] outputRange, String extrapolateLeft, String extrapolateRight) {
        int rangeIndex = InterpolationAnimatedNode.findRangeIndex(value, inputRange);
        StringBuffer sb = new StringBuffer(pattern.length());
        Matcher m = sNumericPattern.matcher(pattern);
        for (int i = 0; m.find() && i < outputRange[rangeIndex].length; ++i) {
            double val = InterpolationAnimatedNode.interpolate(value, inputRange[rangeIndex], inputRange[rangeIndex + 1], outputRange[rangeIndex][i], outputRange[rangeIndex + 1][i], extrapolateLeft, extrapolateRight);
            int intVal = (int)val;
            m.appendReplacement(sb, (double)intVal != val ? Double.toString(val) : Integer.toString(intVal));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static int findRangeIndex(double value, double[] ranges) {
        int index;
        for (index = 1; index < ranges.length - 1 && !(ranges[index] >= value); ++index) {
        }
        return index - 1;
    }

    public InterpolationAnimatedNode(ReadableMap config) {
        this.mInputRange = InterpolationAnimatedNode.fromDoubleArray(config.getArray("inputRange"));
        ReadableArray output = config.getArray("outputRange");
        if (COLOR_OUTPUT_TYPE.equals(config.getString("outputType"))) {
            this.mOutputType = OutputType.Color;
            this.mOutputRange = InterpolationAnimatedNode.fromIntArray(output);
            this.mPattern = null;
        } else if (output.getType(0) == ReadableType.String) {
            this.mOutputType = OutputType.String;
            this.mOutputRange = InterpolationAnimatedNode.fromStringPattern(output);
            this.mPattern = output.getString(0);
        } else {
            this.mOutputType = OutputType.Number;
            this.mOutputRange = InterpolationAnimatedNode.fromDoubleArray(output);
            this.mPattern = null;
        }
        this.mExtrapolateLeft = config.getString("extrapolateLeft");
        this.mExtrapolateRight = config.getString("extrapolateRight");
    }

    @Override
    public void onAttachedToNode(AnimatedNode parent) {
        if (this.mParent != null) {
            throw new IllegalStateException("Parent already attached");
        }
        if (!(parent instanceof ValueAnimatedNode)) {
            throw new IllegalArgumentException("Parent is of an invalid type");
        }
        this.mParent = (ValueAnimatedNode)parent;
    }

    @Override
    public void onDetachedFromNode(AnimatedNode parent) {
        if (parent != this.mParent) {
            throw new IllegalArgumentException("Invalid parent node provided");
        }
        this.mParent = null;
    }

    @Override
    public void update() {
        if (this.mParent == null) {
            return;
        }
        double value = this.mParent.getValue();
        switch (this.mOutputType) {
            case Number: {
                this.mValue = InterpolationAnimatedNode.interpolate(value, this.mInputRange, (double[])this.mOutputRange, this.mExtrapolateLeft, this.mExtrapolateRight);
                break;
            }
            case Color: {
                this.mObjectValue = InterpolationAnimatedNode.interpolateColor(value, this.mInputRange, (int[])this.mOutputRange);
                break;
            }
            case String: {
                this.mObjectValue = InterpolationAnimatedNode.interpolateString(this.mPattern, value, this.mInputRange, (double[][])this.mOutputRange, this.mExtrapolateLeft, this.mExtrapolateRight);
            }
        }
    }

    @Override
    public Object getAnimatedObject() {
        return this.mObjectValue;
    }

    @Override
    public String prettyPrint() {
        return "InterpolationAnimatedNode[" + this.mTag + "] super: " + super.prettyPrint();
    }

    private static enum OutputType {
        Number,
        Color,
        String;

    }
}

