/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeExceptionsManagerSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.JavascriptException;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.util.ExceptionDataHelper;
import com.facebook.react.util.JSStackTrace;

@ReactModule(name="ExceptionsManager")
public class ExceptionsManagerModule
extends NativeExceptionsManagerSpec {
    private final DevSupportManager mDevSupportManager;

    public ExceptionsManagerModule(DevSupportManager devSupportManager) {
        super(null);
        this.mDevSupportManager = devSupportManager;
    }

    @Override
    public void reportFatalException(String message, ReadableArray stack, double idDouble) {
        int id2 = (int)idDouble;
        JavaOnlyMap data = new JavaOnlyMap();
        data.putString("message", message);
        data.putArray("stack", stack);
        data.putInt("id", id2);
        data.putBoolean("isFatal", true);
        this.reportException(data);
    }

    @Override
    public void reportSoftException(String message, ReadableArray stack, double idDouble) {
        int id2 = (int)idDouble;
        JavaOnlyMap data = new JavaOnlyMap();
        data.putString("message", message);
        data.putArray("stack", stack);
        data.putInt("id", id2);
        data.putBoolean("isFatal", false);
        this.reportException(data);
    }

    @Override
    public void reportException(ReadableMap data) {
        String message = data.hasKey("message") ? data.getString("message") : "";
        WritableArray stack = data.hasKey("stack") ? data.getArray("stack") : Arguments.createArray();
        boolean isFatal = data.hasKey("isFatal") ? data.getBoolean("isFatal") : false;
        String extraDataAsJson = ExceptionDataHelper.getExtraDataAsJson(data);
        if (isFatal) {
            throw new JavascriptException(JSStackTrace.format(message, stack)).setExtraDataAsJson(extraDataAsJson);
        }
        FLog.e((String)"ReactNative", (String)JSStackTrace.format(message, stack));
        if (extraDataAsJson != null) {
            FLog.d((String)"ReactNative", (String)"extraData: %s", (Object)extraDataAsJson);
        }
    }

    @Override
    public void updateExceptionMessage(String title, ReadableArray details, double exceptionIdDouble) {
        int exceptionId = (int)exceptionIdDouble;
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            this.mDevSupportManager.updateJSError(title, details, exceptionId);
        }
    }

    @Override
    public void dismissRedbox() {
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            this.mDevSupportManager.hideRedboxDialog();
        }
    }
}

