/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerListener;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.ReactRootViewTagGenerator;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIImplementation;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.UIManagerModuleConstants;
import com.facebook.react.uimanager.UIManagerModuleConstantsHelper;
import com.facebook.react.uimanager.UIManagerModuleListener;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.ViewManagerResolver;
import com.facebook.react.uimanager.YogaNodePool;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherImpl;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

@ReactModule(name="UIManager")
public class UIManagerModule
extends ReactContextBaseJavaModule
implements OnBatchCompleteListener,
LifecycleEventListener,
UIManager {
    public static final String TAG = UIManagerModule.class.getSimpleName();
    public static final String NAME = "UIManager";
    private static final boolean DEBUG = PrinterHolder.getPrinter().shouldDisplayLogMessage(ReactDebugOverlayTags.UI_MANAGER);
    private final EventDispatcher mEventDispatcher;
    private final Map<String, Object> mModuleConstants;
    private final Map<String, Object> mCustomDirectEvents;
    private final ViewManagerRegistry mViewManagerRegistry;
    private final UIImplementation mUIImplementation;
    private final MemoryTrimCallback mMemoryTrimCallback = new MemoryTrimCallback();
    private final List<UIManagerModuleListener> mListeners = new ArrayList<UIManagerModuleListener>();
    private final CopyOnWriteArrayList<UIManagerListener> mUIManagerListeners = new CopyOnWriteArrayList();
    private int mBatchId = 0;

    public UIManagerModule(ReactApplicationContext reactContext, ViewManagerResolver viewManagerResolver, int minTimeLeftInFrameForNonBatchedOperationMs) {
        super(reactContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)reactContext);
        this.mEventDispatcher = new EventDispatcherImpl(reactContext);
        this.mModuleConstants = UIManagerModule.createConstants(viewManagerResolver);
        this.mCustomDirectEvents = UIManagerModuleConstants.getDirectEventTypeConstants();
        this.mViewManagerRegistry = new ViewManagerRegistry(viewManagerResolver);
        this.mUIImplementation = new UIImplementation(reactContext, this.mViewManagerRegistry, this.mEventDispatcher, minTimeLeftInFrameForNonBatchedOperationMs);
        reactContext.addLifecycleEventListener(this);
    }

    public UIManagerModule(ReactApplicationContext reactContext, List<ViewManager> viewManagersList, int minTimeLeftInFrameForNonBatchedOperationMs) {
        super(reactContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)reactContext);
        this.mEventDispatcher = new EventDispatcherImpl(reactContext);
        this.mCustomDirectEvents = MapBuilder.newHashMap();
        this.mModuleConstants = UIManagerModule.createConstants(viewManagersList, null, this.mCustomDirectEvents);
        this.mViewManagerRegistry = new ViewManagerRegistry(viewManagersList);
        this.mUIImplementation = new UIImplementation(reactContext, this.mViewManagerRegistry, this.mEventDispatcher, minTimeLeftInFrameForNonBatchedOperationMs);
        reactContext.addLifecycleEventListener(this);
    }

    @Deprecated
    public UIImplementation getUIImplementation() {
        return this.mUIImplementation;
    }

    @Override
    @NonNull
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getConstants() {
        return this.mModuleConstants;
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().registerComponentCallbacks((ComponentCallbacks)this.mMemoryTrimCallback);
        this.getReactApplicationContext().registerComponentCallbacks((ComponentCallbacks)this.mViewManagerRegistry);
        this.mEventDispatcher.registerEventEmitter(1, this.getReactApplicationContext().getJSModule(RCTEventEmitter.class));
    }

    @Override
    public void onHostResume() {
        this.mUIImplementation.onHostResume();
    }

    @Override
    public void onHostPause() {
        this.mUIImplementation.onHostPause();
    }

    @Override
    public void onHostDestroy() {
        this.mUIImplementation.onHostDestroy();
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        this.mEventDispatcher.onCatalystInstanceDestroyed();
        this.mUIImplementation.onCatalystInstanceDestroyed();
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        reactApplicationContext.unregisterComponentCallbacks((ComponentCallbacks)this.mMemoryTrimCallback);
        reactApplicationContext.unregisterComponentCallbacks((ComponentCallbacks)this.mViewManagerRegistry);
        YogaNodePool.get().clear();
        ViewManagerPropertyUpdater.clear();
    }

    @Deprecated
    public ViewManagerRegistry getViewManagerRegistry_DO_NOT_USE() {
        return this.mViewManagerRegistry;
    }

    private static Map<String, Object> createConstants(ViewManagerResolver viewManagerResolver) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_START);
        SystraceMessage.beginSection(0L, "CreateUIManagerConstants").arg("Lazy", true).flush();
        try {
            Map<String, Object> map = UIManagerModuleConstantsHelper.createConstants(viewManagerResolver);
            return map;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_END);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> createConstants(List<ViewManager> viewManagers, @Nullable Map<String, Object> customBubblingEvents, @Nullable Map<String, Object> customDirectEvents) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_START);
        SystraceMessage.beginSection(0L, "CreateUIManagerConstants").arg("Lazy", false).flush();
        try {
            Map<String, Object> map = UIManagerModuleConstantsHelper.createConstants(viewManagers, customBubblingEvents, customDirectEvents);
            return map;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_END);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod(isBlockingSynchronousMethod=true)
    @Nullable
    public WritableMap getConstantsForViewManager(@Nullable String viewManagerName) {
        ViewManager targetView;
        ViewManager viewManager = targetView = viewManagerName != null ? this.mUIImplementation.resolveViewManager(viewManagerName) : null;
        if (targetView == null) {
            return null;
        }
        SystraceMessage.beginSection(0L, "UIManagerModule.getConstantsForViewManager").arg("ViewManager", targetView.getName()).arg("Lazy", true).flush();
        try {
            Map<String, Object> viewManagerConstants = UIManagerModuleConstantsHelper.createConstantsForViewManager(targetView, null, null, null, this.mCustomDirectEvents);
            if (viewManagerConstants != null) {
                WritableNativeMap writableNativeMap = Arguments.makeNativeMap(viewManagerConstants);
                return writableNativeMap;
            }
            WritableMap writableMap = null;
            return writableMap;
        }
        finally {
            SystraceMessage.endSection(0L).flush();
        }
    }

    @ReactMethod(isBlockingSynchronousMethod=true)
    public WritableMap getDefaultEventTypes() {
        return Arguments.makeNativeMap(UIManagerModuleConstantsHelper.getDefaultExportableEventTypes());
    }

    @Deprecated
    public CustomEventNamesResolver getDirectEventNamesResolver() {
        return new CustomEventNamesResolver(){

            @Override
            @Nullable
            public String resolveCustomEventName(@Nullable String eventName) {
                return UIManagerModule.this.resolveCustomDirectEventName(eventName);
            }
        };
    }

    @Override
    @Deprecated
    @Nullable
    public String resolveCustomDirectEventName(@Nullable String eventName) {
        Map customEventType;
        if (eventName != null && (customEventType = (Map)this.mCustomDirectEvents.get(eventName)) != null) {
            return (String)customEventType.get("registrationName");
        }
        return eventName;
    }

    @Override
    public void profileNextBatch() {
        this.mUIImplementation.profileNextBatch();
    }

    @Override
    public Map<String, Long> getPerformanceCounters() {
        return this.mUIImplementation.getProfiledBatchPerfCounters();
    }

    public <T extends View> int addRootView(T rootView) {
        return this.addRootView(rootView, null, null);
    }

    @Override
    public void synchronouslyUpdateViewOnUIThread(int tag, ReadableMap props) {
        this.mUIImplementation.synchronouslyUpdateViewOnUIThread(tag, new ReactStylesDiffMap(props));
    }

    @Override
    public <T extends View> int addRootView(T rootView, WritableMap initialProps, @Nullable String initialUITemplate) {
        Systrace.beginSection(0L, "UIManagerModule.addRootView");
        int tag = ReactRootViewTagGenerator.getNextRootViewTag();
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        ThemedReactContext themedRootContext = new ThemedReactContext(reactApplicationContext, rootView.getContext(), ((ReactRoot)rootView).getSurfaceID(), -1);
        this.mUIImplementation.registerRootView(rootView, tag, themedRootContext);
        Systrace.endSection(0L);
        return tag;
    }

    @Override
    public <T extends View> int startSurface(T rootView, String moduleName, WritableMap initialProps, int widthMeasureSpec, int heightMeasureSpec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopSurface(int surfaceId) {
        throw new UnsupportedOperationException();
    }

    @ReactMethod
    public void removeRootView(int rootViewTag) {
        this.mUIImplementation.removeRootView(rootViewTag);
    }

    public void updateNodeSize(int nodeViewTag, int newWidth, int newHeight) {
        this.getReactApplicationContext().assertOnNativeModulesQueueThread();
        this.mUIImplementation.updateNodeSize(nodeViewTag, newWidth, newHeight);
    }

    public void setViewLocalData(final int tag, final Object data) {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        reactApplicationContext.assertOnUiQueueThread();
        reactApplicationContext.runOnNativeModulesQueueThread(new GuardedRunnable(reactApplicationContext){

            @Override
            public void runGuarded() {
                UIManagerModule.this.mUIImplementation.setViewLocalData(tag, data);
            }
        });
    }

    @ReactMethod
    public void createView(int tag, String className, int rootViewTag, ReadableMap props) {
        if (DEBUG) {
            String message = "(UIManager.createView) tag: " + tag + ", class: " + className + ", props: " + props;
            FLog.d((String)"ReactNative", (String)message);
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.UI_MANAGER, message);
        }
        this.mUIImplementation.createView(tag, className, rootViewTag, props);
    }

    @ReactMethod
    public void updateView(int tag, String className, ReadableMap props) {
        if (DEBUG) {
            String message = "(UIManager.updateView) tag: " + tag + ", class: " + className + ", props: " + props;
            FLog.d((String)"ReactNative", (String)message);
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.UI_MANAGER, message);
        }
        this.mUIImplementation.updateView(tag, className, props);
    }

    @ReactMethod
    public void manageChildren(int viewTag, @Nullable ReadableArray moveFrom, @Nullable ReadableArray moveTo, @Nullable ReadableArray addChildTags, @Nullable ReadableArray addAtIndices, @Nullable ReadableArray removeFrom) {
        if (DEBUG) {
            String message = "(UIManager.manageChildren) tag: " + viewTag + ", moveFrom: " + moveFrom + ", moveTo: " + moveTo + ", addTags: " + addChildTags + ", atIndices: " + addAtIndices + ", removeFrom: " + removeFrom;
            FLog.d((String)"ReactNative", (String)message);
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.UI_MANAGER, message);
        }
        this.mUIImplementation.manageChildren(viewTag, moveFrom, moveTo, addChildTags, addAtIndices, removeFrom);
    }

    @ReactMethod
    public void setChildren(int viewTag, ReadableArray childrenTags) {
        if (DEBUG) {
            String message = "(UIManager.setChildren) tag: " + viewTag + ", children: " + childrenTags;
            FLog.d((String)"ReactNative", (String)message);
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.UI_MANAGER, message);
        }
        this.mUIImplementation.setChildren(viewTag, childrenTags);
    }

    @ReactMethod
    @Deprecated
    public void replaceExistingNonRootView(int oldTag, int newTag) {
        this.mUIImplementation.replaceExistingNonRootView(oldTag, newTag);
    }

    @ReactMethod
    @Deprecated
    public void removeSubviewsFromContainerWithID(int containerTag) {
        this.mUIImplementation.removeSubviewsFromContainerWithID(containerTag);
    }

    @ReactMethod
    public void measure(int reactTag, Callback callback) {
        this.mUIImplementation.measure(reactTag, callback);
    }

    @ReactMethod
    public void measureInWindow(int reactTag, Callback callback) {
        this.mUIImplementation.measureInWindow(reactTag, callback);
    }

    @ReactMethod
    public void measureLayout(int tag, int ancestorTag, Callback errorCallback, Callback successCallback) {
        this.mUIImplementation.measureLayout(tag, ancestorTag, errorCallback, successCallback);
    }

    @ReactMethod
    @Deprecated
    public void measureLayoutRelativeToParent(int tag, Callback errorCallback, Callback successCallback) {
        this.mUIImplementation.measureLayoutRelativeToParent(tag, errorCallback, successCallback);
    }

    @ReactMethod
    public void findSubviewIn(int reactTag, ReadableArray point, Callback callback) {
        this.mUIImplementation.findSubviewIn(reactTag, Math.round(PixelUtil.toPixelFromDIP(point.getDouble(0))), Math.round(PixelUtil.toPixelFromDIP(point.getDouble(1))), callback);
    }

    @ReactMethod
    @Deprecated
    public void viewIsDescendantOf(int reactTag, int ancestorReactTag, Callback callback) {
        this.mUIImplementation.viewIsDescendantOf(reactTag, ancestorReactTag, callback);
    }

    @ReactMethod
    public void setJSResponder(int reactTag, boolean blockNativeResponder) {
        this.mUIImplementation.setJSResponder(reactTag, blockNativeResponder);
    }

    @ReactMethod
    public void clearJSResponder() {
        this.mUIImplementation.clearJSResponder();
    }

    @ReactMethod
    public void dispatchViewManagerCommand(int reactTag, Dynamic commandId, @Nullable ReadableArray commandArgs) {
        UIManager uiManager = UIManagerHelper.getUIManager(this.getReactApplicationContext(), ViewUtil.getUIManagerType(reactTag));
        if (uiManager == null) {
            return;
        }
        if (commandId.getType() == ReadableType.Number) {
            uiManager.dispatchCommand(reactTag, commandId.asInt(), commandArgs);
        } else if (commandId.getType() == ReadableType.String) {
            uiManager.dispatchCommand(reactTag, commandId.asString(), commandArgs);
        }
    }

    @Override
    @Deprecated
    public void dispatchCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        this.mUIImplementation.dispatchViewManagerCommand(reactTag, commandId, commandArgs);
    }

    @Override
    public void dispatchCommand(int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        this.mUIImplementation.dispatchViewManagerCommand(reactTag, commandId, commandArgs);
    }

    @ReactMethod
    public void showPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.mUIImplementation.showPopupMenu(reactTag, items, error, success);
    }

    @ReactMethod
    public void dismissPopupMenu() {
        this.mUIImplementation.dismissPopupMenu();
    }

    @ReactMethod
    public void setLayoutAnimationEnabledExperimental(boolean enabled) {
        this.mUIImplementation.setLayoutAnimationEnabledExperimental(enabled);
    }

    @ReactMethod
    public void configureNextLayoutAnimation(ReadableMap config, Callback success, Callback error) {
        this.mUIImplementation.configureNextLayoutAnimation(config, success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBatchComplete() {
        int batchId = this.mBatchId++;
        SystraceMessage.beginSection(0L, "onBatchCompleteUI").arg("BatchId", batchId).flush();
        for (UIManagerModuleListener uIManagerModuleListener : this.mListeners) {
            uIManagerModuleListener.willDispatchViewUpdates(this);
        }
        for (UIManagerListener uIManagerListener : this.mUIManagerListeners) {
            uIManagerListener.willDispatchViewUpdates(this);
        }
        try {
            this.mUIImplementation.dispatchViewUpdates(batchId);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void setViewHierarchyUpdateDebugListener(@Nullable NotThreadSafeViewHierarchyUpdateDebugListener listener) {
        this.mUIImplementation.setViewHierarchyUpdateDebugListener(listener);
    }

    public EventDispatcher getEventDispatcher() {
        return this.mEventDispatcher;
    }

    @Override
    @ReactMethod
    public void sendAccessibilityEvent(int tag, int eventType) {
        int uiManagerType = ViewUtil.getUIManagerType(tag);
        if (uiManagerType == 2) {
            UIManager fabricUIManager = UIManagerHelper.getUIManager(this.getReactApplicationContext(), uiManagerType);
            if (fabricUIManager != null) {
                fabricUIManager.sendAccessibilityEvent(tag, eventType);
            }
        } else {
            this.mUIImplementation.sendAccessibilityEvent(tag, eventType);
        }
    }

    public void addUIBlock(UIBlock block) {
        this.mUIImplementation.addUIBlock(block);
    }

    public void prependUIBlock(UIBlock block) {
        this.mUIImplementation.prependUIBlock(block);
    }

    @Deprecated
    public void addUIManagerListener(UIManagerModuleListener listener) {
        this.mListeners.add(listener);
    }

    @Deprecated
    public void removeUIManagerListener(UIManagerModuleListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void addUIManagerEventListener(UIManagerListener listener) {
        this.mUIManagerListeners.add(listener);
    }

    @Override
    public void removeUIManagerEventListener(UIManagerListener listener) {
        this.mUIManagerListeners.remove(listener);
    }

    @Deprecated
    public int resolveRootTagFromReactTag(int reactTag) {
        return ViewUtil.isRootTag(reactTag) ? reactTag : this.mUIImplementation.resolveRootTagFromReactTag(reactTag);
    }

    public void invalidateNodeLayout(int tag) {
        ReactShadowNode node = this.mUIImplementation.resolveShadowNode(tag);
        if (node == null) {
            FLog.w((String)"ReactNative", (String)("Warning : attempted to dirty a non-existent react shadow node. reactTag=" + tag));
            return;
        }
        node.dirty();
        this.mUIImplementation.dispatchViewUpdates(-1);
    }

    @Override
    public void updateRootLayoutSpecs(final int rootViewTag, final int widthMeasureSpec, final int heightMeasureSpec, int offsetX, int offsetY) {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        reactApplicationContext.runOnNativeModulesQueueThread(new GuardedRunnable(reactApplicationContext){

            @Override
            public void runGuarded() {
                UIManagerModule.this.mUIImplementation.updateRootView(rootViewTag, widthMeasureSpec, heightMeasureSpec);
                UIManagerModule.this.mUIImplementation.dispatchViewUpdates(-1);
            }
        });
    }

    @Override
    public View resolveView(int tag) {
        UiThreadUtil.assertOnUiThread();
        return this.mUIImplementation.getUIViewOperationQueue().getNativeViewHierarchyManager().resolveView(tag);
    }

    @Override
    public void receiveEvent(int reactTag, String eventName, @Nullable WritableMap event) {
        this.receiveEvent(-1, reactTag, eventName, event);
    }

    @Override
    public void receiveEvent(int surfaceId, int reactTag, String eventName, @Nullable WritableMap event) {
        assert (ViewUtil.getUIManagerType(reactTag) == 1);
        this.getReactApplicationContext().getJSModule(RCTEventEmitter.class).receiveEvent(reactTag, eventName, event);
    }

    private static class MemoryTrimCallback
    implements ComponentCallbacks2 {
        private MemoryTrimCallback() {
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                YogaNodePool.get().clear();
            }
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
        }
    }

    public static interface CustomEventNamesResolver {
        @Nullable
        public String resolveCustomEventName(String var1);
    }
}

