/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import java.text.BreakIterator;

public enum TextTransform {
    NONE,
    UPPERCASE,
    LOWERCASE,
    CAPITALIZE,
    UNSET;


    public static String apply(String text, TextTransform textTransform) {
        if (text == null) {
            return null;
        }
        return switch (textTransform) {
            case UPPERCASE -> text.toUpperCase();
            case LOWERCASE -> text.toLowerCase();
            case CAPITALIZE -> TextTransform.capitalize(text);
            default -> text;
        };
    }

    private static String capitalize(String text) {
        BreakIterator wordIterator = BreakIterator.getWordInstance();
        wordIterator.setText(text);
        StringBuilder res = new StringBuilder(text.length());
        int start = wordIterator.first();
        int end = wordIterator.next();
        while (end != -1) {
            String word = text.substring(start, end);
            if (Character.isLetterOrDigit(word.charAt(0))) {
                res.append(Character.toUpperCase(word.charAt(0)));
                res.append(word.substring(1).toLowerCase());
            } else {
                res.append(word);
            }
            start = end;
            end = wordIterator.next();
        }
        return res.toString();
    }
}

