/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import androidx.annotation.Nullable;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackageLogger;
import com.facebook.react.TurboReactPackage;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.devsupport.LogBoxModule;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ExceptionsManagerModule;
import com.facebook.react.modules.core.HeadlessJsTaskSupportModule;
import com.facebook.react.modules.core.TimingModule;
import com.facebook.react.modules.debug.DevSettingsModule;
import com.facebook.react.modules.debug.SourceCodeModule;
import com.facebook.react.modules.deviceinfo.DeviceInfoModule;
import com.facebook.react.modules.systeminfo.AndroidInfoModule;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerResolver;
import com.facebook.systrace.Systrace;
import java.util.Collection;
import java.util.HashMap;

public class CoreModulesPackage
extends TurboReactPackage
implements ReactPackageLogger {
    private final ReactInstanceManager mReactInstanceManager;
    private final DefaultHardwareBackBtnHandler mHardwareBackBtnHandler;
    private final boolean mLazyViewManagersEnabled;
    private final int mMinTimeLeftInFrameForNonBatchedOperationMs;

    public CoreModulesPackage(ReactInstanceManager reactInstanceManager, DefaultHardwareBackBtnHandler hardwareBackBtnHandler, boolean lazyViewManagersEnabled, int minTimeLeftInFrameForNonBatchedOperationMs) {
        this.mReactInstanceManager = reactInstanceManager;
        this.mHardwareBackBtnHandler = hardwareBackBtnHandler;
        this.mLazyViewManagersEnabled = lazyViewManagersEnabled;
        this.mMinTimeLeftInFrameForNonBatchedOperationMs = minTimeLeftInFrameForNonBatchedOperationMs;
    }

    @Override
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        try {
            Class<?> reactModuleInfoProviderClass = Class.forName("com.facebook.react.CoreModulesPackage$$ReactModuleInfoProvider");
            return (ReactModuleInfoProvider)reactModuleInfoProviderClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            Class[] moduleList = new Class[]{AndroidInfoModule.class, DeviceEventManagerModule.class, DeviceInfoModule.class, DevSettingsModule.class, ExceptionsManagerModule.class, LogBoxModule.class, HeadlessJsTaskSupportModule.class, SourceCodeModule.class, TimingModule.class, UIManagerModule.class};
            HashMap<String, ReactModuleInfo> reactModuleInfoMap = new HashMap<String, ReactModuleInfo>();
            for (Class moduleClass : moduleList) {
                ReactModule reactModule = moduleClass.getAnnotation(ReactModule.class);
                reactModuleInfoMap.put(reactModule.name(), new ReactModuleInfo(reactModule.name(), moduleClass.getName(), reactModule.canOverrideExistingModule(), reactModule.needsEagerInit(), reactModule.isCxxModule(), TurboModule.class.isAssignableFrom(moduleClass)));
            }
            return () -> reactModuleInfoMap;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for CoreModulesPackage$$ReactModuleInfoProvider", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for CoreModulesPackage$$ReactModuleInfoProvider", e);
        }
    }

    @Override
    public NativeModule getModule(String name, ReactApplicationContext reactContext) {
        switch (name) {
            case "PlatformConstants": {
                return new AndroidInfoModule(reactContext);
            }
            case "DeviceEventManager": {
                return new DeviceEventManagerModule(reactContext, this.mHardwareBackBtnHandler);
            }
            case "DevSettings": {
                return new DevSettingsModule(reactContext, this.mReactInstanceManager.getDevSupportManager());
            }
            case "ExceptionsManager": {
                return new ExceptionsManagerModule(this.mReactInstanceManager.getDevSupportManager());
            }
            case "LogBox": {
                return new LogBoxModule(reactContext, this.mReactInstanceManager.getDevSupportManager());
            }
            case "HeadlessJsTaskSupport": {
                return new HeadlessJsTaskSupportModule(reactContext);
            }
            case "SourceCode": {
                return new SourceCodeModule(reactContext);
            }
            case "Timing": {
                return new TimingModule(reactContext, this.mReactInstanceManager.getDevSupportManager());
            }
            case "UIManager": {
                return this.createUIManager(reactContext);
            }
            case "DeviceInfo": {
                return new DeviceInfoModule(reactContext);
            }
        }
        throw new IllegalArgumentException("In CoreModulesPackage, could not find Native module for " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UIManagerModule createUIManager(ReactApplicationContext reactContext) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_START);
        Systrace.beginSection(0L, "createUIManagerModule");
        try {
            if (this.mLazyViewManagersEnabled) {
                ViewManagerResolver resolver = new ViewManagerResolver(){

                    @Override
                    @Nullable
                    public ViewManager getViewManager(String viewManagerName) {
                        return CoreModulesPackage.this.mReactInstanceManager.createViewManager(viewManagerName);
                    }

                    @Override
                    public Collection<String> getViewManagerNames() {
                        return CoreModulesPackage.this.mReactInstanceManager.getViewManagerNames();
                    }
                };
                UIManagerModule uIManagerModule = new UIManagerModule(reactContext, resolver, this.mMinTimeLeftInFrameForNonBatchedOperationMs);
                return uIManagerModule;
            }
            UIManagerModule uIManagerModule = new UIManagerModule(reactContext, this.mReactInstanceManager.getOrCreateViewManagers(reactContext), this.mMinTimeLeftInFrameForNonBatchedOperationMs);
            return uIManagerModule;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_END);
        }
    }

    @Override
    public void startProcessPackage() {
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_CORE_REACT_PACKAGE_START);
    }

    @Override
    public void endProcessPackage() {
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_CORE_REACT_PACKAGE_END);
    }
}

