/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.Base64;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.modules.network.ProgressListener;
import com.facebook.react.modules.network.ProgressRequestBody;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import okio.Source;

class RequestBodyUtil {
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String NAME = "RequestBodyUtil";
    private static final String TEMP_FILE_SUFFIX = "temp";

    RequestBodyUtil() {
    }

    public static boolean isGzipEncoding(@Nullable String encodingType) {
        return CONTENT_ENCODING_GZIP.equalsIgnoreCase(encodingType);
    }

    @Nullable
    public static InputStream getFileInputStream(Context context, String fileContentUriStr) {
        try {
            Uri fileContentUri = Uri.parse((String)fileContentUriStr);
            if (fileContentUri.getScheme().startsWith("http")) {
                return RequestBodyUtil.getDownloadFileInputStream(context, fileContentUri);
            }
            if (fileContentUriStr.startsWith("data:")) {
                byte[] decodedDataUrString = Base64.decode((String)fileContentUriStr.split(",")[1], (int)0);
                Bitmap bitMap = BitmapFactory.decodeByteArray((byte[])decodedDataUrString, (int)0, (int)decodedDataUrString.length);
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                bitMap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)bytes);
                return new ByteArrayInputStream(bytes.toByteArray());
            }
            return context.getContentResolver().openInputStream(fileContentUri);
        }
        catch (Exception e) {
            FLog.e((String)"ReactNative", (String)("Could not retrieve file for contentUri " + fileContentUriStr), (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private static InputStream getDownloadFileInputStream(Context context, Uri uri) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static RequestBody createGzip(MediaType mediaType, String body) {
        ByteArrayOutputStream gzipByteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(gzipByteArrayOutputStream);
            ((OutputStream)gzipOutputStream).write(body.getBytes());
            ((OutputStream)gzipOutputStream).close();
        }
        catch (IOException e) {
            return null;
        }
        return RequestBody.create((MediaType)mediaType, (byte[])gzipByteArrayOutputStream.toByteArray());
    }

    private static void closeQuietly(Source source) {
        try {
            source.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static RequestBody create(final MediaType mediaType, final InputStream inputStream) {
        return new RequestBody(){

            public MediaType contentType() {
                return mediaType;
            }

            public long contentLength() {
                try {
                    return inputStream.available();
                }
                catch (IOException e) {
                    return 0L;
                }
            }

            public void writeTo(BufferedSink sink) throws IOException {
                Source source = null;
                try {
                    source = Okio.source((InputStream)inputStream);
                    sink.writeAll(source);
                }
                finally {
                    RequestBodyUtil.closeQuietly(source);
                }
            }
        };
    }

    public static ProgressRequestBody createProgressRequest(RequestBody requestBody, ProgressListener listener) {
        return new ProgressRequestBody(requestBody, listener);
    }

    public static RequestBody getEmptyBody(String method) {
        if (method.equals("POST") || method.equals("PUT") || method.equals("PATCH")) {
            return RequestBody.create(null, (ByteString)ByteString.EMPTY);
        }
        return null;
    }
}

