/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.shell;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import com.facebook.react.TurboReactPackage;
import com.facebook.react.ViewManagerOnDemandReactPackage;
import com.facebook.react.animated.NativeAnimatedModule;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.modules.accessibilityinfo.AccessibilityInfoModule;
import com.facebook.react.modules.appearance.AppearanceModule;
import com.facebook.react.modules.appstate.AppStateModule;
import com.facebook.react.modules.blob.BlobModule;
import com.facebook.react.modules.blob.FileReaderModule;
import com.facebook.react.modules.camera.ImageStoreManager;
import com.facebook.react.modules.clipboard.ClipboardModule;
import com.facebook.react.modules.devloading.DevLoadingModule;
import com.facebook.react.modules.devtoolssettings.DevToolsSettingsManagerModule;
import com.facebook.react.modules.dialog.DialogModule;
import com.facebook.react.modules.fresco.FrescoModule;
import com.facebook.react.modules.i18nmanager.I18nManagerModule;
import com.facebook.react.modules.image.ImageLoaderModule;
import com.facebook.react.modules.intent.IntentModule;
import com.facebook.react.modules.network.NetworkingModule;
import com.facebook.react.modules.permissions.PermissionsModule;
import com.facebook.react.modules.share.ShareModule;
import com.facebook.react.modules.sound.SoundManagerModule;
import com.facebook.react.modules.statusbar.StatusBarModule;
import com.facebook.react.modules.toast.ToastModule;
import com.facebook.react.modules.vibration.VibrationModule;
import com.facebook.react.modules.websocket.WebSocketModule;
import com.facebook.react.shell.MainPackageConfig;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.views.drawer.ReactDrawerLayoutManager;
import com.facebook.react.views.image.ReactImageManager;
import com.facebook.react.views.modal.ReactModalHostManager;
import com.facebook.react.views.progressbar.ReactProgressBarViewManager;
import com.facebook.react.views.scroll.ReactHorizontalScrollContainerViewManager;
import com.facebook.react.views.scroll.ReactHorizontalScrollViewManager;
import com.facebook.react.views.scroll.ReactScrollViewManager;
import com.facebook.react.views.swiperefresh.SwipeRefreshLayoutManager;
import com.facebook.react.views.switchview.ReactSwitchManager;
import com.facebook.react.views.text.ReactRawTextManager;
import com.facebook.react.views.text.ReactTextViewManager;
import com.facebook.react.views.text.ReactVirtualTextViewManager;
import com.facebook.react.views.text.frescosupport.FrescoBasedReactTextInlineImageViewManager;
import com.facebook.react.views.textinput.ReactTextInputManager;
import com.facebook.react.views.unimplementedview.ReactUnimplementedViewManager;
import com.facebook.react.views.view.ReactViewManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;

public class MainReactPackage
extends TurboReactPackage
implements ViewManagerOnDemandReactPackage {
    private MainPackageConfig mConfig;
    @Nullable
    private Map<String, ModuleSpec> mViewManagers;

    public MainReactPackage() {
    }

    public MainReactPackage(MainPackageConfig config) {
        this.mConfig = config;
    }

    @Override
    @Nullable
    public NativeModule getModule(String name, ReactApplicationContext context) {
        switch (name) {
            case "AccessibilityInfo": {
                return new AccessibilityInfoModule(context);
            }
            case "Appearance": {
                return new AppearanceModule(context);
            }
            case "AppState": {
                return new AppStateModule(context);
            }
            case "BlobModule": {
                return new BlobModule(context);
            }
            case "DevLoadingView": {
                return new DevLoadingModule(context);
            }
            case "FileReaderModule": {
                return new FileReaderModule(context);
            }
            case "Clipboard": {
                return new ClipboardModule(context);
            }
            case "DialogManagerAndroid": {
                return new DialogModule(context);
            }
            case "FrescoModule": {
                return new FrescoModule(context, true, this.mConfig != null ? this.mConfig.getFrescoConfig() : null);
            }
            case "I18nManager": {
                return new I18nManagerModule(context);
            }
            case "ImageLoader": {
                return new ImageLoaderModule(context);
            }
            case "ImageStoreManager": {
                return new ImageStoreManager(context);
            }
            case "IntentAndroid": {
                return new IntentModule(context);
            }
            case "NativeAnimatedModule": {
                return new NativeAnimatedModule(context);
            }
            case "Networking": {
                return new NetworkingModule(context);
            }
            case "PermissionsAndroid": {
                return new PermissionsModule(context);
            }
            case "ShareModule": {
                return new ShareModule(context);
            }
            case "StatusBarManager": {
                return new StatusBarModule(context);
            }
            case "SoundManager": {
                return new SoundManagerModule(context);
            }
            case "ToastAndroid": {
                return new ToastModule(context);
            }
            case "Vibration": {
                return new VibrationModule(context);
            }
            case "WebSocketModule": {
                return new WebSocketModule(context);
            }
            case "DevToolsSettingsManager": {
                return new DevToolsSettingsManagerModule(context);
            }
        }
        return null;
    }

    @Override
    public List<ViewManager> createViewManagers(ReactApplicationContext reactContext) {
        ArrayList<ViewManager> viewManagers = new ArrayList<ViewManager>();
        viewManagers.add(new ReactDrawerLayoutManager());
        viewManagers.add(new ReactHorizontalScrollViewManager());
        viewManagers.add(new ReactHorizontalScrollContainerViewManager());
        viewManagers.add(new ReactProgressBarViewManager());
        viewManagers.add(new ReactScrollViewManager());
        viewManagers.add(new ReactSwitchManager());
        viewManagers.add(new SwipeRefreshLayoutManager());
        viewManagers.add(new FrescoBasedReactTextInlineImageViewManager());
        viewManagers.add(new ReactImageManager());
        viewManagers.add(new ReactModalHostManager());
        viewManagers.add(new ReactRawTextManager());
        viewManagers.add(new ReactTextInputManager());
        viewManagers.add(new ReactTextViewManager());
        viewManagers.add(new ReactViewManager());
        viewManagers.add(new ReactVirtualTextViewManager());
        viewManagers.add(new ReactUnimplementedViewManager());
        return viewManagers;
    }

    private static void appendMap(Map<String, ModuleSpec> map, String name, Provider<? extends NativeModule> provider) {
        map.put(name, ModuleSpec.viewManagerSpec(provider));
    }

    @SuppressLint(value={"VisibleForTests"})
    public Map<String, ModuleSpec> getViewManagersMap() {
        if (this.mViewManagers == null) {
            HashMap<String, ModuleSpec> viewManagers = new HashMap<String, ModuleSpec>();
            MainReactPackage.appendMap(viewManagers, "AndroidDrawerLayout", (Provider<? extends NativeModule>)((Provider)ReactDrawerLayoutManager::new));
            MainReactPackage.appendMap(viewManagers, "AndroidHorizontalScrollView", (Provider<? extends NativeModule>)((Provider)ReactHorizontalScrollViewManager::new));
            MainReactPackage.appendMap(viewManagers, "AndroidHorizontalScrollContentView", (Provider<? extends NativeModule>)((Provider)ReactHorizontalScrollContainerViewManager::new));
            MainReactPackage.appendMap(viewManagers, "AndroidProgressBar", (Provider<? extends NativeModule>)((Provider)ReactProgressBarViewManager::new));
            MainReactPackage.appendMap(viewManagers, "RCTScrollView", (Provider<? extends NativeModule>)((Provider)ReactScrollViewManager::new));
            MainReactPackage.appendMap(viewManagers, "AndroidSwitch", (Provider<? extends NativeModule>)((Provider)ReactSwitchManager::new));
            MainReactPackage.appendMap(viewManagers, "AndroidSwipeRefreshLayout", (Provider<? extends NativeModule>)((Provider)SwipeRefreshLayoutManager::new));
            MainReactPackage.appendMap(viewManagers, "RCTTextInlineImage", (Provider<? extends NativeModule>)((Provider)FrescoBasedReactTextInlineImageViewManager::new));
            MainReactPackage.appendMap(viewManagers, "RCTImageView", (Provider<? extends NativeModule>)((Provider)ReactImageManager::new));
            MainReactPackage.appendMap(viewManagers, "RCTModalHostView", (Provider<? extends NativeModule>)((Provider)ReactModalHostManager::new));
            MainReactPackage.appendMap(viewManagers, "RCTRawText", (Provider<? extends NativeModule>)((Provider)ReactRawTextManager::new));
            MainReactPackage.appendMap(viewManagers, "AndroidTextInput", (Provider<? extends NativeModule>)((Provider)ReactTextInputManager::new));
            MainReactPackage.appendMap(viewManagers, "RCTText", (Provider<? extends NativeModule>)((Provider)ReactTextViewManager::new));
            MainReactPackage.appendMap(viewManagers, "RCTView", (Provider<? extends NativeModule>)((Provider)ReactViewManager::new));
            MainReactPackage.appendMap(viewManagers, "RCTVirtualText", (Provider<? extends NativeModule>)((Provider)ReactVirtualTextViewManager::new));
            MainReactPackage.appendMap(viewManagers, "UnimplementedNativeView", (Provider<? extends NativeModule>)((Provider)ReactUnimplementedViewManager::new));
            this.mViewManagers = viewManagers;
        }
        return this.mViewManagers;
    }

    @Override
    public List<ModuleSpec> getViewManagers(ReactApplicationContext reactContext) {
        return new ArrayList<ModuleSpec>(this.getViewManagersMap().values());
    }

    @Override
    public Collection<String> getViewManagerNames(ReactApplicationContext reactContext) {
        return this.getViewManagersMap().keySet();
    }

    @Override
    @Nullable
    public ViewManager createViewManager(ReactApplicationContext reactContext, String viewManagerName) {
        ModuleSpec spec = this.getViewManagersMap().get(viewManagerName);
        return spec != null ? (ViewManager)spec.getProvider().get() : null;
    }

    @Override
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        try {
            Class<?> reactModuleInfoProviderClass = Class.forName("com.facebook.react.shell.MainReactPackage$$ReactModuleInfoProvider");
            return (ReactModuleInfoProvider)reactModuleInfoProviderClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            Class[] moduleList = new Class[]{AccessibilityInfoModule.class, AppearanceModule.class, AppStateModule.class, BlobModule.class, DevLoadingModule.class, FileReaderModule.class, ClipboardModule.class, DialogModule.class, FrescoModule.class, I18nManagerModule.class, ImageLoaderModule.class, ImageStoreManager.class, IntentModule.class, NativeAnimatedModule.class, NetworkingModule.class, PermissionsModule.class, DevToolsSettingsManagerModule.class, ShareModule.class, StatusBarModule.class, SoundManagerModule.class, ToastModule.class, VibrationModule.class, WebSocketModule.class};
            HashMap<String, ReactModuleInfo> reactModuleInfoMap = new HashMap<String, ReactModuleInfo>();
            for (Class moduleClass : moduleList) {
                ReactModule reactModule = moduleClass.getAnnotation(ReactModule.class);
                if (reactModule == null) continue;
                reactModuleInfoMap.put(reactModule.name(), new ReactModuleInfo(reactModule.name(), moduleClass.getName(), reactModule.canOverrideExistingModule(), reactModule.needsEagerInit(), reactModule.isCxxModule(), TurboModule.class.isAssignableFrom(moduleClass)));
            }
            return () -> reactModuleInfoMap;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for CoreModulesPackage$$ReactModuleInfoProvider", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for CoreModulesPackage$$ReactModuleInfoProvider", e);
        }
    }
}

