/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.net.Uri;
import android.os.AsyncTask;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.devsupport.BundleDownloader;
import com.facebook.react.devsupport.CxxInspectorPackagerConnection;
import com.facebook.react.devsupport.IInspectorPackagerConnection;
import com.facebook.react.devsupport.InspectorFlags;
import com.facebook.react.devsupport.InspectorPackagerConnection;
import com.facebook.react.devsupport.PackagerStatusCheck;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.packagerconnection.FileIoHandler;
import com.facebook.react.packagerconnection.JSPackagerClient;
import com.facebook.react.packagerconnection.NotificationOnlyHandler;
import com.facebook.react.packagerconnection.PackagerConnectionSettings;
import com.facebook.react.packagerconnection.ReconnectingWebSocket;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.packagerconnection.RequestOnlyHandler;
import com.facebook.react.packagerconnection.Responder;
import com.facebook.react.util.RNLog;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class DevServerHelper {
    public static final String RELOAD_APP_EXTRA_JS_PROXY = "jsproxy";
    private static final int HTTP_CONNECT_TIMEOUT_MS = 5000;
    private static final String DEBUGGER_MSG_DISABLE = "{ \"id\":1,\"method\":\"Debugger.disable\" }";
    private final DeveloperSettings mSettings;
    private final PackagerConnectionSettings mPackagerConnectionSettings;
    private final OkHttpClient mClient;
    private final BundleDownloader mBundleDownloader;
    private final PackagerStatusCheck mPackagerStatusCheck;
    private final String mPackageName;
    @Nullable
    private JSPackagerClient mPackagerClient;
    @Nullable
    private IInspectorPackagerConnection mInspectorPackagerConnection;

    public DevServerHelper(DeveloperSettings developerSettings, String packageName, PackagerConnectionSettings packagerConnectionSettings) {
        this.mSettings = developerSettings;
        this.mPackagerConnectionSettings = packagerConnectionSettings;
        this.mClient = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).build();
        this.mBundleDownloader = new BundleDownloader(this.mClient);
        this.mPackagerStatusCheck = new PackagerStatusCheck(this.mClient);
        this.mPackageName = packageName;
    }

    public void openPackagerConnection(final String clientId, final PackagerCommandListener commandListener) {
        if (this.mPackagerClient != null) {
            FLog.w((String)"ReactNative", (String)"Packager connection already open, nooping.");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... backgroundParams) {
                HashMap<String, RequestHandler> handlers = new HashMap<String, RequestHandler>();
                handlers.put("reload", new NotificationOnlyHandler(){

                    @Override
                    public void onNotification(@Nullable Object params) {
                        commandListener.onPackagerReloadCommand();
                    }
                });
                handlers.put("devMenu", new NotificationOnlyHandler(){

                    @Override
                    public void onNotification(@Nullable Object params) {
                        commandListener.onPackagerDevMenuCommand();
                    }
                });
                handlers.put("captureHeap", new RequestOnlyHandler(){

                    @Override
                    public void onRequest(@Nullable Object params, Responder responder) {
                        commandListener.onCaptureHeapCommand(responder);
                    }
                });
                Map<String, RequestHandler> customHandlers = commandListener.customCommandHandlers();
                if (customHandlers != null) {
                    handlers.putAll(customHandlers);
                }
                handlers.putAll(new FileIoHandler().handlers());
                ReconnectingWebSocket.ConnectionCallback onPackagerConnectedCallback = new ReconnectingWebSocket.ConnectionCallback(){

                    @Override
                    public void onConnected() {
                        commandListener.onPackagerConnected();
                    }

                    @Override
                    public void onDisconnected() {
                        commandListener.onPackagerDisconnected();
                    }
                };
                DevServerHelper.this.mPackagerClient = new JSPackagerClient(clientId, DevServerHelper.this.mPackagerConnectionSettings, handlers, onPackagerConnectedCallback);
                DevServerHelper.this.mPackagerClient.init();
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void closePackagerConnection() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                if (DevServerHelper.this.mPackagerClient != null) {
                    DevServerHelper.this.mPackagerClient.close();
                    DevServerHelper.this.mPackagerClient = null;
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void openInspectorConnection() {
        if (this.mInspectorPackagerConnection != null) {
            FLog.w((String)"ReactNative", (String)"Inspector connection already open, nooping.");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                DevServerHelper.this.mInspectorPackagerConnection = InspectorFlags.getEnableCxxInspectorPackagerConnection() ? new CxxInspectorPackagerConnection(DevServerHelper.this.getInspectorDeviceUrl(), DevServerHelper.this.mPackageName) : new InspectorPackagerConnection(DevServerHelper.this.getInspectorDeviceUrl(), DevServerHelper.this.mPackageName);
                DevServerHelper.this.mInspectorPackagerConnection.connect();
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void disableDebugger() {
        if (this.mInspectorPackagerConnection != null) {
            this.mInspectorPackagerConnection.sendEventToAllConnections(DEBUGGER_MSG_DISABLE);
        }
    }

    public void closeInspectorConnection() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                if (DevServerHelper.this.mInspectorPackagerConnection != null) {
                    DevServerHelper.this.mInspectorPackagerConnection.closeQuietly();
                    DevServerHelper.this.mInspectorPackagerConnection = null;
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public String getWebsocketProxyURL() {
        return String.format(Locale.US, "ws://%s/debugger-proxy?role=client", this.mPackagerConnectionSettings.getDebugServerHost());
    }

    private static String getSHA256(String string2) {
        byte[] result;
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Could not get standard SHA-256 algorithm", e);
        }
        digest.reset();
        try {
            result = digest.digest(string2.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("This environment doesn't support UTF-8 encoding", e);
        }
        return String.format("%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x", result[0], result[1], result[2], result[3], result[4], result[5], result[6], result[7], result[8], result[9], result[10], result[11], result[12], result[13], result[14], result[15], result[16], result[17], result[18], result[19]);
    }

    private String getInspectorDeviceId() {
        String packageName = this.mPackageName;
        String androidId = "android_id";
        String rawDeviceId = String.format(Locale.US, "android-%s-%s", packageName, androidId);
        return DevServerHelper.getSHA256(rawDeviceId);
    }

    private String getInspectorDeviceUrl() {
        return String.format(Locale.US, "http://%s/inspector/device?name=%s&app=%s&device=%s", this.mPackagerConnectionSettings.getDebugServerHost(), Uri.encode((String)AndroidInfoHelpers.getFriendlyDeviceName()), Uri.encode((String)this.mPackageName), Uri.encode((String)this.getInspectorDeviceId()));
    }

    public void downloadBundleFromURL(DevBundleDownloadListener callback, File outputFile, String bundleURL, BundleDownloader.BundleInfo bundleInfo) {
        this.mBundleDownloader.downloadBundleFromURL(callback, outputFile, bundleURL, bundleInfo);
    }

    public void downloadBundleFromURL(DevBundleDownloadListener callback, File outputFile, String bundleURL, BundleDownloader.BundleInfo bundleInfo, Request.Builder requestBuilder) {
        this.mBundleDownloader.downloadBundleFromURL(callback, outputFile, bundleURL, bundleInfo, requestBuilder);
    }

    private String getHostForJSProxy() {
        String host = (String)Assertions.assertNotNull((Object)this.mPackagerConnectionSettings.getDebugServerHost());
        int portOffset = host.lastIndexOf(58);
        if (portOffset > -1) {
            return "localhost" + host.substring(portOffset);
        }
        return "localhost";
    }

    private boolean getDevMode() {
        return this.mSettings.isJSDevModeEnabled();
    }

    private boolean getJSMinifyMode() {
        return this.mSettings.isJSMinifyEnabled();
    }

    private String createBundleURL(String mainModuleID, BundleType type, String host) {
        return this.createBundleURL(mainModuleID, type, host, false, true);
    }

    private String createSplitBundleURL(String mainModuleID, String host) {
        return this.createBundleURL(mainModuleID, BundleType.BUNDLE, host, true, false);
    }

    private String createBundleURL(String mainModuleID, BundleType type, String host, boolean modulesOnly, boolean runModule) {
        boolean dev = this.getDevMode();
        return String.format(Locale.US, "http://%s/%s.%s?platform=android&dev=%s&lazy=%s&minify=%s&app=%s&modulesOnly=%s&runModule=%s", host, mainModuleID, type.typeID(), dev, dev, this.getJSMinifyMode(), this.mPackageName, modulesOnly ? "true" : "false", runModule ? "true" : "false");
    }

    private String createBundleURL(String mainModuleID, BundleType type) {
        return this.createBundleURL(mainModuleID, type, this.mPackagerConnectionSettings.getDebugServerHost());
    }

    private static String createResourceURL(String host, String resourcePath) {
        return String.format(Locale.US, "http://%s/%s", host, resourcePath);
    }

    public String getDevServerBundleURL(String jsModulePath) {
        return this.createBundleURL(jsModulePath, BundleType.BUNDLE, this.mPackagerConnectionSettings.getDebugServerHost());
    }

    public String getDevServerSplitBundleURL(String jsModulePath) {
        return this.createSplitBundleURL(jsModulePath, this.mPackagerConnectionSettings.getDebugServerHost());
    }

    public void isPackagerRunning(PackagerStatusCallback callback) {
        String host = this.mPackagerConnectionSettings.getDebugServerHost();
        if (host == null) {
            FLog.w((String)"ReactNative", (String)"No packager host configured.");
            callback.onPackagerStatusFetched(false);
        } else {
            this.mPackagerStatusCheck.run(host, callback);
        }
    }

    private String createLaunchJSDevtoolsCommandUrl() {
        return String.format(Locale.US, "http://%s/launch-js-devtools", this.mPackagerConnectionSettings.getDebugServerHost());
    }

    public void launchJSDevtools() {
        Request request = new Request.Builder().url(this.createLaunchJSDevtoolsCommandUrl()).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
            }
        });
    }

    public String getSourceMapUrl(String mainModuleName) {
        return this.createBundleURL(mainModuleName, BundleType.MAP);
    }

    public String getSourceUrl(String mainModuleName) {
        return this.createBundleURL(mainModuleName, BundleType.BUNDLE);
    }

    public String getJSBundleURLForRemoteDebugging(String mainModuleName) {
        return this.createBundleURL(mainModuleName, BundleType.BUNDLE, this.getHostForJSProxy());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public File downloadBundleResourceFromUrlSync(String resourcePath, File outputFile) {
        String resourceURL = DevServerHelper.createResourceURL(this.mPackagerConnectionSettings.getDebugServerHost(), resourcePath);
        Request request = new Request.Builder().url(resourceURL).build();
        try (Response response = this.mClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                File file2 = null;
                return file2;
            }
            try (Sink output = Okio.sink((File)outputFile);){
                Okio.buffer((Source)response.body().source()).readAll(output);
            }
            File file = outputFile;
            return file;
        }
        catch (Exception ex) {
            FLog.e((String)"ReactNative", (String)"Failed to fetch resource synchronously - resourcePath: \"%s\", outputFile: \"%s\"", (Object[])new Object[]{resourcePath, outputFile.getAbsolutePath(), ex});
            return null;
        }
    }

    public void openDebugger(final ReactContext context, final String errorMessage) {
        String requestUrl = String.format(Locale.US, "http://%s/open-debugger?appId=%s&device=%s", this.mPackagerConnectionSettings.getDebugServerHost(), Uri.encode((String)this.mPackageName), Uri.encode((String)this.getInspectorDeviceId()));
        Request request = new Request.Builder().url(requestUrl).method("POST", RequestBody.create(null, (String)"")).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call _call, @NonNull IOException _e) {
                RNLog.w(context, errorMessage);
            }

            public void onResponse(@NonNull Call _call, @NonNull Response _response) {
            }
        });
    }

    public static interface PackagerCommandListener {
        public void onPackagerConnected();

        public void onPackagerDisconnected();

        public void onPackagerReloadCommand();

        public void onPackagerDevMenuCommand();

        public void onCaptureHeapCommand(Responder var1);

        @Nullable
        public Map<String, RequestHandler> customCommandHandlers();
    }

    private static enum BundleType {
        BUNDLE("bundle"),
        MAP("map");

        private final String mTypeID;

        private BundleType(String typeID) {
            this.mTypeID = typeID;
        }

        public String typeID() {
            return this.mTypeID;
        }
    }
}

