/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.permissions;

import android.app.Activity;
import android.content.Context;
import android.util.SparseArray;
import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativePermissionsAndroidSpec;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.PermissionAwareActivity;
import com.facebook.react.modules.core.PermissionListener;
import java.util.ArrayList;

@ReactModule(name="PermissionsAndroid")
public class PermissionsModule
extends NativePermissionsAndroidSpec
implements PermissionListener {
    private static final String ERROR_INVALID_ACTIVITY = "E_INVALID_ACTIVITY";
    private final SparseArray<Callback> mCallbacks = new SparseArray();
    private int mRequestCode = 0;
    private final String GRANTED = "granted";
    private final String DENIED = "denied";
    private final String NEVER_ASK_AGAIN = "never_ask_again";

    public PermissionsModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public void checkPermission(String permission, Promise promise) {
        Context context = this.getReactApplicationContext().getBaseContext();
        promise.resolve(context.checkSelfPermission(permission) == 0);
    }

    @Override
    public void shouldShowRequestPermissionRationale(String permission, Promise promise) {
        try {
            promise.resolve(this.getPermissionAwareActivity().shouldShowRequestPermissionRationale(permission));
        }
        catch (IllegalStateException e) {
            promise.reject(ERROR_INVALID_ACTIVITY, e);
        }
    }

    @Override
    public void requestPermission(final String permission, final Promise promise) {
        Context context = this.getReactApplicationContext().getBaseContext();
        if (context.checkSelfPermission(permission) == 0) {
            promise.resolve("granted");
            return;
        }
        try {
            PermissionAwareActivity activity = this.getPermissionAwareActivity();
            this.mCallbacks.put(this.mRequestCode, (Object)new Callback(){

                @Override
                public void invoke(Object ... args) {
                    int[] results = (int[])args[0];
                    if (results.length > 0 && results[0] == 0) {
                        promise.resolve("granted");
                    } else {
                        PermissionAwareActivity activity = (PermissionAwareActivity)args[1];
                        if (activity.shouldShowRequestPermissionRationale(permission)) {
                            promise.resolve("denied");
                        } else {
                            promise.resolve("never_ask_again");
                        }
                    }
                }
            });
            activity.requestPermissions(new String[]{permission}, this.mRequestCode, this);
            ++this.mRequestCode;
        }
        catch (IllegalStateException e) {
            promise.reject(ERROR_INVALID_ACTIVITY, e);
        }
    }

    @Override
    public void requestMultiplePermissions(ReadableArray permissions, final Promise promise) {
        final WritableNativeMap grantedPermissions = new WritableNativeMap();
        final ArrayList<String> permissionsToCheck = new ArrayList<String>();
        int checkedPermissionsCount = 0;
        Context context = this.getReactApplicationContext().getBaseContext();
        for (int i = 0; i < permissions.size(); ++i) {
            String perm = permissions.getString(i);
            if (context.checkSelfPermission(perm) == 0) {
                grantedPermissions.putString(perm, "granted");
                ++checkedPermissionsCount;
                continue;
            }
            permissionsToCheck.add(perm);
        }
        if (permissions.size() == checkedPermissionsCount) {
            promise.resolve(grantedPermissions);
            return;
        }
        try {
            PermissionAwareActivity activity = this.getPermissionAwareActivity();
            this.mCallbacks.put(this.mRequestCode, (Object)new Callback(){

                @Override
                public void invoke(Object ... args) {
                    int[] results = (int[])args[0];
                    PermissionAwareActivity activity = (PermissionAwareActivity)args[1];
                    for (int j = 0; j < permissionsToCheck.size(); ++j) {
                        String permission = (String)permissionsToCheck.get(j);
                        if (results.length > 0 && results[j] == 0) {
                            grantedPermissions.putString(permission, "granted");
                            continue;
                        }
                        if (activity.shouldShowRequestPermissionRationale(permission)) {
                            grantedPermissions.putString(permission, "denied");
                            continue;
                        }
                        grantedPermissions.putString(permission, "never_ask_again");
                    }
                    promise.resolve(grantedPermissions);
                }
            });
            activity.requestPermissions(permissionsToCheck.toArray(new String[0]), this.mRequestCode, this);
            ++this.mRequestCode;
        }
        catch (IllegalStateException e) {
            promise.reject(ERROR_INVALID_ACTIVITY, e);
        }
    }

    @Override
    public boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        try {
            Callback callback = (Callback)this.mCallbacks.get(requestCode);
            if (callback != null) {
                callback.invoke(grantResults, this.getPermissionAwareActivity());
                this.mCallbacks.remove(requestCode);
            } else {
                FLog.w((String)"PermissionsModule", (String)"Unable to find callback with requestCode %d", (Object[])new Object[]{requestCode});
            }
            return this.mCallbacks.size() == 0;
        }
        catch (IllegalStateException e) {
            FLog.e((String)"PermissionsModule", (Throwable)e, (String)"Unexpected invocation of `onRequestPermissionsResult` with invalid current activity", (Object[])new Object[0]);
            return false;
        }
    }

    private PermissionAwareActivity getPermissionAwareActivity() {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            throw new IllegalStateException("Tried to use permissions API while not attached to an Activity.");
        }
        if (!(activity instanceof PermissionAwareActivity)) {
            throw new IllegalStateException("Tried to use permissions API but the host Activity doesn't implement PermissionAwareActivity.");
        }
        return (PermissionAwareActivity)activity;
    }
}

