/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.internal;

import android.view.Choreographer;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.internal.ChoreographerProvider;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public final class AndroidChoreographerProvider
implements ChoreographerProvider {
    public static AndroidChoreographerProvider getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public ChoreographerProvider.Choreographer getChoreographer() {
        UiThreadUtil.assertOnUiThread();
        return new AndroidChoreographer();
    }

    private static class Holder {
        private static final AndroidChoreographerProvider INSTANCE = new AndroidChoreographerProvider();

        private Holder() {
        }
    }

    public static final class AndroidChoreographer
    implements ChoreographerProvider.Choreographer {
        private final Choreographer sInstance = Choreographer.getInstance();

        @Override
        public void postFrameCallback(Choreographer.FrameCallback callback) {
            this.sInstance.postFrameCallback(callback);
        }

        @Override
        public void removeFrameCallback(Choreographer.FrameCallback callback) {
            this.sInstance.removeFrameCallback(callback);
        }
    }
}

