/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.accessibilityinfo;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.Nullable;
import com.facebook.fbreact.specs.NativeAccessibilityInfoSpec;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="AccessibilityInfo")
public class AccessibilityInfoModule
extends NativeAccessibilityInfoSpec
implements LifecycleEventListener {
    private final ContentObserver animationScaleObserver = new ContentObserver(UiThreadUtil.getUiThreadHandler()){

        public void onChange(boolean selfChange) {
            this.onChange(selfChange, null);
        }

        public void onChange(boolean selfChange, Uri uri) {
            if (AccessibilityInfoModule.this.getReactApplicationContext().hasActiveReactInstance()) {
                AccessibilityInfoModule.this.updateAndSendReduceMotionChangeEvent();
            }
        }
    };
    @Nullable
    private AccessibilityManager mAccessibilityManager;
    @Nullable
    private ReactTouchExplorationStateChangeListener mTouchExplorationStateChangeListener;
    @Nullable
    private ReactAccessibilityServiceChangeListener mAccessibilityServiceChangeListener;
    private final ContentResolver mContentResolver;
    private boolean mReduceMotionEnabled = false;
    private boolean mTouchExplorationEnabled = false;
    private boolean mAccessibilityServiceEnabled = false;
    private int mRecommendedTimeout;
    private static final String REDUCE_MOTION_EVENT_NAME = "reduceMotionDidChange";
    private static final String TOUCH_EXPLORATION_EVENT_NAME = "touchExplorationDidChange";
    private static final String ACCESSIBILITY_SERVICE_EVENT_NAME = "accessibilityServiceDidChange";

    public AccessibilityInfoModule(ReactApplicationContext context) {
        super(context);
        Context appContext = context.getApplicationContext();
        this.mAccessibilityManager = (AccessibilityManager)appContext.getSystemService("accessibility");
        this.mContentResolver = this.getReactApplicationContext().getContentResolver();
        this.mTouchExplorationEnabled = this.mAccessibilityManager.isTouchExplorationEnabled();
        this.mAccessibilityServiceEnabled = this.mAccessibilityManager.isEnabled();
        this.mReduceMotionEnabled = this.getIsReduceMotionEnabledValue();
        this.mTouchExplorationStateChangeListener = new ReactTouchExplorationStateChangeListener();
        this.mAccessibilityServiceChangeListener = new ReactAccessibilityServiceChangeListener();
    }

    @TargetApi(value=21)
    private boolean getIsReduceMotionEnabledValue() {
        String rawValue = Settings.Global.getString((ContentResolver)this.mContentResolver, (String)"transition_animation_scale");
        Float parsedValue = Float.valueOf(rawValue != null ? Float.parseFloat(rawValue) : 1.0f);
        return parsedValue.floatValue() == 0.0f;
    }

    @Override
    public void isReduceMotionEnabled(Callback successCallback) {
        successCallback.invoke(this.mReduceMotionEnabled);
    }

    @Override
    public void isTouchExplorationEnabled(Callback successCallback) {
        successCallback.invoke(this.mTouchExplorationEnabled);
    }

    @Override
    public void isAccessibilityServiceEnabled(Callback successCallback) {
        successCallback.invoke(this.mAccessibilityServiceEnabled);
    }

    private void updateAndSendReduceMotionChangeEvent() {
        boolean isReduceMotionEnabled = this.getIsReduceMotionEnabledValue();
        if (this.mReduceMotionEnabled != isReduceMotionEnabled) {
            this.mReduceMotionEnabled = isReduceMotionEnabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                reactApplicationContext.emitDeviceEvent(REDUCE_MOTION_EVENT_NAME, this.mReduceMotionEnabled);
            }
        }
    }

    private void updateAndSendTouchExplorationChangeEvent(boolean enabled) {
        if (this.mTouchExplorationEnabled != enabled) {
            this.mTouchExplorationEnabled = enabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                this.getReactApplicationContext().emitDeviceEvent(TOUCH_EXPLORATION_EVENT_NAME, this.mTouchExplorationEnabled);
            }
        }
    }

    private void updateAndSendAccessibilityServiceChangeEvent(boolean enabled) {
        if (this.mAccessibilityServiceEnabled != enabled) {
            this.mAccessibilityServiceEnabled = enabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                this.getReactApplicationContext().emitDeviceEvent(ACCESSIBILITY_SERVICE_EVENT_NAME, this.mAccessibilityServiceEnabled);
            }
        }
    }

    @Override
    @TargetApi(value=21)
    public void onHostResume() {
        this.mAccessibilityManager.addTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.mTouchExplorationStateChangeListener);
        this.mAccessibilityManager.addAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this.mAccessibilityServiceChangeListener);
        Uri transitionUri = Settings.Global.getUriFor((String)"transition_animation_scale");
        this.mContentResolver.registerContentObserver(transitionUri, false, this.animationScaleObserver);
        this.updateAndSendTouchExplorationChangeEvent(this.mAccessibilityManager.isTouchExplorationEnabled());
        this.updateAndSendAccessibilityServiceChangeEvent(this.mAccessibilityManager.isEnabled());
        this.updateAndSendReduceMotionChangeEvent();
    }

    @Override
    @TargetApi(value=21)
    public void onHostPause() {
        this.mAccessibilityManager.removeTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.mTouchExplorationStateChangeListener);
        this.mAccessibilityManager.removeAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this.mAccessibilityServiceChangeListener);
        this.mContentResolver.unregisterContentObserver(this.animationScaleObserver);
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
        this.updateAndSendTouchExplorationChangeEvent(this.mAccessibilityManager.isTouchExplorationEnabled());
        this.updateAndSendAccessibilityServiceChangeEvent(this.mAccessibilityManager.isEnabled());
        this.updateAndSendReduceMotionChangeEvent();
    }

    @Override
    public void invalidate() {
        this.getReactApplicationContext().removeLifecycleEventListener(this);
        super.invalidate();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void announceForAccessibility(String message) {
        if (this.mAccessibilityManager == null || !this.mAccessibilityManager.isEnabled()) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain((int)16384);
        event.getText().add(message);
        event.setClassName((CharSequence)AccessibilityInfoModule.class.getName());
        event.setPackageName((CharSequence)this.getReactApplicationContext().getPackageName());
        this.mAccessibilityManager.sendAccessibilityEvent(event);
    }

    @Override
    public void setAccessibilityFocus(double reactTag) {
    }

    @Override
    public void getRecommendedTimeoutMillis(double originalTimeout, Callback successCallback) {
        if (Build.VERSION.SDK_INT < 29) {
            successCallback.invoke((int)originalTimeout);
            return;
        }
        this.mRecommendedTimeout = this.mAccessibilityManager.getRecommendedTimeoutMillis((int)originalTimeout, 4);
        successCallback.invoke(this.mRecommendedTimeout);
    }

    @TargetApi(value=21)
    private class ReactTouchExplorationStateChangeListener
    implements AccessibilityManager.TouchExplorationStateChangeListener {
        private ReactTouchExplorationStateChangeListener() {
        }

        public void onTouchExplorationStateChanged(boolean enabled) {
            AccessibilityInfoModule.this.updateAndSendTouchExplorationChangeEvent(enabled);
        }
    }

    @TargetApi(value=21)
    private class ReactAccessibilityServiceChangeListener
    implements AccessibilityManager.AccessibilityStateChangeListener {
        private ReactAccessibilityServiceChangeListener() {
        }

        public void onAccessibilityStateChanged(boolean enabled) {
            AccessibilityInfoModule.this.updateAndSendAccessibilityServiceChangeEvent(enabled);
        }
    }
}

