/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.debug;

import android.view.Choreographer;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.modules.debug.DidJSUpdateUiDuringFrameDetector;
import com.facebook.react.uimanager.UIManagerModule;
import java.util.Map;
import java.util.TreeMap;

public class FpsDebugFrameCallback
implements Choreographer.FrameCallback {
    private static final double DEFAULT_FPS = 60.0;
    @Nullable
    private Choreographer mChoreographer;
    private final ReactContext mReactContext;
    private final UIManagerModule mUIManagerModule;
    private final DidJSUpdateUiDuringFrameDetector mDidJSUpdateUiDuringFrameDetector;
    private long mFirstFrameTime = -1L;
    private long mLastFrameTime = -1L;
    private int mNumFrameCallbacks = 0;
    private int mExpectedNumFramesPrev = 0;
    private int m4PlusFrameStutters = 0;
    private int mNumFrameCallbacksWithBatchDispatches = 0;
    private boolean mIsRecordingFpsInfoAtEachFrame = false;
    private double mTargetFps = 60.0;
    @Nullable
    private TreeMap<Long, FpsInfo> mTimeToFps;

    public FpsDebugFrameCallback(ReactContext reactContext) {
        this.mReactContext = reactContext;
        this.mUIManagerModule = reactContext.getNativeModule(UIManagerModule.class);
        this.mDidJSUpdateUiDuringFrameDetector = new DidJSUpdateUiDuringFrameDetector();
    }

    public void doFrame(long l) {
        if (this.mFirstFrameTime == -1L) {
            this.mFirstFrameTime = l;
        }
        long lastFrameStartTime = this.mLastFrameTime;
        this.mLastFrameTime = l;
        if (this.mDidJSUpdateUiDuringFrameDetector.getDidJSHitFrameAndCleanup(lastFrameStartTime, l)) {
            ++this.mNumFrameCallbacksWithBatchDispatches;
        }
        ++this.mNumFrameCallbacks;
        int expectedNumFrames = this.getExpectedNumFrames();
        int framesDropped = expectedNumFrames - this.mExpectedNumFramesPrev - 1;
        if (framesDropped >= 4) {
            ++this.m4PlusFrameStutters;
        }
        if (this.mIsRecordingFpsInfoAtEachFrame) {
            Assertions.assertNotNull(this.mTimeToFps);
            FpsInfo info = new FpsInfo(this.getNumFrames(), this.getNumJSFrames(), expectedNumFrames, this.m4PlusFrameStutters, this.getFPS(), this.getJSFPS(), this.getTotalTimeMS());
            this.mTimeToFps.put(System.currentTimeMillis(), info);
        }
        this.mExpectedNumFramesPrev = expectedNumFrames;
        if (this.mChoreographer != null) {
            this.mChoreographer.postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    public void start() {
        this.start(this.mTargetFps);
    }

    public void start(double targetFps) {
        if (!this.mReactContext.isBridgeless()) {
            this.mReactContext.getCatalystInstance().addBridgeIdleDebugListener(this.mDidJSUpdateUiDuringFrameDetector);
        }
        if (this.mUIManagerModule != null) {
            this.mUIManagerModule.setViewHierarchyUpdateDebugListener(this.mDidJSUpdateUiDuringFrameDetector);
        }
        this.mTargetFps = targetFps;
        UiThreadUtil.runOnUiThread(() -> {
            this.mChoreographer = Choreographer.getInstance();
            this.mChoreographer.postFrameCallback((Choreographer.FrameCallback)this);
        });
    }

    public void startAndRecordFpsAtEachFrame() {
        this.mTimeToFps = new TreeMap();
        this.mIsRecordingFpsInfoAtEachFrame = true;
        this.start();
    }

    public void stop() {
        if (!this.mReactContext.isBridgeless()) {
            this.mReactContext.getCatalystInstance().removeBridgeIdleDebugListener(this.mDidJSUpdateUiDuringFrameDetector);
        }
        if (this.mUIManagerModule != null) {
            this.mUIManagerModule.setViewHierarchyUpdateDebugListener(null);
        }
        UiThreadUtil.runOnUiThread(() -> {
            this.mChoreographer = Choreographer.getInstance();
            this.mChoreographer.removeFrameCallback((Choreographer.FrameCallback)this);
        });
    }

    public double getFPS() {
        if (this.mLastFrameTime == this.mFirstFrameTime) {
            return 0.0;
        }
        return (double)this.getNumFrames() * 1.0E9 / (double)(this.mLastFrameTime - this.mFirstFrameTime);
    }

    public double getJSFPS() {
        if (this.mLastFrameTime == this.mFirstFrameTime) {
            return 0.0;
        }
        return (double)this.getNumJSFrames() * 1.0E9 / (double)(this.mLastFrameTime - this.mFirstFrameTime);
    }

    public int getNumFrames() {
        return this.mNumFrameCallbacks - 1;
    }

    public int getNumJSFrames() {
        return this.mNumFrameCallbacksWithBatchDispatches - 1;
    }

    public int getExpectedNumFrames() {
        double totalTimeMS = this.getTotalTimeMS();
        int expectedFrames = (int)(this.mTargetFps * totalTimeMS / 1000.0 + 1.0);
        return expectedFrames;
    }

    public int get4PlusFrameStutters() {
        return this.m4PlusFrameStutters;
    }

    public int getTotalTimeMS() {
        return (int)((double)this.mLastFrameTime - (double)this.mFirstFrameTime) / 1000000;
    }

    @Nullable
    public FpsInfo getFpsInfo(long upToTimeMs) {
        Assertions.assertNotNull(this.mTimeToFps, (String)"FPS was not recorded at each frame!");
        Map.Entry<Long, FpsInfo> bestEntry = this.mTimeToFps.floorEntry(upToTimeMs);
        if (bestEntry == null) {
            return null;
        }
        return bestEntry.getValue();
    }

    public void reset() {
        this.mFirstFrameTime = -1L;
        this.mLastFrameTime = -1L;
        this.mNumFrameCallbacks = 0;
        this.m4PlusFrameStutters = 0;
        this.mNumFrameCallbacksWithBatchDispatches = 0;
        this.mIsRecordingFpsInfoAtEachFrame = false;
        this.mTimeToFps = null;
    }

    public static class FpsInfo {
        public final int totalFrames;
        public final int totalJsFrames;
        public final int totalExpectedFrames;
        public final int total4PlusFrameStutters;
        public final double fps;
        public final double jsFps;
        public final int totalTimeMs;

        public FpsInfo(int totalFrames, int totalJsFrames, int totalExpectedFrames, int total4PlusFrameStutters, double fps, double jsFps, int totalTimeMs) {
            this.totalFrames = totalFrames;
            this.totalJsFrames = totalJsFrames;
            this.totalExpectedFrames = totalExpectedFrames;
            this.total4PlusFrameStutters = total4PlusFrameStutters;
            this.fps = fps;
            this.jsFps = jsFps;
            this.totalTimeMs = totalTimeMs;
        }
    }
}

