/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class BridgelessReactStateTracker {
    private static final String TAG = "BridgelessReact";
    private final List<String> mStates = Collections.synchronizedList(new ArrayList());
    private final boolean mShouldTrackStates;

    BridgelessReactStateTracker(boolean shouldTrackStates) {
        this.mShouldTrackStates = shouldTrackStates;
    }

    void enterState(String state) {
        FLog.w((String)TAG, (String)state);
        if (this.mShouldTrackStates) {
            this.mStates.add(state);
        }
    }
}

