/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.PopupMenu;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.uimanager.IViewManagerWithChildren;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NoSuchNativeViewException;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.RootViewManager;
import com.facebook.react.uimanager.RootViewUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.TouchTargetHelper;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.layoutanimation.LayoutAnimationController;
import com.facebook.react.uimanager.layoutanimation.LayoutAnimationListener;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NativeViewHierarchyManager {
    private static final String TAG = NativeViewHierarchyManager.class.getSimpleName();
    private final boolean DEBUG_MODE;
    private final SparseArray<View> mTagsToViews;
    private final SparseArray<ViewManager> mTagsToViewManagers;
    private final SparseBooleanArray mRootTags;
    private final ViewManagerRegistry mViewManagers;
    private final JSResponderHandler mJSResponderHandler;
    private final RootViewManager mRootViewManager;
    private final LayoutAnimationController mLayoutAnimator;
    private final RectF mBoundingBox;
    private boolean mLayoutAnimationEnabled;
    private PopupMenu mPopupMenu;
    private HashMap<Integer, Set<Integer>> mPendingDeletionsForTag;

    public NativeViewHierarchyManager(ViewManagerRegistry viewManagers) {
        this(viewManagers, new RootViewManager());
    }

    public NativeViewHierarchyManager(ViewManagerRegistry viewManagers, RootViewManager manager) {
        if (ReactBuildConfig.DEBUG) {
            // empty if block
        }
        this.DEBUG_MODE = false;
        this.mJSResponderHandler = new JSResponderHandler();
        this.mLayoutAnimator = new LayoutAnimationController();
        this.mBoundingBox = new RectF();
        this.mViewManagers = viewManagers;
        this.mTagsToViews = new SparseArray();
        this.mTagsToViewManagers = new SparseArray();
        this.mRootTags = new SparseBooleanArray();
        this.mRootViewManager = manager;
    }

    public final synchronized View resolveView(int tag) {
        View view = (View)this.mTagsToViews.get(tag);
        if (view == null) {
            throw new IllegalViewOperationException("Trying to resolve view with tag " + tag + " which doesn't exist");
        }
        return view;
    }

    public final synchronized ViewManager resolveViewManager(int tag) {
        ViewManager viewManager = (ViewManager)this.mTagsToViewManagers.get(tag);
        if (viewManager == null) {
            throw new IllegalViewOperationException("ViewManager for tag " + tag + " could not be found.\n");
        }
        return viewManager;
    }

    public void setLayoutAnimationEnabled(boolean enabled) {
        this.mLayoutAnimationEnabled = enabled;
    }

    public synchronized void updateInstanceHandle(int tag, long instanceHandle) {
        UiThreadUtil.assertOnUiThread();
        try {
            this.updateInstanceHandle(this.resolveView(tag), instanceHandle);
        }
        catch (IllegalViewOperationException e) {
            FLog.e((String)TAG, (String)("Unable to update properties for view tag " + tag), (Throwable)e);
        }
    }

    public synchronized void updateProperties(int tag, ReactStylesDiffMap props) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"updateProperties[%d]: %s", (Object)tag, (Object)props.toString());
        }
        UiThreadUtil.assertOnUiThread();
        try {
            ViewManager viewManager = this.resolveViewManager(tag);
            View viewToUpdate = this.resolveView(tag);
            if (props != null) {
                viewManager.updateProperties(viewToUpdate, props);
            }
        }
        catch (IllegalViewOperationException e) {
            FLog.e((String)TAG, (String)("Unable to update properties for view tag " + tag), (Throwable)e);
        }
    }

    public synchronized void updateViewExtraData(int tag, Object extraData) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"updateViewExtraData[%d]: %s", (Object)tag, (Object)extraData.toString());
        }
        UiThreadUtil.assertOnUiThread();
        ViewManager viewManager = this.resolveViewManager(tag);
        View viewToUpdate = this.resolveView(tag);
        viewManager.updateExtraData(viewToUpdate, extraData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateLayout(int parentTag, int tag, int x, int y, int width, int height) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"updateLayout[%d]->[%d]: %d %d %d %d", (Object[])new Object[]{tag, parentTag, x, y, width, height});
        }
        UiThreadUtil.assertOnUiThread();
        SystraceMessage.beginSection(0L, "NativeViewHierarchyManager_updateLayout").arg("parentTag", parentTag).arg("tag", tag).flush();
        try {
            View viewToUpdate = this.resolveView(tag);
            viewToUpdate.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
            ViewParent parent = viewToUpdate.getParent();
            if (parent instanceof RootView) {
                parent.requestLayout();
            }
            if (!this.mRootTags.get(parentTag)) {
                ViewManager parentViewManager = (ViewManager)this.mTagsToViewManagers.get(parentTag);
                if (!(parentViewManager instanceof IViewManagerWithChildren)) {
                    throw new IllegalViewOperationException("Trying to use view with tag " + parentTag + " as a parent, but its Manager doesn't implement IViewManagerWithChildren");
                }
                IViewManagerWithChildren parentViewManagerWithChildren = (IViewManagerWithChildren)((Object)parentViewManager);
                if (parentViewManagerWithChildren != null && !parentViewManagerWithChildren.needsCustomLayoutForChildren()) {
                    this.updateLayout(viewToUpdate, x, y, width, height);
                }
            } else {
                this.updateLayout(viewToUpdate, x, y, width, height);
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    private void updateInstanceHandle(View viewToUpdate, long instanceHandle) {
        UiThreadUtil.assertOnUiThread();
        viewToUpdate.setTag(R.id.view_tag_instance_handle, (Object)instanceHandle);
    }

    @Nullable
    public long getInstanceHandle(int reactTag) {
        View view = (View)this.mTagsToViews.get(reactTag);
        if (view == null) {
            throw new IllegalViewOperationException("Unable to find view for tag: " + reactTag);
        }
        Long instanceHandle = (Long)view.getTag(R.id.view_tag_instance_handle);
        if (instanceHandle == null) {
            throw new IllegalViewOperationException("Unable to find instanceHandle for tag: " + reactTag);
        }
        return instanceHandle;
    }

    private void updateLayout(View viewToUpdate, int x, int y, int width, int height) {
        if (this.mLayoutAnimationEnabled && this.mLayoutAnimator.shouldAnimateLayout(viewToUpdate)) {
            this.mLayoutAnimator.applyLayoutUpdate(viewToUpdate, x, y, width, height);
        } else {
            viewToUpdate.layout(x, y, x + width, y + height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createView(ThemedReactContext themedContext, int tag, String className, @Nullable ReactStylesDiffMap initialProps) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"createView[%d]: %s %s", (Object)tag, (Object)className, (Object)(initialProps != null ? initialProps.toString() : "<null>"));
        }
        UiThreadUtil.assertOnUiThread();
        SystraceMessage.beginSection(0L, "NativeViewHierarchyManager_createView").arg("tag", tag).arg("className", className).flush();
        try {
            ViewManager viewManager = this.mViewManagers.get(className);
            Object view = viewManager.createView(tag, themedContext, initialProps, null, this.mJSResponderHandler);
            this.mTagsToViews.put(tag, view);
            this.mTagsToViewManagers.put(tag, (Object)viewManager);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    private static String constructManageChildrenErrorMessage(ViewGroup viewToManage, ViewGroupManager viewManager, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, @Nullable int[] tagsToDelete) {
        int innerOffset;
        int index;
        StringBuilder stringBuilder = new StringBuilder();
        if (null != viewToManage) {
            stringBuilder.append("View tag:" + viewToManage.getId() + " View Type:" + viewToManage.getClass().toString() + "\n");
            stringBuilder.append("  children(" + viewManager.getChildCount(viewToManage) + "): [\n");
            index = 0;
            while (viewManager.getChildAt(viewToManage, index) != null) {
                for (innerOffset = 0; viewManager.getChildAt(viewToManage, index + innerOffset) != null && innerOffset < 16; ++innerOffset) {
                    stringBuilder.append(viewManager.getChildAt(viewToManage, index + innerOffset).getId() + ",");
                }
                stringBuilder.append("\n");
                index += 16;
            }
            stringBuilder.append(" ],\n");
        }
        if (indicesToRemove != null) {
            stringBuilder.append("  indicesToRemove(" + indicesToRemove.length + "): [\n");
            for (index = 0; index < indicesToRemove.length; index += 16) {
                for (innerOffset = 0; index + innerOffset < indicesToRemove.length && innerOffset < 16; ++innerOffset) {
                    stringBuilder.append(indicesToRemove[index + innerOffset] + ",");
                }
                stringBuilder.append("\n");
            }
            stringBuilder.append(" ],\n");
        }
        if (viewsToAdd != null) {
            stringBuilder.append("  viewsToAdd(" + viewsToAdd.length + "): [\n");
            for (index = 0; index < viewsToAdd.length; index += 16) {
                for (innerOffset = 0; index + innerOffset < viewsToAdd.length && innerOffset < 16; ++innerOffset) {
                    stringBuilder.append("[" + viewsToAdd[index + innerOffset].mIndex + "," + viewsToAdd[index + innerOffset].mTag + "],");
                }
                stringBuilder.append("\n");
            }
            stringBuilder.append(" ],\n");
        }
        if (tagsToDelete != null) {
            stringBuilder.append("  tagsToDelete(" + tagsToDelete.length + "): [\n");
            for (index = 0; index < tagsToDelete.length; index += 16) {
                for (innerOffset = 0; index + innerOffset < tagsToDelete.length && innerOffset < 16; ++innerOffset) {
                    stringBuilder.append(tagsToDelete[index + innerOffset] + ",");
                }
                stringBuilder.append("\n");
            }
            stringBuilder.append(" ]\n");
        }
        return stringBuilder.toString();
    }

    private Set<Integer> getPendingDeletionsForTag(int tag) {
        if (this.mPendingDeletionsForTag == null) {
            this.mPendingDeletionsForTag = new HashMap();
        }
        if (!this.mPendingDeletionsForTag.containsKey(tag)) {
            this.mPendingDeletionsForTag.put(tag, new HashSet());
        }
        return this.mPendingDeletionsForTag.get(tag);
    }

    public synchronized void manageChildren(final int tag, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, @Nullable int[] tagsToDelete) {
        int i;
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"createView[%d]: %s %s %s", (Object)tag, (Object)(indicesToRemove != null ? indicesToRemove.toString() : "<null>"), (Object)(viewsToAdd != null ? viewsToAdd.toString() : "<null>"), (Object)(tagsToDelete != null ? tagsToDelete.toString() : "<null>"));
        }
        UiThreadUtil.assertOnUiThread();
        final Set<Integer> pendingDeletionTags = this.getPendingDeletionsForTag(tag);
        final ViewGroup viewToManage = (ViewGroup)this.mTagsToViews.get(tag);
        final ViewGroupManager viewManager = (ViewGroupManager)this.resolveViewManager(tag);
        if (viewToManage == null) {
            throw new IllegalViewOperationException("Trying to manageChildren view with tag " + tag + " which doesn't exist\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
        }
        int lastIndexToRemove = viewManager.getChildCount(viewToManage);
        if (indicesToRemove != null) {
            for (i = indicesToRemove.length - 1; i >= 0; --i) {
                int indexToRemove = indicesToRemove[i];
                if (indexToRemove < 0) {
                    throw new IllegalViewOperationException("Trying to remove a negative view index:" + indexToRemove + " view tag: " + tag + "\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
                }
                if (viewManager.getChildAt(viewToManage, indexToRemove) == null) {
                    if (this.mRootTags.get(tag) && viewManager.getChildCount(viewToManage) == 0) {
                        return;
                    }
                    throw new IllegalViewOperationException("Trying to remove a view index above child count " + indexToRemove + " view tag: " + tag + "\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
                }
                if (indexToRemove >= lastIndexToRemove) {
                    throw new IllegalViewOperationException("Trying to remove an out of order view index:" + indexToRemove + " view tag: " + tag + "\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
                }
                View viewToRemove = viewManager.getChildAt(viewToManage, indexToRemove);
                if (!(this.mLayoutAnimationEnabled && this.mLayoutAnimator.shouldAnimateLayout(viewToRemove) && this.arrayContains(tagsToDelete, viewToRemove.getId()))) {
                    viewManager.removeViewAt(viewToManage, indexToRemove);
                }
                lastIndexToRemove = indexToRemove;
            }
        }
        if (tagsToDelete != null) {
            for (i = 0; i < tagsToDelete.length; ++i) {
                int tagToDelete = tagsToDelete[i];
                final View viewToDestroy = (View)this.mTagsToViews.get(tagToDelete);
                if (viewToDestroy == null) {
                    throw new IllegalViewOperationException("Trying to destroy unknown view tag: " + tagToDelete + "\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
                }
                if (this.mLayoutAnimationEnabled && this.mLayoutAnimator.shouldAnimateLayout(viewToDestroy)) {
                    pendingDeletionTags.add(tagToDelete);
                    this.mLayoutAnimator.deleteView(viewToDestroy, new LayoutAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            UiThreadUtil.assertOnUiThread();
                            viewManager.removeView(viewToManage, viewToDestroy);
                            NativeViewHierarchyManager.this.dropView(viewToDestroy);
                            pendingDeletionTags.remove(viewToDestroy.getId());
                            if (pendingDeletionTags.isEmpty()) {
                                NativeViewHierarchyManager.this.mPendingDeletionsForTag.remove(tag);
                            }
                        }
                    });
                    continue;
                }
                this.dropView(viewToDestroy);
            }
        }
        if (viewsToAdd != null) {
            for (i = 0; i < viewsToAdd.length; ++i) {
                ViewAtIndex viewAtIndex = viewsToAdd[i];
                View viewToAdd = (View)this.mTagsToViews.get(viewAtIndex.mTag);
                if (viewToAdd == null) {
                    throw new IllegalViewOperationException("Trying to add unknown view tag: " + viewAtIndex.mTag + "\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
                }
                int normalizedIndex = viewAtIndex.mIndex;
                if (!pendingDeletionTags.isEmpty()) {
                    int counter = 0;
                    for (normalizedIndex = 0; normalizedIndex < viewToManage.getChildCount() && counter != viewAtIndex.mIndex; ++normalizedIndex) {
                        View v = viewToManage.getChildAt(normalizedIndex);
                        if (pendingDeletionTags.contains(v.getId())) continue;
                        ++counter;
                    }
                }
                viewManager.addView(viewToManage, viewToAdd, normalizedIndex);
            }
        }
        if (pendingDeletionTags.isEmpty()) {
            this.mPendingDeletionsForTag.remove(tag);
        }
    }

    private boolean arrayContains(@Nullable int[] array, int ele) {
        if (array == null) {
            return false;
        }
        for (int curEle : array) {
            if (curEle != ele) continue;
            return true;
        }
        return false;
    }

    private static String constructSetChildrenErrorMessage(ViewGroup viewToManage, ViewGroupManager viewManager, ReadableArray childrenTags) {
        ViewAtIndex[] viewsToAdd = new ViewAtIndex[childrenTags.size()];
        for (int i = 0; i < childrenTags.size(); ++i) {
            viewsToAdd[i] = new ViewAtIndex(childrenTags.getInt(i), i);
        }
        return NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, null, viewsToAdd, null);
    }

    public synchronized void setChildren(int tag, ReadableArray childrenTags) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"setChildren[%d]: %s", (Object)tag, (Object)(childrenTags != null ? childrenTags.toString() : "<null>"));
        }
        UiThreadUtil.assertOnUiThread();
        ViewGroup viewToManage = (ViewGroup)this.mTagsToViews.get(tag);
        ViewGroupManager viewManager = (ViewGroupManager)this.resolveViewManager(tag);
        for (int i = 0; i < childrenTags.size(); ++i) {
            View viewToAdd = (View)this.mTagsToViews.get(childrenTags.getInt(i));
            if (viewToAdd == null) {
                throw new IllegalViewOperationException("Trying to add unknown view tag: " + childrenTags.getInt(i) + "\n detail: " + NativeViewHierarchyManager.constructSetChildrenErrorMessage(viewToManage, viewManager, childrenTags));
            }
            viewManager.addView(viewToManage, viewToAdd, i);
        }
    }

    public synchronized void addRootView(int tag, View view) {
        this.addRootViewGroup(tag, view);
    }

    protected final synchronized void addRootViewGroup(int tag, View view) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"addRootViewGroup[%d]: %s", (Object)tag, (Object)(view != null ? view.toString() : "<null>"));
        }
        if (view.getId() != -1) {
            FLog.e((String)TAG, (String)("Trying to add a root view with an explicit id (" + view.getId() + ") already set. React Native uses the id field to track react tags and will overwrite this field. If that is fine, explicitly overwrite the id field to View.NO_ID before calling addRootView."));
        }
        this.mTagsToViews.put(tag, (Object)view);
        this.mTagsToViewManagers.put(tag, (Object)this.mRootViewManager);
        this.mRootTags.put(tag, true);
        view.setId(tag);
    }

    protected synchronized void dropView(View view) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"dropView[%d]", (Object)(view != null ? view.getId() : -1));
        }
        UiThreadUtil.assertOnUiThread();
        if (view == null) {
            return;
        }
        if (this.mTagsToViewManagers.get(view.getId()) == null) {
            return;
        }
        if (!this.mRootTags.get(view.getId())) {
            this.resolveViewManager(view.getId()).onDropViewInstance(view);
        }
        ViewManager viewManager = (ViewManager)this.mTagsToViewManagers.get(view.getId());
        if (view instanceof ViewGroup && viewManager instanceof ViewGroupManager) {
            ViewGroup viewGroup = (ViewGroup)view;
            ViewGroupManager viewGroupManager = (ViewGroupManager)viewManager;
            for (int i = viewGroupManager.getChildCount(viewGroup) - 1; i >= 0; --i) {
                View child = viewGroupManager.getChildAt(viewGroup, i);
                if (child == null) {
                    FLog.e((String)TAG, (String)"Unable to drop null child view");
                    continue;
                }
                if (this.mTagsToViews.get(child.getId()) == null) continue;
                this.dropView(child);
            }
            viewGroupManager.removeAllViews((View)viewGroup);
        }
        this.mTagsToViews.remove(view.getId());
        this.mTagsToViewManagers.remove(view.getId());
    }

    public synchronized void removeRootView(int rootViewTag) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"removeRootView[%d]", (Object)rootViewTag);
        }
        UiThreadUtil.assertOnUiThread();
        if (!this.mRootTags.get(rootViewTag)) {
            SoftAssertions.assertUnreachable("View with tag " + rootViewTag + " is not registered as a root view");
        }
        View rootView = (View)this.mTagsToViews.get(rootViewTag);
        this.dropView(rootView);
        this.mRootTags.delete(rootViewTag);
    }

    public synchronized int getRootViewNum() {
        return this.mRootTags.size();
    }

    public synchronized void measure(int tag, int[] outputBuffer) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"measure[%d]", (Object)tag);
        }
        UiThreadUtil.assertOnUiThread();
        View v = (View)this.mTagsToViews.get(tag);
        if (v == null) {
            throw new NoSuchNativeViewException("No native view for " + tag + " currently exists");
        }
        View rootView = (View)RootViewUtil.getRootView(v);
        if (rootView == null) {
            throw new NoSuchNativeViewException("Native view " + tag + " is no longer on screen");
        }
        this.computeBoundingBox(rootView, outputBuffer);
        int rootX = outputBuffer[0];
        int rootY = outputBuffer[1];
        this.computeBoundingBox(v, outputBuffer);
        outputBuffer[0] = outputBuffer[0] - rootX;
        outputBuffer[1] = outputBuffer[1] - rootY;
    }

    private void computeBoundingBox(View view, int[] outputBuffer) {
        this.mBoundingBox.set(0.0f, 0.0f, (float)view.getWidth(), (float)view.getHeight());
        this.mapRectFromViewToWindowCoords(view, this.mBoundingBox);
        outputBuffer[0] = Math.round(this.mBoundingBox.left);
        outputBuffer[1] = Math.round(this.mBoundingBox.top);
        outputBuffer[2] = Math.round(this.mBoundingBox.right - this.mBoundingBox.left);
        outputBuffer[3] = Math.round(this.mBoundingBox.bottom - this.mBoundingBox.top);
    }

    private void mapRectFromViewToWindowCoords(View view, RectF rect) {
        Matrix matrix = view.getMatrix();
        if (!matrix.isIdentity()) {
            matrix.mapRect(rect);
        }
        rect.offset((float)view.getLeft(), (float)view.getTop());
        ViewParent parent = view.getParent();
        while (parent instanceof View) {
            View parentView = (View)parent;
            rect.offset((float)(-parentView.getScrollX()), (float)(-parentView.getScrollY()));
            matrix = parentView.getMatrix();
            if (!matrix.isIdentity()) {
                matrix.mapRect(rect);
            }
            rect.offset((float)parentView.getLeft(), (float)parentView.getTop());
            parent = parentView.getParent();
        }
    }

    public synchronized void measureInWindow(int tag, int[] outputBuffer) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"measureInWindow[%d]", (Object)tag);
        }
        UiThreadUtil.assertOnUiThread();
        View v = (View)this.mTagsToViews.get(tag);
        if (v == null) {
            throw new NoSuchNativeViewException("No native view for " + tag + " currently exists");
        }
        v.getLocationOnScreen(outputBuffer);
        Rect visibleWindowFrame = new Rect();
        v.getWindowVisibleDisplayFrame(visibleWindowFrame);
        outputBuffer[0] = outputBuffer[0] - visibleWindowFrame.left;
        outputBuffer[1] = outputBuffer[1] - visibleWindowFrame.top;
        outputBuffer[2] = v.getWidth();
        outputBuffer[3] = v.getHeight();
    }

    public synchronized int findTargetTagForTouch(int reactTag, float touchX, float touchY) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"findTargetTagForTouch[%d]: %f %f", (Object)reactTag, (Object)Float.valueOf(touchX), (Object)Float.valueOf(touchY));
        }
        UiThreadUtil.assertOnUiThread();
        View view = (View)this.mTagsToViews.get(reactTag);
        if (view == null) {
            throw new JSApplicationIllegalArgumentException("Could not find view with tag " + reactTag);
        }
        return TouchTargetHelper.findTargetTagForTouch(touchX, touchY, (ViewGroup)view);
    }

    public synchronized void setJSResponder(int reactTag, int initialReactTag, boolean blockNativeResponder) {
        if (!blockNativeResponder) {
            this.mJSResponderHandler.setJSResponder(initialReactTag, null);
            return;
        }
        View view = (View)this.mTagsToViews.get(reactTag);
        if (initialReactTag != reactTag && view instanceof ViewParent) {
            this.mJSResponderHandler.setJSResponder(initialReactTag, (ViewParent)view);
            return;
        }
        if (this.mRootTags.get(reactTag)) {
            SoftAssertions.assertUnreachable("Cannot block native responder on " + reactTag + " that is a root view");
        }
        this.mJSResponderHandler.setJSResponder(initialReactTag, view.getParent());
    }

    public void clearJSResponder() {
        this.mJSResponderHandler.clearJSResponder();
    }

    void configureLayoutAnimation(ReadableMap config, Callback onAnimationComplete) {
        this.mLayoutAnimator.initializeFromConfig(config, onAnimationComplete);
    }

    void clearLayoutAnimation() {
        this.mLayoutAnimator.reset();
    }

    @Deprecated
    public synchronized void dispatchCommand(int reactTag, int commandId, @Nullable ReadableArray args) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"dispatchCommand[%d]: %d %s", (Object)reactTag, (Object)commandId, (Object)(args != null ? args.toString() : "<null>"));
        }
        UiThreadUtil.assertOnUiThread();
        View view = (View)this.mTagsToViews.get(reactTag);
        if (view == null) {
            throw new RetryableMountingLayerException("Trying to send command to a non-existing view with tag [" + reactTag + "] and command " + commandId);
        }
        ViewManager viewManager = this.resolveViewManager(reactTag);
        viewManager.receiveCommand(view, commandId, args);
    }

    public synchronized void dispatchCommand(int reactTag, String commandId, @Nullable ReadableArray args) {
        if (this.DEBUG_MODE) {
            FLog.d((String)TAG, (String)"dispatchCommand[%d]: %s %s", (Object)reactTag, (Object)commandId, (Object)(args != null ? args.toString() : "<null>"));
        }
        UiThreadUtil.assertOnUiThread();
        View view = (View)this.mTagsToViews.get(reactTag);
        if (view == null) {
            throw new RetryableMountingLayerException("Trying to send command to a non-existing view with tag [" + reactTag + "] and command " + commandId);
        }
        ViewManager viewManager = this.resolveViewManager(reactTag);
        viewManager.receiveCommand(view, commandId, args);
    }

    @Deprecated
    public synchronized void showPopupMenu(int reactTag, ReadableArray items, Callback success, Callback error) {
        UiThreadUtil.assertOnUiThread();
        View anchor = (View)this.mTagsToViews.get(reactTag);
        if (anchor == null) {
            error.invoke("Can't display popup. Could not find view with tag " + reactTag);
            return;
        }
        this.mPopupMenu = new PopupMenu((Context)this.getReactContextForView(reactTag), anchor);
        Menu menu = this.mPopupMenu.getMenu();
        for (int i = 0; i < items.size(); ++i) {
            menu.add(0, 0, i, (CharSequence)items.getString(i));
        }
        PopupMenuCallbackHandler handler = new PopupMenuCallbackHandler(success);
        this.mPopupMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)handler);
        this.mPopupMenu.setOnDismissListener((PopupMenu.OnDismissListener)handler);
        this.mPopupMenu.show();
    }

    @Deprecated
    public void dismissPopupMenu() {
        if (this.mPopupMenu != null) {
            this.mPopupMenu.dismiss();
        }
    }

    private ThemedReactContext getReactContextForView(int reactTag) {
        View view = (View)this.mTagsToViews.get(reactTag);
        if (view == null) {
            throw new JSApplicationIllegalArgumentException("Could not find view with tag " + reactTag);
        }
        return (ThemedReactContext)view.getContext();
    }

    public void sendAccessibilityEvent(int tag, int eventType) {
        View view = (View)this.mTagsToViews.get(tag);
        if (view == null) {
            throw new RetryableMountingLayerException("Could not find view with tag " + tag);
        }
        view.sendAccessibilityEvent(eventType);
    }

    private static class PopupMenuCallbackHandler
    implements PopupMenu.OnMenuItemClickListener,
    PopupMenu.OnDismissListener {
        final Callback mSuccess;
        boolean mConsumed = false;

        private PopupMenuCallbackHandler(Callback success) {
            this.mSuccess = success;
        }

        public void onDismiss(PopupMenu menu) {
            if (!this.mConsumed) {
                this.mSuccess.invoke("dismissed");
                this.mConsumed = true;
            }
        }

        public boolean onMenuItemClick(MenuItem item) {
            if (!this.mConsumed) {
                this.mSuccess.invoke("itemSelected", item.getOrder());
                this.mConsumed = true;
                return true;
            }
            return false;
        }
    }
}

