/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.View;
import android.view.animation.Animation;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.uimanager.layoutanimation.AbstractLayoutAnimation;
import com.facebook.react.uimanager.layoutanimation.PositionAndSizeAnimation;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class LayoutUpdateAnimation
extends AbstractLayoutAnimation {
    private static final boolean USE_TRANSLATE_ANIMATION = false;

    LayoutUpdateAnimation() {
    }

    @Override
    boolean isValid() {
        return this.mDurationMs > 0;
    }

    @Override
    @Nullable
    Animation createAnimationImpl(View view, int x, int y, int width, int height) {
        boolean animateSize;
        boolean animateLocation = view.getX() != (float)x || view.getY() != (float)y;
        boolean bl = animateSize = view.getWidth() != width || view.getHeight() != height;
        if (!animateLocation && !animateSize) {
            return null;
        }
        if (!animateLocation || !animateSize) {
            // empty if block
        }
        return new PositionAndSizeAnimation(view, x, y, width, height);
    }
}

