/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.debuggingoverlay;

import android.content.Context;
import android.graphics.RectF;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.NoSuchKeyException;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UnexpectedNativeTypeException;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.views.debuggingoverlay.DebuggingOverlay;
import com.facebook.react.views.debuggingoverlay.TraceUpdate;
import java.util.ArrayList;

@ReactModule(name="DebuggingOverlay")
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class DebuggingOverlayManager
extends SimpleViewManager<DebuggingOverlay> {
    public static final String REACT_CLASS = "DebuggingOverlay";

    @Override
    public void receiveCommand(DebuggingOverlay view, String commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case "highlightTraceUpdates": {
                if (args == null) break;
                ReadableArray providedTraceUpdates = args.getArray(0);
                ArrayList<TraceUpdate> formattedTraceUpdates = new ArrayList<TraceUpdate>();
                boolean successfullyParsedPayload = true;
                for (int i = 0; i < providedTraceUpdates.size(); ++i) {
                    ReadableMap traceUpdate = providedTraceUpdates.getMap(i);
                    ReadableMap serializedRectangle = traceUpdate.getMap("rectangle");
                    if (serializedRectangle == null) {
                        ReactSoftExceptionLogger.logSoftException(REACT_CLASS, new ReactNoCrashSoftException("Unexpected payload for highlighting trace updates: rectangle field is null"));
                        successfullyParsedPayload = false;
                        break;
                    }
                    int id2 = traceUpdate.getInt("id");
                    int color = traceUpdate.getInt("color");
                    try {
                        float left = (float)serializedRectangle.getDouble("x");
                        float top = (float)serializedRectangle.getDouble("y");
                        float right = (float)((double)left + serializedRectangle.getDouble("width"));
                        float bottom = (float)((double)top + serializedRectangle.getDouble("height"));
                        RectF rectangle = new RectF(PixelUtil.toPixelFromDIP(left), PixelUtil.toPixelFromDIP(top), PixelUtil.toPixelFromDIP(right), PixelUtil.toPixelFromDIP(bottom));
                        formattedTraceUpdates.add(new TraceUpdate(id2, rectangle, color));
                        continue;
                    }
                    catch (NoSuchKeyException | UnexpectedNativeTypeException e) {
                        ReactSoftExceptionLogger.logSoftException(REACT_CLASS, new ReactNoCrashSoftException("Unexpected payload for highlighting trace updates: rectangle field should have x, y, width, height fields"));
                        successfullyParsedPayload = false;
                        break;
                    }
                }
                if (!successfullyParsedPayload) break;
                view.setTraceUpdates(formattedTraceUpdates);
                break;
            }
            case "highlightElements": {
                if (args == null) {
                    return;
                }
                ReadableArray providedElements = args.getArray(0);
                ArrayList<RectF> elementsRectangles = new ArrayList<RectF>();
                boolean successfullyParsedPayload = true;
                for (int i = 0; i < providedElements.size(); ++i) {
                    ReadableMap element = providedElements.getMap(i);
                    try {
                        float left = (float)element.getDouble("x");
                        float top = (float)element.getDouble("y");
                        float right = (float)((double)left + element.getDouble("width"));
                        float bottom = (float)((double)top + element.getDouble("height"));
                        RectF rect = new RectF(PixelUtil.toPixelFromDIP(left), PixelUtil.toPixelFromDIP(top), PixelUtil.toPixelFromDIP(right), PixelUtil.toPixelFromDIP(bottom));
                        elementsRectangles.add(rect);
                        continue;
                    }
                    catch (NoSuchKeyException | UnexpectedNativeTypeException e) {
                        ReactSoftExceptionLogger.logSoftException(REACT_CLASS, new ReactNoCrashSoftException("Unexpected payload for highlighting elements: every element should have x, y, width, height fields"));
                        successfullyParsedPayload = false;
                        break;
                    }
                }
                if (!successfullyParsedPayload) break;
                view.setHighlightedElementsRectangles(elementsRectangles);
                break;
            }
            case "clearElementsHighlights": {
                view.clearElementsHighlights();
                break;
            }
            default: {
                ReactSoftExceptionLogger.logSoftException(REACT_CLASS, new ReactNoCrashSoftException("Received unexpected command in DebuggingOverlayManager"));
            }
        }
    }

    @Override
    public DebuggingOverlay createViewInstance(ThemedReactContext context) {
        return new DebuggingOverlay((Context)context);
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }
}

