/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.Event;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ImageLoadEvent
extends Event<ImageLoadEvent> {
    public static final int ON_ERROR = 1;
    public static final int ON_LOAD = 2;
    public static final int ON_LOAD_END = 3;
    public static final int ON_LOAD_START = 4;
    public static final int ON_PROGRESS = 5;
    private final int mEventType;
    @Nullable
    private final String mErrorMessage;
    @Nullable
    private final String mSourceUri;
    private final int mWidth;
    private final int mHeight;
    private final int mLoaded;
    private final int mTotal;

    @Deprecated
    public static final ImageLoadEvent createLoadStartEvent(int viewId) {
        return ImageLoadEvent.createLoadStartEvent(-1, viewId);
    }

    @Deprecated
    public static final ImageLoadEvent createProgressEvent(int viewId, @Nullable String imageUri, int loaded, int total) {
        return ImageLoadEvent.createProgressEvent(-1, viewId, imageUri, loaded, total);
    }

    @Deprecated
    public static final ImageLoadEvent createLoadEvent(int viewId, @Nullable String imageUri, int width, int height) {
        return ImageLoadEvent.createLoadEvent(-1, viewId, imageUri, width, height);
    }

    @Deprecated
    public static final ImageLoadEvent createErrorEvent(int viewId, Throwable throwable) {
        return ImageLoadEvent.createErrorEvent(-1, viewId, throwable);
    }

    @Deprecated
    public static final ImageLoadEvent createLoadEndEvent(int viewId) {
        return ImageLoadEvent.createLoadEndEvent(-1, viewId);
    }

    public static final ImageLoadEvent createLoadStartEvent(int surfaceId, int viewId) {
        return new ImageLoadEvent(surfaceId, viewId, 4);
    }

    public static final ImageLoadEvent createProgressEvent(int surfaceId, int viewId, @Nullable String imageUri, int loaded, int total) {
        return new ImageLoadEvent(surfaceId, viewId, 5, null, imageUri, 0, 0, loaded, total);
    }

    public static final ImageLoadEvent createLoadEvent(int surfaceId, int viewId, @Nullable String imageUri, int width, int height) {
        return new ImageLoadEvent(surfaceId, viewId, 2, null, imageUri, width, height, 0, 0);
    }

    public static final ImageLoadEvent createErrorEvent(int surfaceId, int viewId, Throwable throwable) {
        return new ImageLoadEvent(surfaceId, viewId, 1, throwable.getMessage(), null, 0, 0, 0, 0);
    }

    public static final ImageLoadEvent createLoadEndEvent(int surfaceId, int viewId) {
        return new ImageLoadEvent(surfaceId, viewId, 3);
    }

    private ImageLoadEvent(int surfaceId, int viewId, int eventType) {
        this(surfaceId, viewId, eventType, null, null, 0, 0, 0, 0);
    }

    private ImageLoadEvent(int surfaceId, int viewId, int eventType, @Nullable String errorMessage, @Nullable String sourceUri, int width, int height, int loaded, int total) {
        super(surfaceId, viewId);
        this.mEventType = eventType;
        this.mErrorMessage = errorMessage;
        this.mSourceUri = sourceUri;
        this.mWidth = width;
        this.mHeight = height;
        this.mLoaded = loaded;
        this.mTotal = total;
    }

    public static String eventNameForType(int eventType) {
        switch (eventType) {
            case 1: {
                return "topError";
            }
            case 2: {
                return "topLoad";
            }
            case 3: {
                return "topLoadEnd";
            }
            case 4: {
                return "topLoadStart";
            }
            case 5: {
                return "topProgress";
            }
        }
        throw new IllegalStateException("Invalid image event: " + Integer.toString(eventType));
    }

    @Override
    public String getEventName() {
        return ImageLoadEvent.eventNameForType(this.mEventType);
    }

    @Override
    public short getCoalescingKey() {
        return (short)this.mEventType;
    }

    @Override
    protected WritableMap getEventData() {
        WritableMap eventData = Arguments.createMap();
        switch (this.mEventType) {
            case 5: {
                eventData.putInt("loaded", this.mLoaded);
                eventData.putInt("total", this.mTotal);
                break;
            }
            case 2: {
                eventData.putMap("source", this.createEventDataSource());
                break;
            }
            case 1: {
                eventData.putString("error", this.mErrorMessage);
            }
        }
        return eventData;
    }

    private WritableMap createEventDataSource() {
        WritableMap source = Arguments.createMap();
        source.putString("uri", this.mSourceUri);
        source.putDouble("width", this.mWidth);
        source.putDouble("height", this.mHeight);
        return source;
    }
}

