/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.common.internal.Objects;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.controller.ForwardingControllerListener;
import com.facebook.drawee.drawable.AutoRotateDrawable;
import com.facebook.drawee.drawable.RoundedColorDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.GenericDraweeView;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.postprocessors.IterativeBoxBlurPostProcessor;
import com.facebook.imagepipeline.request.BasePostprocessor;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.modules.fresco.ReactNetworkImageRequest;
import com.facebook.react.uimanager.FloatUtil;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.util.RNLog;
import com.facebook.react.views.image.GlobalImageLoadListener;
import com.facebook.react.views.image.ImageLoadEvent;
import com.facebook.react.views.image.ImageResizeMethod;
import com.facebook.react.views.image.ImageResizeMode;
import com.facebook.react.views.image.MultiPostprocessor;
import com.facebook.react.views.image.ReactImageDownloadListener;
import com.facebook.react.views.imagehelper.ImageSource;
import com.facebook.react.views.imagehelper.MultiSourceHelper;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.yoga.YogaConstants;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ReactImageView
extends GenericDraweeView {
    public static final int REMOTE_IMAGE_FADE_DURATION_MS = 300;
    private static float[] sComputedCornerRadii = new float[4];
    private ImageResizeMethod mResizeMethod = ImageResizeMethod.AUTO;
    private static final Matrix sTileMatrix = new Matrix();
    private final List<ImageSource> mSources = new LinkedList<ImageSource>();
    @Nullable
    private ImageSource mImageSource;
    @Nullable
    private ImageSource mCachedImageSource;
    @Nullable
    private Drawable mDefaultImageDrawable;
    @Nullable
    private Drawable mLoadingImageDrawable;
    @Nullable
    private RoundedColorDrawable mBackgroundImageDrawable;
    private int mBackgroundColor = 0;
    private int mBorderColor;
    private int mOverlayColor;
    private float mBorderWidth;
    private float mBorderRadius = Float.NaN;
    @Nullable
    private float[] mBorderCornerRadii;
    private ScalingUtils.ScaleType mScaleType = ImageResizeMode.defaultValue();
    private Shader.TileMode mTileMode = ImageResizeMode.defaultTileMode();
    private boolean mIsDirty;
    private final AbstractDraweeControllerBuilder mDraweeControllerBuilder;
    @Nullable
    private TilePostprocessor mTilePostprocessor;
    @Nullable
    private IterativeBoxBlurPostProcessor mIterativeBoxBlurPostProcessor;
    @Nullable
    private ReactImageDownloadListener mDownloadListener;
    @Nullable
    private ControllerListener mControllerForTesting;
    @Nullable
    private GlobalImageLoadListener mGlobalImageLoadListener;
    @Nullable
    private Object mCallerContext;
    private int mFadeDurationMs = -1;
    private boolean mProgressiveRenderingEnabled;
    private ReadableMap mHeaders;

    public void updateCallerContext(@Nullable Object callerContext) {
        if (!Objects.equal((Object)this.mCallerContext, (Object)callerContext)) {
            this.mCallerContext = callerContext;
            this.mIsDirty = true;
        }
    }

    private static GenericDraweeHierarchy buildHierarchy(Context context) {
        RoundingParams roundingParams = RoundingParams.fromCornersRadius((float)0.0f);
        roundingParams.setPaintFilterBitmap(true);
        return new GenericDraweeHierarchyBuilder(context.getResources()).setRoundingParams(roundingParams).build();
    }

    public ReactImageView(Context context, AbstractDraweeControllerBuilder draweeControllerBuilder, @Nullable GlobalImageLoadListener globalImageLoadListener, @Nullable Object callerContext) {
        super(context, ReactImageView.buildHierarchy(context));
        this.mDraweeControllerBuilder = draweeControllerBuilder;
        this.mGlobalImageLoadListener = globalImageLoadListener;
        this.mCallerContext = callerContext;
        this.setLegacyVisibilityHandlingEnabled(true);
    }

    public void setShouldNotifyLoadEvents(boolean shouldNotify) {
        if (shouldNotify == (this.mDownloadListener != null)) {
            return;
        }
        if (!shouldNotify) {
            this.mDownloadListener = null;
        } else {
            final EventDispatcher mEventDispatcher = UIManagerHelper.getEventDispatcherForReactTag((ReactContext)this.getContext(), this.getId());
            this.mDownloadListener = new ReactImageDownloadListener<ImageInfo>(){

                @Override
                public void onProgressChange(int loaded, int total) {
                    mEventDispatcher.dispatchEvent(ImageLoadEvent.createProgressEvent(UIManagerHelper.getSurfaceId((View)ReactImageView.this), ReactImageView.this.getId(), ReactImageView.this.mImageSource.getSource(), loaded, total));
                }

                @Override
                public void onSubmit(String id2, Object callerContext) {
                    mEventDispatcher.dispatchEvent(ImageLoadEvent.createLoadStartEvent(UIManagerHelper.getSurfaceId((View)ReactImageView.this), ReactImageView.this.getId()));
                }

                @Override
                public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
                    if (imageInfo != null) {
                        mEventDispatcher.dispatchEvent(ImageLoadEvent.createLoadEvent(UIManagerHelper.getSurfaceId((View)ReactImageView.this), ReactImageView.this.getId(), ReactImageView.this.mImageSource.getSource(), imageInfo.getWidth(), imageInfo.getHeight()));
                        mEventDispatcher.dispatchEvent(ImageLoadEvent.createLoadEndEvent(UIManagerHelper.getSurfaceId((View)ReactImageView.this), ReactImageView.this.getId()));
                    }
                }

                @Override
                public void onFailure(String id2, Throwable throwable) {
                    mEventDispatcher.dispatchEvent(ImageLoadEvent.createErrorEvent(UIManagerHelper.getSurfaceId((View)ReactImageView.this), ReactImageView.this.getId(), throwable));
                }
            };
        }
        this.mIsDirty = true;
    }

    public void setBlurRadius(float blurRadius) {
        int pixelBlurRadius = (int)PixelUtil.toPixelFromDIP(blurRadius) / 2;
        this.mIterativeBoxBlurPostProcessor = pixelBlurRadius == 0 ? null : new IterativeBoxBlurPostProcessor(2, pixelBlurRadius);
        this.mIsDirty = true;
    }

    public void setBackgroundColor(int backgroundColor) {
        if (this.mBackgroundColor != backgroundColor) {
            this.mBackgroundColor = backgroundColor;
            this.mBackgroundImageDrawable = new RoundedColorDrawable(backgroundColor);
            this.mIsDirty = true;
        }
    }

    public void setBorderColor(int borderColor) {
        if (this.mBorderColor != borderColor) {
            this.mBorderColor = borderColor;
            this.mIsDirty = true;
        }
    }

    public void setOverlayColor(int overlayColor) {
        if (this.mOverlayColor != overlayColor) {
            this.mOverlayColor = overlayColor;
            this.mIsDirty = true;
        }
    }

    public void setBorderWidth(float borderWidth) {
        float newBorderWidth = PixelUtil.toPixelFromDIP(borderWidth);
        if (!FloatUtil.floatsEqual(this.mBorderWidth, newBorderWidth)) {
            this.mBorderWidth = newBorderWidth;
            this.mIsDirty = true;
        }
    }

    public void setBorderRadius(float borderRadius) {
        if (!FloatUtil.floatsEqual(this.mBorderRadius, borderRadius)) {
            this.mBorderRadius = borderRadius;
            this.mIsDirty = true;
        }
    }

    public void setBorderRadius(float borderRadius, int position) {
        if (this.mBorderCornerRadii == null) {
            this.mBorderCornerRadii = new float[4];
            Arrays.fill(this.mBorderCornerRadii, Float.NaN);
        }
        if (!FloatUtil.floatsEqual(this.mBorderCornerRadii[position], borderRadius)) {
            this.mBorderCornerRadii[position] = borderRadius;
            this.mIsDirty = true;
        }
    }

    public void setScaleType(ScalingUtils.ScaleType scaleType) {
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            this.mIsDirty = true;
        }
    }

    public void setTileMode(Shader.TileMode tileMode) {
        if (this.mTileMode != tileMode) {
            this.mTileMode = tileMode;
            this.mTilePostprocessor = this.isTiled() ? new TilePostprocessor() : null;
            this.mIsDirty = true;
        }
    }

    public void setResizeMethod(ImageResizeMethod resizeMethod) {
        if (this.mResizeMethod != resizeMethod) {
            this.mResizeMethod = resizeMethod;
            this.mIsDirty = true;
        }
    }

    public void setSource(@Nullable ReadableArray sources) {
        LinkedList<ImageSource> tmpSources = new LinkedList<ImageSource>();
        if (sources == null || sources.size() == 0) {
            tmpSources.add(ImageSource.getTransparentBitmapImageSource(this.getContext()));
        } else if (sources.size() == 1) {
            ReadableMap source = sources.getMap(0);
            ImageSource imageSource = new ImageSource(this.getContext(), source.getString("uri"));
            if (Uri.EMPTY.equals((Object)imageSource.getUri())) {
                this.warnImageSource(source.getString("uri"));
                imageSource = ImageSource.getTransparentBitmapImageSource(this.getContext());
            }
            tmpSources.add(imageSource);
        } else {
            for (int idx = 0; idx < sources.size(); ++idx) {
                ReadableMap source = sources.getMap(idx);
                ImageSource imageSource = new ImageSource(this.getContext(), source.getString("uri"), source.getDouble("width"), source.getDouble("height"));
                if (Uri.EMPTY.equals((Object)imageSource.getUri())) {
                    this.warnImageSource(source.getString("uri"));
                    imageSource = ImageSource.getTransparentBitmapImageSource(this.getContext());
                }
                tmpSources.add(imageSource);
            }
        }
        if (this.mSources.equals(tmpSources)) {
            return;
        }
        this.mSources.clear();
        for (ImageSource src : tmpSources) {
            this.mSources.add(src);
        }
        this.mIsDirty = true;
    }

    public void setDefaultSource(@Nullable String name) {
        Drawable newDefaultDrawable = ResourceDrawableIdHelper.getInstance().getResourceDrawable(this.getContext(), name);
        if (!Objects.equal((Object)this.mDefaultImageDrawable, (Object)newDefaultDrawable)) {
            this.mDefaultImageDrawable = newDefaultDrawable;
            this.mIsDirty = true;
        }
    }

    public void setLoadingIndicatorSource(@Nullable String name) {
        AutoRotateDrawable newLoadingIndicatorSource;
        Drawable drawable = ResourceDrawableIdHelper.getInstance().getResourceDrawable(this.getContext(), name);
        AutoRotateDrawable autoRotateDrawable = newLoadingIndicatorSource = drawable != null ? new AutoRotateDrawable(drawable, 1000) : null;
        if (!Objects.equal((Object)this.mLoadingImageDrawable, (Object)newLoadingIndicatorSource)) {
            this.mLoadingImageDrawable = newLoadingIndicatorSource;
            this.mIsDirty = true;
        }
    }

    public void setProgressiveRenderingEnabled(boolean enabled) {
        this.mProgressiveRenderingEnabled = enabled;
    }

    public void setFadeDuration(int durationMs) {
        this.mFadeDurationMs = durationMs;
    }

    private void getCornerRadii(float[] computedCorners) {
        float defaultBorderRadius = !YogaConstants.isUndefined(this.mBorderRadius) ? this.mBorderRadius : 0.0f;
        computedCorners[0] = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[0]) ? this.mBorderCornerRadii[0] : defaultBorderRadius;
        computedCorners[1] = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[1]) ? this.mBorderCornerRadii[1] : defaultBorderRadius;
        computedCorners[2] = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[2]) ? this.mBorderCornerRadii[2] : defaultBorderRadius;
        computedCorners[3] = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[3]) ? this.mBorderCornerRadii[3] : defaultBorderRadius;
    }

    public void setHeaders(ReadableMap headers) {
        this.mHeaders = headers;
    }

    public void maybeUpdateView() {
        if (!this.mIsDirty) {
            return;
        }
        if (this.hasMultipleSources() && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        this.setSourceImage();
        if (this.mImageSource == null) {
            return;
        }
        boolean doResize = this.shouldResize(this.mImageSource);
        if (doResize && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        if (this.isTiled() && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        GenericDraweeHierarchy hierarchy = (GenericDraweeHierarchy)this.getHierarchy();
        hierarchy.setActualImageScaleType(this.mScaleType);
        if (this.mDefaultImageDrawable != null) {
            hierarchy.setPlaceholderImage(this.mDefaultImageDrawable, this.mScaleType);
        }
        if (this.mLoadingImageDrawable != null) {
            hierarchy.setPlaceholderImage(this.mLoadingImageDrawable, ScalingUtils.ScaleType.CENTER);
        }
        this.getCornerRadii(sComputedCornerRadii);
        RoundingParams roundingParams = hierarchy.getRoundingParams();
        roundingParams.setCornersRadii(sComputedCornerRadii[0], sComputedCornerRadii[1], sComputedCornerRadii[2], sComputedCornerRadii[3]);
        if (this.mBackgroundImageDrawable != null) {
            this.mBackgroundImageDrawable.setBorder(this.mBorderColor, this.mBorderWidth);
            this.mBackgroundImageDrawable.setRadii(roundingParams.getCornersRadii());
            hierarchy.setBackgroundImage((Drawable)this.mBackgroundImageDrawable);
        }
        roundingParams.setBorder(this.mBorderColor, this.mBorderWidth);
        if (this.mOverlayColor != 0) {
            roundingParams.setOverlayColor(this.mOverlayColor);
        } else {
            roundingParams.setRoundingMethod(RoundingParams.RoundingMethod.BITMAP_ONLY);
        }
        hierarchy.setRoundingParams(roundingParams);
        hierarchy.setFadeDuration(this.mFadeDurationMs >= 0 ? this.mFadeDurationMs : (this.mImageSource.isResource() ? 0 : 300));
        LinkedList<Postprocessor> postprocessors = new LinkedList<Postprocessor>();
        if (this.mIterativeBoxBlurPostProcessor != null) {
            postprocessors.add((Postprocessor)this.mIterativeBoxBlurPostProcessor);
        }
        if (this.mTilePostprocessor != null) {
            postprocessors.add((Postprocessor)this.mTilePostprocessor);
        }
        Postprocessor postprocessor = MultiPostprocessor.from(postprocessors);
        ResizeOptions resizeOptions = doResize ? new ResizeOptions(this.getWidth(), this.getHeight()) : null;
        ImageRequestBuilder imageRequestBuilder = ImageRequestBuilder.newBuilderWithSource((Uri)this.mImageSource.getUri()).setPostprocessor(postprocessor).setResizeOptions(resizeOptions).setAutoRotateEnabled(true).setProgressiveRenderingEnabled(this.mProgressiveRenderingEnabled);
        ReactNetworkImageRequest imageRequest = ReactNetworkImageRequest.fromBuilderWithHeaders(imageRequestBuilder, this.mHeaders);
        if (this.mGlobalImageLoadListener != null) {
            this.mGlobalImageLoadListener.onLoadAttempt(this.mImageSource.getUri());
        }
        this.mDraweeControllerBuilder.reset();
        this.mDraweeControllerBuilder.setAutoPlayAnimations(true).setCallerContext(this.mCallerContext).setOldController(this.getController()).setImageRequest((Object)imageRequest);
        if (this.mCachedImageSource != null) {
            ImageRequest cachedImageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)this.mCachedImageSource.getUri()).setPostprocessor(postprocessor).setResizeOptions(resizeOptions).setAutoRotateEnabled(true).setProgressiveRenderingEnabled(this.mProgressiveRenderingEnabled).build();
            this.mDraweeControllerBuilder.setLowResImageRequest((Object)cachedImageRequest);
        }
        if (this.mDownloadListener != null && this.mControllerForTesting != null) {
            ForwardingControllerListener combinedListener = new ForwardingControllerListener();
            combinedListener.addListener((ControllerListener)this.mDownloadListener);
            combinedListener.addListener(this.mControllerForTesting);
            this.mDraweeControllerBuilder.setControllerListener((ControllerListener)combinedListener);
        } else if (this.mControllerForTesting != null) {
            this.mDraweeControllerBuilder.setControllerListener(this.mControllerForTesting);
        } else if (this.mDownloadListener != null) {
            this.mDraweeControllerBuilder.setControllerListener((ControllerListener)this.mDownloadListener);
        }
        if (this.mDownloadListener != null) {
            hierarchy.setProgressBarImage((Drawable)this.mDownloadListener);
        }
        this.setController((DraweeController)this.mDraweeControllerBuilder.build());
        this.mIsDirty = false;
        this.mDraweeControllerBuilder.reset();
    }

    public void setControllerListener(ControllerListener controllerListener) {
        this.mControllerForTesting = controllerListener;
        this.mIsDirty = true;
        this.maybeUpdateView();
    }

    @Nullable
    public ImageSource getImageSource() {
        return this.mImageSource;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.mIsDirty = this.mIsDirty || this.hasMultipleSources() || this.isTiled();
            this.maybeUpdateView();
        }
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    private boolean hasMultipleSources() {
        return this.mSources.size() > 1;
    }

    private boolean isTiled() {
        return this.mTileMode != Shader.TileMode.CLAMP;
    }

    private void setSourceImage() {
        this.mImageSource = null;
        if (this.mSources.isEmpty()) {
            this.mSources.add(ImageSource.getTransparentBitmapImageSource(this.getContext()));
        } else if (this.hasMultipleSources()) {
            MultiSourceHelper.MultiSourceResult multiSource = MultiSourceHelper.getBestSourceForSize(this.getWidth(), this.getHeight(), this.mSources);
            this.mImageSource = multiSource.getBestResult();
            this.mCachedImageSource = multiSource.getBestResultInCache();
            return;
        }
        this.mImageSource = this.mSources.get(0);
    }

    private boolean shouldResize(ImageSource imageSource) {
        if (this.mResizeMethod == ImageResizeMethod.AUTO) {
            return UriUtil.isLocalContentUri((Uri)imageSource.getUri()) || UriUtil.isLocalFileUri((Uri)imageSource.getUri());
        }
        return this.mResizeMethod == ImageResizeMethod.RESIZE;
    }

    private void warnImageSource(String uri) {
        if (ReactBuildConfig.DEBUG) {
            RNLog.w((ReactContext)this.getContext(), "ReactImageView: Image source \"" + uri + "\" doesn't exist");
        }
    }

    private class TilePostprocessor
    extends BasePostprocessor {
        private TilePostprocessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloseableReference<Bitmap> process(Bitmap source, PlatformBitmapFactory bitmapFactory) {
            Rect destRect = new Rect(0, 0, ReactImageView.this.getWidth(), ReactImageView.this.getHeight());
            ReactImageView.this.mScaleType.getTransform(sTileMatrix, destRect, source.getWidth(), source.getHeight(), 0.0f, 0.0f);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            BitmapShader shader = new BitmapShader(source, ReactImageView.this.mTileMode, ReactImageView.this.mTileMode);
            shader.setLocalMatrix(sTileMatrix);
            paint.setShader((Shader)shader);
            CloseableReference output = bitmapFactory.createBitmap(ReactImageView.this.getWidth(), ReactImageView.this.getHeight());
            try {
                Canvas canvas = new Canvas((Bitmap)output.get());
                canvas.drawRect(destRect, paint);
                CloseableReference closeableReference = output.clone();
                return closeableReference;
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)output);
            }
        }
    }
}

