/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.progressbar;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.views.progressbar.ReactProgressBarViewManager;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class ProgressBarContainerView
extends FrameLayout {
    private static final int MAX_PROGRESS = 1000;
    @Nullable
    private Integer mColor;
    private boolean mIndeterminate = true;
    private boolean mAnimating = true;
    private double mProgress;
    @Nullable
    private ProgressBar mProgressBar;

    public ProgressBarContainerView(Context context) {
        super(context);
    }

    public void setStyle(@Nullable String styleName) {
        int style2 = ReactProgressBarViewManager.getStyleFromString(styleName);
        this.mProgressBar = ReactProgressBarViewManager.createProgressBar(this.getContext(), style2);
        this.mProgressBar.setMax(1000);
        this.removeAllViews();
        this.addView((View)this.mProgressBar, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setColor(@Nullable Integer color) {
        this.mColor = color;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.mIndeterminate = indeterminate;
    }

    public void setProgress(double progress) {
        this.mProgress = progress;
    }

    public void setAnimating(boolean animating) {
        this.mAnimating = animating;
    }

    public void apply() {
        if (this.mProgressBar == null) {
            throw new JSApplicationIllegalArgumentException("setStyle() not called");
        }
        this.mProgressBar.setIndeterminate(this.mIndeterminate);
        this.setColor(this.mProgressBar);
        this.mProgressBar.setProgress((int)(this.mProgress * 1000.0));
        if (this.mAnimating) {
            this.mProgressBar.setVisibility(0);
        } else {
            this.mProgressBar.setVisibility(4);
        }
    }

    private void setColor(ProgressBar progressBar) {
        Drawable drawable = progressBar.isIndeterminate() ? progressBar.getIndeterminateDrawable() : progressBar.getProgressDrawable();
        if (drawable == null) {
            return;
        }
        if (this.mColor != null) {
            drawable.setColorFilter(this.mColor.intValue(), PorterDuff.Mode.SRC_IN);
        } else {
            drawable.clearColorFilter();
        }
    }
}

