/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.views.scroll.FpsListener;
import com.facebook.react.views.scroll.MaintainVisibleScrollPositionHelper;
import com.facebook.react.views.scroll.ReactHorizontalScrollView;
import com.facebook.react.views.scroll.ReactScrollViewCommandHelper;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.yoga.YogaConstants;
import java.util.ArrayList;

@ReactModule(name="AndroidHorizontalScrollView")
public class ReactHorizontalScrollViewManager
extends ViewGroupManager<ReactHorizontalScrollView>
implements ReactScrollViewCommandHelper.ScrollCommandHandler<ReactHorizontalScrollView> {
    public static final String REACT_CLASS = "AndroidHorizontalScrollView";
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3};
    @Nullable
    private FpsListener mFpsListener = null;

    public ReactHorizontalScrollViewManager() {
        this((FpsListener)null);
    }

    public ReactHorizontalScrollViewManager(@Nullable FpsListener fpsListener) {
        this.mFpsListener = fpsListener;
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactHorizontalScrollView createViewInstance(ThemedReactContext context) {
        return new ReactHorizontalScrollView((Context)context, this.mFpsListener);
    }

    @Override
    public Object updateState(ReactHorizontalScrollView view, ReactStylesDiffMap props, StateWrapper stateWrapper) {
        view.setStateWrapper(stateWrapper);
        return null;
    }

    @ReactProp(name="scrollEnabled", defaultBoolean=true)
    public void setScrollEnabled(ReactHorizontalScrollView view, boolean value) {
        view.setScrollEnabled(value);
    }

    @ReactProp(name="showsHorizontalScrollIndicator")
    public void setShowsHorizontalScrollIndicator(ReactHorizontalScrollView view, boolean value) {
        view.setHorizontalScrollBarEnabled(value);
    }

    @ReactProp(name="decelerationRate")
    public void setDecelerationRate(ReactHorizontalScrollView view, float decelerationRate) {
        view.setDecelerationRate(decelerationRate);
    }

    @ReactProp(name="disableIntervalMomentum")
    public void setDisableIntervalMomentum(ReactHorizontalScrollView view, boolean disableIntervalMomentum) {
        view.setDisableIntervalMomentum(disableIntervalMomentum);
    }

    @ReactProp(name="snapToInterval")
    public void setSnapToInterval(ReactHorizontalScrollView view, float snapToInterval) {
        float density = PixelUtil.getDisplayMetricDensity();
        view.setSnapInterval((int)(snapToInterval * density));
    }

    @ReactProp(name="snapToAlignment")
    public void setSnapToAlignment(ReactHorizontalScrollView view, String alignment) {
        view.setSnapToAlignment(ReactScrollViewHelper.parseSnapToAlignment(alignment));
    }

    @ReactProp(name="snapToOffsets")
    public void setSnapToOffsets(ReactHorizontalScrollView view, @Nullable ReadableArray snapToOffsets) {
        if (snapToOffsets == null || snapToOffsets.size() == 0) {
            view.setSnapOffsets(null);
            return;
        }
        float density = PixelUtil.getDisplayMetricDensity();
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        for (int i = 0; i < snapToOffsets.size(); ++i) {
            offsets.add((int)(snapToOffsets.getDouble(i) * (double)density));
        }
        view.setSnapOffsets(offsets);
    }

    @ReactProp(name="snapToStart")
    public void setSnapToStart(ReactHorizontalScrollView view, boolean snapToStart) {
        view.setSnapToStart(snapToStart);
    }

    @ReactProp(name="snapToEnd")
    public void setSnapToEnd(ReactHorizontalScrollView view, boolean snapToEnd) {
        view.setSnapToEnd(snapToEnd);
    }

    @ReactProp(name="removeClippedSubviews")
    public void setRemoveClippedSubviews(ReactHorizontalScrollView view, boolean removeClippedSubviews) {
        view.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @ReactProp(name="sendMomentumEvents")
    public void setSendMomentumEvents(ReactHorizontalScrollView view, boolean sendMomentumEvents) {
        view.setSendMomentumEvents(sendMomentumEvents);
    }

    @ReactProp(name="scrollPerfTag")
    public void setScrollPerfTag(ReactHorizontalScrollView view, String scrollPerfTag) {
        view.setScrollPerfTag(scrollPerfTag);
    }

    @ReactProp(name="pagingEnabled")
    public void setPagingEnabled(ReactHorizontalScrollView view, boolean pagingEnabled) {
        view.setPagingEnabled(pagingEnabled);
    }

    @ReactProp(name="overScrollMode")
    public void setOverScrollMode(ReactHorizontalScrollView view, String value) {
        view.setOverScrollMode(ReactScrollViewHelper.parseOverScrollMode(value));
    }

    @ReactProp(name="nestedScrollEnabled")
    public void setNestedScrollEnabled(ReactHorizontalScrollView view, boolean value) {
        ViewCompat.setNestedScrollingEnabled((View)view, (boolean)value);
    }

    @Override
    public void receiveCommand(ReactHorizontalScrollView scrollView, int commandId, @Nullable ReadableArray args) {
        ReactScrollViewCommandHelper.receiveCommand(this, scrollView, commandId, args);
    }

    @Override
    public void receiveCommand(ReactHorizontalScrollView scrollView, String commandId, @Nullable ReadableArray args) {
        ReactScrollViewCommandHelper.receiveCommand(this, scrollView, commandId, args);
    }

    @Override
    public void flashScrollIndicators(ReactHorizontalScrollView scrollView) {
        scrollView.flashScrollIndicators();
    }

    @Override
    public void scrollTo(ReactHorizontalScrollView scrollView, ReactScrollViewCommandHelper.ScrollToCommandData data) {
        scrollView.abortAnimation();
        if (data.mAnimated) {
            scrollView.reactSmoothScrollTo(data.mDestX, data.mDestY);
        } else {
            scrollView.scrollTo(data.mDestX, data.mDestY);
        }
    }

    @Override
    public void scrollToEnd(ReactHorizontalScrollView scrollView, ReactScrollViewCommandHelper.ScrollToEndCommandData data) {
        View child = scrollView.getChildAt(0);
        if (child == null) {
            throw new RetryableMountingLayerException("scrollToEnd called on HorizontalScrollView without child");
        }
        int right = child.getWidth() + scrollView.getPaddingRight();
        scrollView.abortAnimation();
        if (data.mAnimated) {
            scrollView.reactSmoothScrollTo(right, scrollView.getScrollY());
        } else {
            scrollView.scrollTo(right, scrollView.getScrollY());
        }
    }

    @ReactProp(name="endFillColor", defaultInt=0, customType="Color")
    public void setBottomFillColor(ReactHorizontalScrollView view, int color) {
        view.setEndFillColor(color);
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public void setBorderRadius(ReactHorizontalScrollView view, int index, float borderRadius) {
        if (!YogaConstants.isUndefined(borderRadius)) {
            borderRadius = PixelUtil.toPixelFromDIP(borderRadius);
        }
        if (index == 0) {
            view.setBorderRadius(borderRadius);
        } else {
            view.setBorderRadius(borderRadius, index - 1);
        }
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(ReactHorizontalScrollView view, @Nullable String borderStyle) {
        view.setBorderStyle(borderStyle);
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public void setBorderWidth(ReactHorizontalScrollView view, int index, float width) {
        if (!YogaConstants.isUndefined(width)) {
            width = PixelUtil.toPixelFromDIP(width);
        }
        view.setBorderWidth(SPACING_TYPES[index], width);
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public void setBorderColor(ReactHorizontalScrollView view, int index, Integer color) {
        float rgbComponent = color == null ? Float.NaN : (float)(color & 0xFFFFFF);
        float alphaComponent = color == null ? Float.NaN : (float)(color >>> 24);
        view.setBorderColor(SPACING_TYPES[index], rgbComponent, alphaComponent);
    }

    @ReactProp(name="overflow")
    public void setOverflow(ReactHorizontalScrollView view, @Nullable String overflow) {
        view.setOverflow(overflow);
    }

    @ReactProp(name="persistentScrollbar")
    public void setPersistentScrollbar(ReactHorizontalScrollView view, boolean value) {
        view.setScrollbarFadingEnabled(!value);
    }

    @ReactProp(name="fadingEdgeLength")
    public void setFadingEdgeLength(ReactHorizontalScrollView view, int value) {
        if (value > 0) {
            view.setHorizontalFadingEdgeEnabled(true);
            view.setFadingEdgeLength(value);
        } else {
            view.setHorizontalFadingEdgeEnabled(false);
            view.setFadingEdgeLength(0);
        }
    }

    @ReactProp(name="contentOffset")
    public void setContentOffset(ReactHorizontalScrollView view, ReadableMap value) {
        if (value != null) {
            double x = value.hasKey("x") ? value.getDouble("x") : 0.0;
            double y = value.hasKey("y") ? value.getDouble("y") : 0.0;
            view.scrollTo((int)PixelUtil.toPixelFromDIP(x), (int)PixelUtil.toPixelFromDIP(y));
        } else {
            view.scrollTo(0, 0);
        }
    }

    @ReactProp(name="maintainVisibleContentPosition")
    public void setMaintainVisibleContentPosition(ReactHorizontalScrollView view, ReadableMap value) {
        if (value != null) {
            view.setMaintainVisibleContentPosition(MaintainVisibleScrollPositionHelper.Config.fromReadableMap(value));
        } else {
            view.setMaintainVisibleContentPosition(null);
        }
    }

    @ReactProp(name="pointerEvents")
    public void setPointerEvents(ReactHorizontalScrollView view, @Nullable String pointerEventsStr) {
        view.setPointerEvents(PointerEvents.parsePointerEvents(pointerEventsStr));
    }

    @ReactProp(name="scrollEventThrottle")
    public void setScrollEventThrottle(ReactHorizontalScrollView view, int scrollEventThrottle) {
        view.setScrollEventThrottle(scrollEventThrottle);
    }
}

