/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.views.text.EffectiveTextAttributeProvider;
import com.facebook.react.views.text.ReactTypefaceUtils;
import com.facebook.react.views.text.TextTransform;
import java.util.ArrayList;

public class TextAttributeProps
implements EffectiveTextAttributeProvider {
    public static final short TA_KEY_FOREGROUND_COLOR = 0;
    public static final short TA_KEY_BACKGROUND_COLOR = 1;
    public static final short TA_KEY_OPACITY = 2;
    public static final short TA_KEY_FONT_FAMILY = 3;
    public static final short TA_KEY_FONT_SIZE = 4;
    public static final short TA_KEY_FONT_SIZE_MULTIPLIER = 5;
    public static final short TA_KEY_FONT_WEIGHT = 6;
    public static final short TA_KEY_FONT_STYLE = 7;
    public static final short TA_KEY_FONT_VARIANT = 8;
    public static final short TA_KEY_ALLOW_FONT_SCALING = 9;
    public static final short TA_KEY_LETTER_SPACING = 10;
    public static final short TA_KEY_LINE_HEIGHT = 11;
    public static final short TA_KEY_ALIGNMENT = 12;
    public static final short TA_KEY_BEST_WRITING_DIRECTION = 13;
    public static final short TA_KEY_TEXT_DECORATION_COLOR = 14;
    public static final short TA_KEY_TEXT_DECORATION_LINE = 15;
    public static final short TA_KEY_TEXT_DECORATION_STYLE = 16;
    public static final short TA_KEY_TEXT_SHADOW_RADIUS = 18;
    public static final short TA_KEY_TEXT_SHADOW_COLOR = 19;
    public static final short TA_KEY_TEXT_SHADOW_OFFSET_DX = 20;
    public static final short TA_KEY_TEXT_SHADOW_OFFSET_DY = 21;
    public static final short TA_KEY_IS_HIGHLIGHTED = 22;
    public static final short TA_KEY_LAYOUT_DIRECTION = 23;
    public static final short TA_KEY_ACCESSIBILITY_ROLE = 24;
    public static final short TA_KEY_LINE_BREAK_STRATEGY = 25;
    public static final short TA_KEY_ROLE = 26;
    public static final short TA_KEY_TEXT_TRANSFORM = 27;
    public static final int UNSET = -1;
    private static final String PROP_SHADOW_OFFSET = "textShadowOffset";
    private static final String PROP_SHADOW_OFFSET_WIDTH = "width";
    private static final String PROP_SHADOW_OFFSET_HEIGHT = "height";
    private static final String PROP_SHADOW_RADIUS = "textShadowRadius";
    private static final String PROP_SHADOW_COLOR = "textShadowColor";
    private static final String PROP_TEXT_TRANSFORM = "textTransform";
    private static final int DEFAULT_TEXT_SHADOW_COLOR = 0x55000000;
    private static final int DEFAULT_JUSTIFICATION_MODE = Build.VERSION.SDK_INT < 26 ? 0 : 0;
    private static final int DEFAULT_BREAK_STRATEGY = 1;
    private static final int DEFAULT_HYPHENATION_FREQUENCY = 0;
    protected float mLineHeight = Float.NaN;
    protected boolean mIsColorSet = false;
    protected boolean mAllowFontScaling = true;
    protected int mColor;
    protected boolean mIsBackgroundColorSet = false;
    protected int mBackgroundColor;
    protected int mNumberOfLines = -1;
    protected int mFontSize = -1;
    protected float mFontSizeInput = -1.0f;
    protected float mLineHeightInput = -1.0f;
    protected float mLetterSpacingInput = Float.NaN;
    protected int mTextAlign = 0;
    protected int mLayoutDirection = -1;
    @NonNull
    protected TextTransform mTextTransform = TextTransform.NONE;
    protected float mTextShadowOffsetDx = 0.0f;
    protected float mTextShadowOffsetDy = 0.0f;
    protected float mTextShadowRadius = 0.0f;
    protected int mTextShadowColor = 0x55000000;
    protected boolean mIsUnderlineTextDecorationSet = false;
    protected boolean mIsLineThroughTextDecorationSet = false;
    protected boolean mIncludeFontPadding = true;
    @Nullable
    protected ReactAccessibilityDelegate.AccessibilityRole mAccessibilityRole = null;
    @Nullable
    protected ReactAccessibilityDelegate.Role mRole = null;
    protected int mFontStyle = -1;
    protected int mFontWeight = -1;
    @Nullable
    protected String mFontFamily = null;
    @Nullable
    protected String mFontFeatureSettings = null;
    protected boolean mContainsImages = false;
    protected float mHeightOfTallestInlineImage = Float.NaN;

    private TextAttributeProps() {
    }

    public static TextAttributeProps fromMapBuffer(MapBuffer props) {
        TextAttributeProps result = new TextAttributeProps();
        for (MapBuffer.Entry entry : props) {
            switch (entry.getKey()) {
                case 0: {
                    result.setColor(entry.getIntValue());
                    break;
                }
                case 1: {
                    result.setBackgroundColor(entry.getIntValue());
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    result.setFontFamily(entry.getStringValue());
                    break;
                }
                case 4: {
                    result.setFontSize((float)entry.getDoubleValue());
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    result.setFontWeight(entry.getStringValue());
                    break;
                }
                case 7: {
                    result.setFontStyle(entry.getStringValue());
                    break;
                }
                case 8: {
                    result.setFontVariant(entry.getMapBufferValue());
                    break;
                }
                case 9: {
                    result.setAllowFontScaling(entry.getBooleanValue());
                    break;
                }
                case 10: {
                    result.setLetterSpacing((float)entry.getDoubleValue());
                    break;
                }
                case 11: {
                    result.setLineHeight((float)entry.getDoubleValue());
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    break;
                }
                case 15: {
                    result.setTextDecorationLine(entry.getStringValue());
                    break;
                }
                case 16: {
                    break;
                }
                case 18: {
                    result.setTextShadowRadius((float)entry.getDoubleValue());
                    break;
                }
                case 19: {
                    result.setTextShadowColor(entry.getIntValue());
                    break;
                }
                case 20: {
                    result.setTextShadowOffsetDx((float)entry.getDoubleValue());
                    break;
                }
                case 21: {
                    result.setTextShadowOffsetDy((float)entry.getDoubleValue());
                    break;
                }
                case 22: {
                    break;
                }
                case 23: {
                    result.setLayoutDirection(entry.getStringValue());
                    break;
                }
                case 24: {
                    result.setAccessibilityRole(entry.getStringValue());
                    break;
                }
                case 26: {
                    result.setRole(ReactAccessibilityDelegate.Role.values()[entry.getIntValue()]);
                    break;
                }
                case 27: {
                    result.setTextTransform(entry.getStringValue());
                }
            }
        }
        return result;
    }

    public static TextAttributeProps fromReadableMap(ReactStylesDiffMap props) {
        TextAttributeProps result = new TextAttributeProps();
        result.setNumberOfLines(TextAttributeProps.getIntProp(props, "numberOfLines", -1));
        result.setLineHeight(TextAttributeProps.getFloatProp(props, "lineHeight", -1.0f));
        result.setLetterSpacing(TextAttributeProps.getFloatProp(props, "letterSpacing", Float.NaN));
        result.setAllowFontScaling(TextAttributeProps.getBooleanProp(props, "allowFontScaling", true));
        result.setFontSize(TextAttributeProps.getFloatProp(props, "fontSize", -1.0f));
        result.setColor(props.hasKey("color") ? Integer.valueOf(props.getInt("color", 0)) : null);
        result.setColor(props.hasKey("foregroundColor") ? Integer.valueOf(props.getInt("foregroundColor", 0)) : null);
        result.setBackgroundColor(props.hasKey("backgroundColor") ? Integer.valueOf(props.getInt("backgroundColor", 0)) : null);
        result.setFontFamily(TextAttributeProps.getStringProp(props, "fontFamily"));
        result.setFontWeight(TextAttributeProps.getStringProp(props, "fontWeight"));
        result.setFontStyle(TextAttributeProps.getStringProp(props, "fontStyle"));
        result.setFontVariant(TextAttributeProps.getArrayProp(props, "fontVariant"));
        result.setIncludeFontPadding(TextAttributeProps.getBooleanProp(props, "includeFontPadding", true));
        result.setTextDecorationLine(TextAttributeProps.getStringProp(props, "textDecorationLine"));
        result.setTextShadowOffset(props.hasKey(PROP_SHADOW_OFFSET) ? props.getMap(PROP_SHADOW_OFFSET) : null);
        result.setTextShadowRadius(TextAttributeProps.getFloatProp(props, PROP_SHADOW_RADIUS, 1.0f));
        result.setTextShadowColor(TextAttributeProps.getIntProp(props, PROP_SHADOW_COLOR, 0x55000000));
        result.setTextTransform(TextAttributeProps.getStringProp(props, PROP_TEXT_TRANSFORM));
        result.setLayoutDirection(TextAttributeProps.getStringProp(props, "layoutDirection"));
        result.setAccessibilityRole(TextAttributeProps.getStringProp(props, "accessibilityRole"));
        result.setRole(TextAttributeProps.getStringProp(props, "role"));
        return result;
    }

    public static int getTextAlignment(ReactStylesDiffMap props, boolean isRTL, int defaultValue) {
        if (!props.hasKey("textAlign")) {
            return defaultValue;
        }
        String textAlignPropValue = props.getString("textAlign");
        if ("justify".equals(textAlignPropValue)) {
            return 3;
        }
        if (textAlignPropValue == null || "auto".equals(textAlignPropValue)) {
            return 0;
        }
        if ("left".equals(textAlignPropValue)) {
            return isRTL ? 5 : 3;
        }
        if ("right".equals(textAlignPropValue)) {
            return isRTL ? 3 : 5;
        }
        if ("center".equals(textAlignPropValue)) {
            return 1;
        }
        FLog.w((String)"ReactNative", (String)("Invalid textAlign: " + textAlignPropValue));
        return 0;
    }

    public static int getJustificationMode(ReactStylesDiffMap props, int defaultValue) {
        if (!props.hasKey("textAlign")) {
            return defaultValue;
        }
        String textAlignPropValue = props.getString("textAlign");
        if ("justify".equals(textAlignPropValue) && Build.VERSION.SDK_INT >= 26) {
            return 1;
        }
        return DEFAULT_JUSTIFICATION_MODE;
    }

    private static boolean getBooleanProp(ReactStylesDiffMap mProps, String name, boolean defaultValue) {
        if (mProps.hasKey(name)) {
            return mProps.getBoolean(name, defaultValue);
        }
        return defaultValue;
    }

    private static String getStringProp(ReactStylesDiffMap mProps, String name) {
        if (mProps.hasKey(name)) {
            return mProps.getString(name);
        }
        return null;
    }

    private static int getIntProp(ReactStylesDiffMap mProps, String name, int defaultvalue) {
        if (mProps.hasKey(name)) {
            return mProps.getInt(name, defaultvalue);
        }
        return defaultvalue;
    }

    private static float getFloatProp(ReactStylesDiffMap mProps, String name, float defaultvalue) {
        if (mProps.hasKey(name)) {
            return mProps.getFloat(name, defaultvalue);
        }
        return defaultvalue;
    }

    @Nullable
    private static ReadableArray getArrayProp(ReactStylesDiffMap mProps, String name) {
        if (mProps.hasKey(name)) {
            return mProps.getArray(name);
        }
        return null;
    }

    @Override
    public float getEffectiveLineHeight() {
        boolean useInlineViewHeight = !Float.isNaN(this.mLineHeight) && !Float.isNaN(this.mHeightOfTallestInlineImage) && this.mHeightOfTallestInlineImage > this.mLineHeight;
        return useInlineViewHeight ? this.mHeightOfTallestInlineImage : this.mLineHeight;
    }

    private void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines == 0 ? -1 : numberOfLines;
    }

    private void setLineHeight(float lineHeight) {
        this.mLineHeightInput = lineHeight;
        this.mLineHeight = lineHeight == -1.0f ? Float.NaN : (this.mAllowFontScaling ? PixelUtil.toPixelFromSP(lineHeight) : PixelUtil.toPixelFromDIP(lineHeight));
    }

    private void setLetterSpacing(float letterSpacing) {
        this.mLetterSpacingInput = letterSpacing;
    }

    @Override
    @NonNull
    public TextTransform getTextTransform() {
        return this.mTextTransform;
    }

    public float getLetterSpacing() {
        float letterSpacingPixels;
        float f = letterSpacingPixels = this.mAllowFontScaling ? PixelUtil.toPixelFromSP(this.mLetterSpacingInput) : PixelUtil.toPixelFromDIP(this.mLetterSpacingInput);
        if (this.mFontSize <= 0) {
            throw new IllegalArgumentException("FontSize should be a positive value. Current value: " + this.mFontSize);
        }
        return letterSpacingPixels / (float)this.mFontSize;
    }

    @Override
    public float getEffectiveLetterSpacing() {
        return this.getLetterSpacing();
    }

    @Override
    public int getEffectiveFontSize() {
        return this.mFontSize;
    }

    private void setAllowFontScaling(boolean allowFontScaling) {
        if (allowFontScaling != this.mAllowFontScaling) {
            this.mAllowFontScaling = allowFontScaling;
            this.setFontSize(this.mFontSizeInput);
            this.setLineHeight(this.mLineHeightInput);
            this.setLetterSpacing(this.mLetterSpacingInput);
        }
    }

    private void setFontSize(float fontSize) {
        this.mFontSizeInput = fontSize;
        if (fontSize != -1.0f) {
            fontSize = this.mAllowFontScaling ? (float)Math.ceil(PixelUtil.toPixelFromSP(fontSize)) : (float)Math.ceil(PixelUtil.toPixelFromDIP(fontSize));
        }
        this.mFontSize = (int)fontSize;
    }

    @Override
    public int getColor() {
        return this.mColor;
    }

    private void setColor(@Nullable Integer color) {
        boolean bl = this.mIsColorSet = color != null;
        if (this.mIsColorSet) {
            this.mColor = color;
        }
    }

    @Override
    public boolean isColorSet() {
        return this.mIsColorSet;
    }

    @Override
    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    private void setBackgroundColor(Integer color) {
        boolean bl = this.mIsBackgroundColorSet = color != null;
        if (this.mIsBackgroundColorSet) {
            this.mBackgroundColor = color;
        }
    }

    @Override
    public boolean isBackgroundColorSet() {
        return this.mIsBackgroundColorSet;
    }

    @Override
    public int getFontStyle() {
        return this.mFontStyle;
    }

    @Override
    public String getFontFamily() {
        return this.mFontFamily;
    }

    private void setFontFamily(@Nullable String fontFamily) {
        this.mFontFamily = fontFamily;
    }

    private void setFontVariant(@Nullable ReadableArray fontVariant) {
        this.mFontFeatureSettings = ReactTypefaceUtils.parseFontVariant(fontVariant);
    }

    private void setFontVariant(@Nullable MapBuffer fontVariant) {
        if (fontVariant == null || fontVariant.getCount() == 0) {
            this.mFontFeatureSettings = null;
            return;
        }
        ArrayList<String> features = new ArrayList<String>();
        for (MapBuffer.Entry entry : fontVariant) {
            String value = entry.getStringValue();
            if (value == null) continue;
            switch (value) {
                case "small-caps": {
                    features.add("'smcp'");
                    break;
                }
                case "oldstyle-nums": {
                    features.add("'onum'");
                    break;
                }
                case "lining-nums": {
                    features.add("'lnum'");
                    break;
                }
                case "tabular-nums": {
                    features.add("'tnum'");
                    break;
                }
                case "proportional-nums": {
                    features.add("'pnum'");
                    break;
                }
                case "stylistic-one": {
                    features.add("'ss01'");
                    break;
                }
                case "stylistic-two": {
                    features.add("'ss02'");
                    break;
                }
                case "stylistic-three": {
                    features.add("'ss03'");
                    break;
                }
                case "stylistic-four": {
                    features.add("'ss04'");
                    break;
                }
                case "stylistic-five": {
                    features.add("'ss05'");
                    break;
                }
                case "stylistic-six": {
                    features.add("'ss06'");
                    break;
                }
                case "stylistic-seven": {
                    features.add("'ss07'");
                    break;
                }
                case "stylistic-eight": {
                    features.add("'ss08'");
                    break;
                }
                case "stylistic-nine": {
                    features.add("'ss09'");
                    break;
                }
                case "stylistic-ten": {
                    features.add("'ss10'");
                    break;
                }
                case "stylistic-eleven": {
                    features.add("'ss11'");
                    break;
                }
                case "stylistic-twelve": {
                    features.add("'ss12'");
                    break;
                }
                case "stylistic-thirteen": {
                    features.add("'ss13'");
                    break;
                }
                case "stylistic-fourteen": {
                    features.add("'ss14'");
                    break;
                }
                case "stylistic-fifteen": {
                    features.add("'ss15'");
                    break;
                }
                case "stylistic-sixteen": {
                    features.add("'ss16'");
                    break;
                }
                case "stylistic-seventeen": {
                    features.add("'ss17'");
                    break;
                }
                case "stylistic-eighteen": {
                    features.add("'ss18'");
                    break;
                }
                case "stylistic-nineteen": {
                    features.add("'ss19'");
                    break;
                }
                case "stylistic-twenty": {
                    features.add("'ss20'");
                }
            }
        }
        this.mFontFeatureSettings = TextUtils.join((CharSequence)", ", features);
    }

    @Override
    public String getFontFeatureSettings() {
        return this.mFontFeatureSettings;
    }

    @Override
    public int getFontWeight() {
        return this.mFontWeight;
    }

    private void setFontWeight(@Nullable String fontWeightString) {
        this.mFontWeight = ReactTypefaceUtils.parseFontWeight(fontWeightString);
    }

    private void setFontStyle(@Nullable String fontStyleString) {
        this.mFontStyle = ReactTypefaceUtils.parseFontStyle(fontStyleString);
    }

    private void setIncludeFontPadding(boolean includepad) {
        this.mIncludeFontPadding = includepad;
    }

    private void setTextDecorationLine(@Nullable String textDecorationLineString) {
        this.mIsUnderlineTextDecorationSet = false;
        this.mIsLineThroughTextDecorationSet = false;
        if (textDecorationLineString != null) {
            for (String textDecorationLineSubString : textDecorationLineString.split("-")) {
                if ("underline".equals(textDecorationLineSubString)) {
                    this.mIsUnderlineTextDecorationSet = true;
                    continue;
                }
                if (!"strikethrough".equals(textDecorationLineSubString)) continue;
                this.mIsLineThroughTextDecorationSet = true;
            }
        }
    }

    @Override
    public boolean isUnderlineTextDecorationSet() {
        return this.mIsUnderlineTextDecorationSet;
    }

    @Override
    public boolean isLineThroughTextDecorationSet() {
        return this.mIsLineThroughTextDecorationSet;
    }

    private void setTextShadowOffset(ReadableMap offsetMap) {
        this.mTextShadowOffsetDx = 0.0f;
        this.mTextShadowOffsetDy = 0.0f;
        if (offsetMap != null) {
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_WIDTH) && !offsetMap.isNull(PROP_SHADOW_OFFSET_WIDTH)) {
                this.mTextShadowOffsetDx = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_WIDTH));
            }
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_HEIGHT) && !offsetMap.isNull(PROP_SHADOW_OFFSET_HEIGHT)) {
                this.mTextShadowOffsetDy = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_HEIGHT));
            }
        }
    }

    @Override
    public float getTextShadowOffsetDx() {
        return this.mTextShadowOffsetDx;
    }

    private void setTextShadowOffsetDx(float dx) {
        this.mTextShadowOffsetDx = PixelUtil.toPixelFromDIP(dx);
    }

    @Override
    public float getTextShadowOffsetDy() {
        return this.mTextShadowOffsetDy;
    }

    private void setTextShadowOffsetDy(float dy) {
        this.mTextShadowOffsetDy = PixelUtil.toPixelFromDIP(dy);
    }

    public static int getLayoutDirection(@Nullable String layoutDirection) {
        int androidLayoutDirection;
        if (layoutDirection == null || "undefined".equals(layoutDirection)) {
            androidLayoutDirection = -1;
        } else if ("rtl".equals(layoutDirection)) {
            androidLayoutDirection = 1;
        } else if ("ltr".equals(layoutDirection)) {
            androidLayoutDirection = 0;
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid layoutDirection: " + layoutDirection));
            androidLayoutDirection = -1;
        }
        return androidLayoutDirection;
    }

    private void setLayoutDirection(@Nullable String layoutDirection) {
        this.mLayoutDirection = TextAttributeProps.getLayoutDirection(layoutDirection);
    }

    @Override
    public float getTextShadowRadius() {
        return this.mTextShadowRadius;
    }

    private void setTextShadowRadius(float textShadowRadius) {
        if (textShadowRadius != this.mTextShadowRadius) {
            this.mTextShadowRadius = textShadowRadius;
        }
    }

    @Override
    public int getTextShadowColor() {
        return this.mTextShadowColor;
    }

    private void setTextShadowColor(int textShadowColor) {
        if (textShadowColor != this.mTextShadowColor) {
            this.mTextShadowColor = textShadowColor;
        }
    }

    private void setTextTransform(@Nullable String textTransform) {
        if (textTransform == null || "none".equals(textTransform)) {
            this.mTextTransform = TextTransform.NONE;
        } else if ("uppercase".equals(textTransform)) {
            this.mTextTransform = TextTransform.UPPERCASE;
        } else if ("lowercase".equals(textTransform)) {
            this.mTextTransform = TextTransform.LOWERCASE;
        } else if ("capitalize".equals(textTransform)) {
            this.mTextTransform = TextTransform.CAPITALIZE;
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid textTransform: " + textTransform));
            this.mTextTransform = TextTransform.NONE;
        }
    }

    @Override
    public ReactAccessibilityDelegate.AccessibilityRole getAccessibilityRole() {
        return this.mAccessibilityRole;
    }

    private void setAccessibilityRole(@Nullable String accessibilityRole) {
        this.mAccessibilityRole = accessibilityRole == null ? null : ReactAccessibilityDelegate.AccessibilityRole.fromValue(accessibilityRole);
    }

    @Override
    @Nullable
    public ReactAccessibilityDelegate.Role getRole() {
        return this.mRole;
    }

    private void setRole(@Nullable String role) {
        this.mRole = role == null ? null : ReactAccessibilityDelegate.Role.fromValue(role);
    }

    private void setRole(ReactAccessibilityDelegate.Role role) {
        this.mRole = role;
    }

    public static int getTextBreakStrategy(@Nullable String textBreakStrategy) {
        int androidTextBreakStrategy = 1;
        if (textBreakStrategy != null) {
            switch (textBreakStrategy) {
                case "simple": {
                    androidTextBreakStrategy = 0;
                    break;
                }
                case "balanced": {
                    androidTextBreakStrategy = 2;
                    break;
                }
                default: {
                    androidTextBreakStrategy = 1;
                }
            }
        }
        return androidTextBreakStrategy;
    }

    public static int getHyphenationFrequency(@Nullable String hyphenationFrequency) {
        int androidHyphenationFrequency = 0;
        if (hyphenationFrequency != null) {
            switch (hyphenationFrequency) {
                case "none": {
                    androidHyphenationFrequency = 0;
                    break;
                }
                case "normal": {
                    androidHyphenationFrequency = 1;
                    break;
                }
                default: {
                    androidHyphenationFrequency = 2;
                }
            }
        }
        return androidHyphenationFrequency;
    }
}

