/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ColorUtil {
    public static int multiplyColorAlpha(int color, int alpha) {
        if (alpha == 255) {
            return color;
        }
        if (alpha == 0) {
            return color & 0xFFFFFF;
        }
        alpha += alpha >> 7;
        int colorAlpha = color >>> 24;
        int multipliedAlpha = colorAlpha * alpha >> 8;
        return multipliedAlpha << 24 | color & 0xFFFFFF;
    }

    public static int getOpacityFromColor(int color) {
        int colorAlpha = color >>> 24;
        if (colorAlpha == 255) {
            return -1;
        }
        if (colorAlpha == 0) {
            return -2;
        }
        return -3;
    }

    public static int normalize(double r, double g, double b, double a) {
        return ColorUtil.clamp255(a * 255.0) << 24 | ColorUtil.clamp255(r) << 16 | ColorUtil.clamp255(g) << 8 | ColorUtil.clamp255(b);
    }

    private static int clamp255(double value) {
        return Math.max(0, Math.min(255, (int)Math.round(value)));
    }
}

