/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.List;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
abstract class AnimatedNode {
    public static final int INITIAL_BFS_COLOR = 0;
    private static final int DEFAULT_ANIMATED_NODE_CHILD_COUNT = 1;
    @Nullable
    List<AnimatedNode> mChildren;
    int mActiveIncomingNodes = 0;
    int mBFSColor = 0;
    int mTag = -1;

    AnimatedNode() {
    }

    public final void addChild(AnimatedNode child) {
        if (this.mChildren == null) {
            this.mChildren = new ArrayList<AnimatedNode>(1);
        }
        ((List)Assertions.assertNotNull(this.mChildren)).add(child);
        child.onAttachedToNode(this);
    }

    public final void removeChild(AnimatedNode child) {
        if (this.mChildren == null) {
            return;
        }
        child.onDetachedFromNode(this);
        this.mChildren.remove(child);
    }

    public void onAttachedToNode(AnimatedNode parent) {
    }

    public void onDetachedFromNode(AnimatedNode parent) {
    }

    public void update() {
    }

    public abstract String prettyPrint();

    public String prettyPrintWithChildren() {
        String children = "";
        if (this.mChildren != null && this.mChildren.size() > 0) {
            for (AnimatedNode child : this.mChildren) {
                children = children + " " + child.mTag;
            }
        }
        return this.prettyPrint() + (children.length() > 0 ? " children: " + children : "");
    }
}

