/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;

public class UiThreadUtil {
    @Nullable
    private static volatile Handler sMainHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Handler getUiThreadHandler() {
        if (sMainHandler != null) return sMainHandler;
        Class<UiThreadUtil> clazz = UiThreadUtil.class;
        synchronized (UiThreadUtil.class) {
            if (sMainHandler != null) return sMainHandler;
            sMainHandler = new Handler(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sMainHandler;
        }
    }

    public static boolean isOnUiThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static void assertOnUiThread() {
    }

    public static void assertNotOnUiThread() {
    }

    public static boolean runOnUiThread(Runnable runnable) {
        return UiThreadUtil.getUiThreadHandler().postDelayed(runnable, 0L);
    }

    public static boolean runOnUiThread(Runnable runnable, long delayInMs) {
        return UiThreadUtil.getUiThreadHandler().postDelayed(runnable, delayInMs);
    }

    public static void removeOnUiThread(Runnable runnable) {
        UiThreadUtil.getUiThreadHandler().removeCallbacks(runnable);
    }
}

