/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.react.views.scroll.ScrollEvent;
import com.facebook.react.views.scroll.ScrollEventType;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.ReactTypefaceUtils;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.react.views.text.TextLayoutManagerMapBuffer;
import com.facebook.react.views.text.TextTransform;
import com.facebook.react.views.text.internal.span.TextInlineImageSpan;
import com.facebook.react.views.textinput.ContentSizeWatcher;
import com.facebook.react.views.textinput.ReactContentSizeChangedEvent;
import com.facebook.react.views.textinput.ReactEditText;
import com.facebook.react.views.textinput.ReactTextChangedEvent;
import com.facebook.react.views.textinput.ReactTextInputBlurEvent;
import com.facebook.react.views.textinput.ReactTextInputEndEditingEvent;
import com.facebook.react.views.textinput.ReactTextInputFocusEvent;
import com.facebook.react.views.textinput.ReactTextInputSelectionEvent;
import com.facebook.react.views.textinput.ReactTextInputShadowNode;
import com.facebook.react.views.textinput.ReactTextInputSubmitEditingEvent;
import com.facebook.react.views.textinput.ScrollWatcher;
import com.facebook.react.views.textinput.SelectionWatcher;
import com.facebook.yoga.YogaConstants;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

@ReactModule(name="AndroidTextInput")
public class ReactTextInputManager
extends BaseViewManager<ReactEditText, LayoutShadowNode> {
    public static final String TAG = ReactTextInputManager.class.getSimpleName();
    public static final String REACT_CLASS = "AndroidTextInput";
    private static final short TX_STATE_KEY_ATTRIBUTED_STRING = 0;
    private static final short TX_STATE_KEY_PARAGRAPH_ATTRIBUTES = 1;
    private static final short TX_STATE_KEY_HASH = 2;
    private static final short TX_STATE_KEY_MOST_RECENT_EVENT_COUNT = 3;
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3};
    private static final Map<String, String> REACT_PROPS_AUTOFILL_HINTS_MAP = new HashMap<String, String>(){
        {
            this.put("birthdate-day", "birthDateDay");
            this.put("birthdate-full", "birthDateFull");
            this.put("birthdate-month", "birthDateMonth");
            this.put("birthdate-year", "birthDateYear");
            this.put("cc-csc", "creditCardSecurityCode");
            this.put("cc-exp", "creditCardExpirationDate");
            this.put("cc-exp-day", "creditCardExpirationDay");
            this.put("cc-exp-month", "creditCardExpirationMonth");
            this.put("cc-exp-year", "creditCardExpirationYear");
            this.put("cc-number", "creditCardNumber");
            this.put("email", "emailAddress");
            this.put("gender", "gender");
            this.put("name", "personName");
            this.put("name-family", "personFamilyName");
            this.put("name-given", "personGivenName");
            this.put("name-middle", "personMiddleName");
            this.put("name-middle-initial", "personMiddleInitial");
            this.put("name-prefix", "personNamePrefix");
            this.put("name-suffix", "personNameSuffix");
            this.put("password", "password");
            this.put("password-new", "newPassword");
            this.put("postal-address", "postalAddress");
            this.put("postal-address-country", "addressCountry");
            this.put("postal-address-extended", "extendedAddress");
            this.put("postal-address-extended-postal-code", "extendedPostalCode");
            this.put("postal-address-locality", "addressLocality");
            this.put("postal-address-region", "addressRegion");
            this.put("postal-code", "postalCode");
            this.put("street-address", "streetAddress");
            this.put("sms-otp", "smsOTPCode");
            this.put("tel", "phoneNumber");
            this.put("tel-country-code", "phoneCountryCode");
            this.put("tel-national", "phoneNational");
            this.put("tel-device", "phoneNumberDevice");
            this.put("username", "username");
            this.put("username-new", "newUsername");
        }
    };
    private static final int FOCUS_TEXT_INPUT = 1;
    private static final int BLUR_TEXT_INPUT = 2;
    private static final int SET_MOST_RECENT_EVENT_COUNT = 3;
    private static final int SET_TEXT_AND_SELECTION = 4;
    private static final int INPUT_TYPE_KEYBOARD_NUMBER_PAD = 2;
    private static final int INPUT_TYPE_KEYBOARD_DECIMAL_PAD = 8194;
    private static final int INPUT_TYPE_KEYBOARD_NUMBERED = 12290;
    private static final int PASSWORD_VISIBILITY_FLAG = 16;
    private static final int AUTOCAPITALIZE_FLAGS = 28672;
    private static final String KEYBOARD_TYPE_EMAIL_ADDRESS = "email-address";
    private static final String KEYBOARD_TYPE_NUMERIC = "numeric";
    private static final String KEYBOARD_TYPE_DECIMAL_PAD = "decimal-pad";
    private static final String KEYBOARD_TYPE_NUMBER_PAD = "number-pad";
    private static final String KEYBOARD_TYPE_PHONE_PAD = "phone-pad";
    private static final String KEYBOARD_TYPE_VISIBLE_PASSWORD = "visible-password";
    private static final String KEYBOARD_TYPE_URI = "url";
    private static final InputFilter[] EMPTY_FILTERS = new InputFilter[0];
    private static final int UNSET = -1;
    private static final String[] DRAWABLE_HANDLE_RESOURCES = new String[]{"mTextSelectHandleLeftRes", "mTextSelectHandleRightRes", "mTextSelectHandleRes"};
    private static final String[] DRAWABLE_HANDLE_FIELDS = new String[]{"mSelectHandleLeft", "mSelectHandleRight", "mSelectHandleCenter"};
    @Nullable
    protected ReactTextViewManagerCallback mReactTextViewManagerCallback;
    private static final int IME_ACTION_ID = 1648;

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactEditText createViewInstance(ThemedReactContext context) {
        ReactEditText editText = new ReactEditText((Context)context);
        int inputType = editText.getInputType();
        editText.setInputType(inputType & 0xFFFDFFFF);
        editText.setReturnKeyType("done");
        editText.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        return editText;
    }

    @Override
    public ReactBaseTextShadowNode createShadowNodeInstance() {
        return new ReactTextInputShadowNode();
    }

    public ReactBaseTextShadowNode createShadowNodeInstance(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        return new ReactTextInputShadowNode(reactTextViewManagerCallback);
    }

    @Override
    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return ReactTextInputShadowNode.class;
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        HashMap<String, Object> baseEventTypeConstants = super.getExportedCustomBubblingEventTypeConstants();
        HashMap<String, Object> eventTypeConstants = baseEventTypeConstants == null ? new HashMap<String, Object>() : baseEventTypeConstants;
        eventTypeConstants.putAll(MapBuilder.builder().put("topSubmitEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onSubmitEditing", "captured", "onSubmitEditingCapture"))).put("topEndEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onEndEditing", "captured", "onEndEditingCapture"))).put("topTextInput", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTextInput", "captured", "onTextInputCapture"))).put("topFocus", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onFocus", "captured", "onFocusCapture"))).put("topBlur", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onBlur", "captured", "onBlurCapture"))).put("topKeyPress", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onKeyPress", "captured", "onKeyPressCapture"))).build());
        return eventTypeConstants;
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        HashMap<String, Object> baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        HashMap<String, Object> eventTypeConstants = baseEventTypeConstants == null ? new HashMap<String, Object>() : baseEventTypeConstants;
        eventTypeConstants.putAll(MapBuilder.builder().put(ScrollEventType.getJSEventName(ScrollEventType.SCROLL), MapBuilder.of("registrationName", "onScroll")).build());
        return eventTypeConstants;
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("focusTextInput", 1, "blurTextInput", 2);
    }

    @Override
    public void receiveCommand(ReactEditText reactEditText, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                this.receiveCommand(reactEditText, "focus", args);
                break;
            }
            case 2: {
                this.receiveCommand(reactEditText, "blur", args);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.receiveCommand(reactEditText, "setTextAndSelection", args);
            }
        }
    }

    @Override
    public void receiveCommand(ReactEditText reactEditText, String commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case "focus": 
            case "focusTextInput": {
                reactEditText.requestFocusFromJS();
                break;
            }
            case "blur": 
            case "blurTextInput": {
                reactEditText.clearFocusFromJS();
                break;
            }
            case "setTextAndSelection": {
                int mostRecentEventCount = args.getInt(0);
                if (mostRecentEventCount == -1) {
                    return;
                }
                int start = args.getInt(2);
                int end = args.getInt(3);
                if (end == -1) {
                    end = start;
                }
                if (!args.isNull(1)) {
                    String text = args.getString(1);
                    reactEditText.maybeSetTextFromJS(this.getReactTextUpdate(text, mostRecentEventCount));
                }
                reactEditText.maybeSetSelection(mostRecentEventCount, start, end);
            }
        }
    }

    private ReactTextUpdate getReactTextUpdate(String text, int mostRecentEventCount) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        sb.append((CharSequence)TextTransform.apply(text, TextTransform.UNSET));
        return new ReactTextUpdate((Spannable)sb, mostRecentEventCount, false, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 0);
    }

    @Override
    public void updateExtraData(ReactEditText view, Object extraData) {
        if (extraData instanceof ReactTextUpdate) {
            ReactTextUpdate update = (ReactTextUpdate)extraData;
            int paddingLeft = (int)update.getPaddingLeft();
            int paddingTop = (int)update.getPaddingTop();
            int paddingRight = (int)update.getPaddingRight();
            int paddingBottom = (int)update.getPaddingBottom();
            if (paddingLeft != -1 || paddingTop != -1 || paddingRight != -1 || paddingBottom != -1) {
                view.setPadding(paddingLeft != -1 ? paddingLeft : view.getPaddingLeft(), paddingTop != -1 ? paddingTop : view.getPaddingTop(), paddingRight != -1 ? paddingRight : view.getPaddingRight(), paddingBottom != -1 ? paddingBottom : view.getPaddingBottom());
            }
            if (update.containsImages()) {
                Spannable spannable = update.getText();
                TextInlineImageSpan.possiblyUpdateInlineImageSpans(spannable, (TextView)view);
            }
            boolean isCurrentSelectionEmpty = view.getSelectionStart() == view.getSelectionEnd();
            int selectionStart = -1;
            int selectionEnd = -1;
            if (isCurrentSelectionEmpty) {
                int textLength = view.getText() == null ? 0 : view.getText().length();
                int selectionOffset = textLength - view.getSelectionStart();
                selectionEnd = selectionStart = update.getText().length() - selectionOffset;
            }
            view.maybeSetTextFromState(update);
            view.maybeSetSelection(update.getJsEventCounter(), selectionStart, selectionEnd);
        }
    }

    @ReactProp(name="lineHeight", defaultFloat=0.0f)
    public void setLineHeight(ReactEditText view, int lineHeight) {
        view.setLineHeight(lineHeight);
    }

    @ReactProp(name="fontSize", defaultFloat=14.0f)
    public void setFontSize(ReactEditText view, float fontSize) {
        view.setFontSize(fontSize);
    }

    @ReactProp(name="fontFamily")
    public void setFontFamily(ReactEditText view, String fontFamily) {
        view.setFontFamily(fontFamily);
    }

    @ReactProp(name="maxFontSizeMultiplier", defaultFloat=NaNf)
    public void setMaxFontSizeMultiplier(ReactEditText view, float maxFontSizeMultiplier) {
        view.setMaxFontSizeMultiplier(maxFontSizeMultiplier);
    }

    @ReactProp(name="fontWeight")
    public void setFontWeight(ReactEditText view, @Nullable String fontWeight) {
        view.setFontWeight(fontWeight);
    }

    @ReactProp(name="fontStyle")
    public void setFontStyle(ReactEditText view, @Nullable String fontStyle) {
        view.setFontStyle(fontStyle);
    }

    @ReactProp(name="fontVariant")
    public void setFontVariant(ReactEditText view, @Nullable ReadableArray fontVariant) {
        view.setFontFeatureSettings(ReactTypefaceUtils.parseFontVariant(fontVariant));
    }

    @ReactProp(name="includeFontPadding", defaultBoolean=true)
    public void setIncludeFontPadding(ReactEditText view, boolean includepad) {
        view.setIncludeFontPadding(includepad);
    }

    @ReactProp(name="importantForAutofill")
    public void setImportantForAutofill(ReactEditText view, @Nullable String value) {
        int mode = 0;
        if ("no".equals(value)) {
            mode = 2;
        } else if ("noExcludeDescendants".equals(value)) {
            mode = 8;
        } else if ("yes".equals(value)) {
            mode = 1;
        } else if ("yesExcludeDescendants".equals(value)) {
            mode = 4;
        }
        this.setImportantForAutofill(view, mode);
    }

    private void setImportantForAutofill(ReactEditText view, int mode) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        view.setImportantForAutofill(mode);
    }

    private void setAutofillHints(ReactEditText view, String ... hints) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        view.setAutofillHints(hints);
    }

    @ReactProp(name="onSelectionChange", defaultBoolean=false)
    public void setOnSelectionChange(ReactEditText view, boolean onSelectionChange) {
        if (onSelectionChange) {
            view.setSelectionWatcher(new ReactSelectionWatcher(view));
        } else {
            view.setSelectionWatcher(null);
        }
    }

    @ReactProp(name="submitBehavior")
    public void setSubmitBehavior(ReactEditText view, @Nullable String submitBehavior) {
        view.setSubmitBehavior(submitBehavior);
    }

    @ReactProp(name="onContentSizeChange", defaultBoolean=false)
    public void setOnContentSizeChange(ReactEditText view, boolean onContentSizeChange) {
        if (onContentSizeChange) {
            view.setContentSizeWatcher(new ReactContentSizeWatcher(view));
        } else {
            view.setContentSizeWatcher(null);
        }
    }

    @ReactProp(name="onScroll", defaultBoolean=false)
    public void setOnScroll(ReactEditText view, boolean onScroll) {
        if (onScroll) {
            view.setScrollWatcher(new ReactScrollWatcher(view));
        } else {
            view.setScrollWatcher(null);
        }
    }

    @ReactProp(name="onKeyPress", defaultBoolean=false)
    public void setOnKeyPress(ReactEditText view, boolean onKeyPress) {
        view.setOnKeyPress(onKeyPress);
    }

    @ReactProp(name="letterSpacing", defaultFloat=0.0f)
    public void setLetterSpacing(ReactEditText view, float letterSpacing) {
        view.setLetterSpacingPt(letterSpacing);
    }

    @ReactProp(name="allowFontScaling", defaultBoolean=true)
    public void setAllowFontScaling(ReactEditText view, boolean allowFontScaling) {
        view.setAllowFontScaling(allowFontScaling);
    }

    @ReactProp(name="placeholder")
    public void setPlaceholder(ReactEditText view, String placeholder) {
        view.setPlaceholder(placeholder);
    }

    @ReactProp(name="placeholderTextColor", customType="Color")
    public void setPlaceholderTextColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setHintTextColor(DefaultStyleValuesUtil.getDefaultTextColorHint(view.getContext()));
        } else {
            view.setHintTextColor(color);
        }
    }

    @ReactProp(name="selectionColor", customType="Color")
    public void setSelectionColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setHighlightColor(DefaultStyleValuesUtil.getDefaultTextColorHighlight(view.getContext()));
        } else {
            view.setHighlightColor(color);
        }
    }

    @ReactProp(name="selectionHandleColor", customType="Color")
    public void setSelectionHandleColor(ReactEditText view, @Nullable Integer color) {
        if (Build.VERSION.SDK_INT >= 29) {
            Drawable drawableCenter = view.getTextSelectHandle().mutate();
            Drawable drawableLeft = view.getTextSelectHandleLeft().mutate();
            Drawable drawableRight = view.getTextSelectHandleRight().mutate();
            if (color != null) {
                BlendModeColorFilter filter = new BlendModeColorFilter(color.intValue(), BlendMode.SRC_IN);
                drawableCenter.setColorFilter((ColorFilter)filter);
                drawableLeft.setColorFilter((ColorFilter)filter);
                drawableRight.setColorFilter((ColorFilter)filter);
            } else {
                drawableCenter.clearColorFilter();
                drawableLeft.clearColorFilter();
                drawableRight.clearColorFilter();
            }
            view.setTextSelectHandle(drawableCenter);
            view.setTextSelectHandleLeft(drawableLeft);
            view.setTextSelectHandleRight(drawableRight);
            return;
        }
        if (Build.VERSION.SDK_INT == 28) {
            return;
        }
        for (int i = 0; i < DRAWABLE_HANDLE_RESOURCES.length; ++i) {
            try {
                Field drawableResourceField = ((Object)((Object)view)).getClass().getDeclaredField(DRAWABLE_HANDLE_RESOURCES[i]);
                drawableResourceField.setAccessible(true);
                int resourceId = drawableResourceField.getInt((Object)view);
                if (resourceId == 0) {
                    return;
                }
                Drawable drawable = ContextCompat.getDrawable((Context)view.getContext(), (int)resourceId).mutate();
                if (color != null) {
                    drawable.setColorFilter(color.intValue(), PorterDuff.Mode.SRC_IN);
                } else {
                    drawable.clearColorFilter();
                }
                Field editorField = TextView.class.getDeclaredField("mEditor");
                editorField.setAccessible(true);
                Object editor = editorField.get((Object)view);
                Field cursorDrawableField = editor.getClass().getDeclaredField(DRAWABLE_HANDLE_FIELDS[i]);
                cursorDrawableField.setAccessible(true);
                cursorDrawableField.set(editor, drawable);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @ReactProp(name="cursorColor", customType="Color")
    public void setCursorColor(ReactEditText view, @Nullable Integer color) {
        if (Build.VERSION.SDK_INT >= 29) {
            Drawable cursorDrawable = view.getTextCursorDrawable();
            if (cursorDrawable != null) {
                if (color != null) {
                    cursorDrawable.setColorFilter((ColorFilter)new BlendModeColorFilter(color.intValue(), BlendMode.SRC_IN));
                } else {
                    cursorDrawable.clearColorFilter();
                }
                view.setTextCursorDrawable(cursorDrawable);
            }
            return;
        }
        if (Build.VERSION.SDK_INT == 28) {
            return;
        }
        try {
            Field drawableCursorField = ((Object)((Object)view)).getClass().getDeclaredField("mCursorDrawableRes");
            drawableCursorField.setAccessible(true);
            int resourceId = drawableCursorField.getInt((Object)view);
            if (resourceId == 0) {
                return;
            }
            Drawable drawable = ContextCompat.getDrawable((Context)view.getContext(), (int)resourceId).mutate();
            if (color != null) {
                drawable.setColorFilter(color.intValue(), PorterDuff.Mode.SRC_IN);
            } else {
                drawable.clearColorFilter();
            }
            Field editorField = TextView.class.getDeclaredField("mEditor");
            editorField.setAccessible(true);
            Object editor = editorField.get((Object)view);
            Field cursorDrawableField = editor.getClass().getDeclaredField("mCursorDrawable");
            cursorDrawableField.setAccessible(true);
            Drawable[] drawables = new Drawable[]{drawable, drawable};
            cursorDrawableField.set(editor, drawables);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static boolean shouldHideCursorForEmailTextInput() {
        String manufacturer = Build.MANUFACTURER.toLowerCase(Locale.ROOT);
        return Build.VERSION.SDK_INT == 29 && manufacturer.contains("xiaomi");
    }

    @ReactProp(name="caretHidden", defaultBoolean=false)
    public void setCaretHidden(ReactEditText view, boolean caretHidden) {
        if (view.getStagedInputType() == 32 && ReactTextInputManager.shouldHideCursorForEmailTextInput()) {
            return;
        }
        view.setCursorVisible(!caretHidden);
    }

    @ReactProp(name="contextMenuHidden", defaultBoolean=false)
    public void setContextMenuHidden(ReactEditText view, boolean contextMenuHidden) {
        final boolean _contextMenuHidden = contextMenuHidden;
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return _contextMenuHidden;
            }
        });
    }

    @ReactProp(name="selectTextOnFocus", defaultBoolean=false)
    public void setSelectTextOnFocus(ReactEditText view, boolean selectTextOnFocus) {
        view.setSelectAllOnFocus(selectTextOnFocus);
    }

    @ReactProp(name="color", customType="Color")
    public void setColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            ColorStateList defaultContextTextColor = DefaultStyleValuesUtil.getDefaultTextColor(view.getContext());
            if (defaultContextTextColor != null) {
                view.setTextColor(defaultContextTextColor);
            } else {
                Context c = view.getContext();
                ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Could not get default text color from View Context: " + (c != null ? c.getClass().getCanonicalName() : "null")));
            }
        } else {
            view.setTextColor(color);
        }
    }

    @ReactProp(name="underlineColorAndroid", customType="Color")
    public void setUnderlineColor(ReactEditText view, @Nullable Integer underlineColor) {
        Drawable background;
        Drawable drawableToMutate = background = view.getBackground();
        if (background == null) {
            return;
        }
        if (background.getConstantState() != null) {
            try {
                drawableToMutate = background.mutate();
            }
            catch (NullPointerException e) {
                FLog.e((String)TAG, (String)"NullPointerException when setting underlineColorAndroid for TextInput", (Throwable)e);
            }
        }
        if (underlineColor == null) {
            drawableToMutate.clearColorFilter();
        } else if (Build.VERSION.SDK_INT == 21) {
            int bottomBorderColor = view.getBorderColor(3);
            this.setBorderColor(view, 4, underlineColor);
            drawableToMutate.setColorFilter(underlineColor.intValue(), PorterDuff.Mode.SRC_IN);
            this.setBorderColor(view, 4, bottomBorderColor);
        } else {
            drawableToMutate.setColorFilter(underlineColor.intValue(), PorterDuff.Mode.SRC_IN);
        }
    }

    @ReactProp(name="textAlign")
    public void setTextAlign(ReactEditText view, @Nullable String textAlign) {
        if ("justify".equals(textAlign)) {
            if (Build.VERSION.SDK_INT >= 26) {
                view.setJustificationMode(1);
            }
            view.setGravityHorizontal(3);
        } else {
            if (Build.VERSION.SDK_INT >= 26) {
                view.setJustificationMode(0);
            }
            if (textAlign == null || "auto".equals(textAlign)) {
                view.setGravityHorizontal(0);
            } else if ("left".equals(textAlign)) {
                view.setGravityHorizontal(3);
            } else if ("right".equals(textAlign)) {
                view.setGravityHorizontal(5);
            } else if ("center".equals(textAlign)) {
                view.setGravityHorizontal(1);
            } else {
                FLog.w((String)"ReactNative", (String)("Invalid textAlign: " + textAlign));
                view.setGravityHorizontal(0);
            }
        }
    }

    @ReactProp(name="textAlignVertical")
    public void setTextAlignVertical(ReactEditText view, @Nullable String textAlignVertical) {
        if (textAlignVertical == null || "auto".equals(textAlignVertical)) {
            view.setGravityVertical(0);
        } else if ("top".equals(textAlignVertical)) {
            view.setGravityVertical(48);
        } else if ("bottom".equals(textAlignVertical)) {
            view.setGravityVertical(80);
        } else if ("center".equals(textAlignVertical)) {
            view.setGravityVertical(16);
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid textAlignVertical: " + textAlignVertical));
            view.setGravityVertical(0);
        }
    }

    @ReactProp(name="inlineImageLeft")
    public void setInlineImageLeft(ReactEditText view, @Nullable String resource) {
        int id2 = ResourceDrawableIdHelper.getInstance().getResourceDrawableId(view.getContext(), resource);
        view.setCompoundDrawablesWithIntrinsicBounds(id2, 0, 0, 0);
    }

    @ReactProp(name="inlineImagePadding")
    public void setInlineImagePadding(ReactEditText view, int padding) {
        view.setCompoundDrawablePadding(padding);
    }

    @ReactProp(name="editable", defaultBoolean=true)
    public void setEditable(ReactEditText view, boolean editable) {
        view.setEnabled(editable);
    }

    @ReactProp(name="numberOfLines", defaultInt=1)
    public void setNumLines(ReactEditText view, int numLines) {
        view.setLines(numLines);
    }

    @ReactProp(name="maxLength")
    public void setMaxLength(ReactEditText view, @Nullable Integer maxLength) {
        InputFilter[] currentFilters = view.getFilters();
        InputFilter[] newFilters = EMPTY_FILTERS;
        if (maxLength == null) {
            if (currentFilters.length > 0) {
                LinkedList<InputFilter> list = new LinkedList<InputFilter>();
                for (InputFilter currentFilter : currentFilters) {
                    if (currentFilter instanceof InputFilter.LengthFilter) continue;
                    list.add(currentFilter);
                }
                if (!list.isEmpty()) {
                    newFilters = list.toArray(new InputFilter[list.size()]);
                }
            }
        } else if (currentFilters.length > 0) {
            newFilters = currentFilters;
            boolean replaced = false;
            for (int i = 0; i < currentFilters.length; ++i) {
                if (!(currentFilters[i] instanceof InputFilter.LengthFilter)) continue;
                currentFilters[i] = new InputFilter.LengthFilter(maxLength.intValue());
                replaced = true;
            }
            if (!replaced) {
                newFilters = new InputFilter[currentFilters.length + 1];
                System.arraycopy(currentFilters, 0, newFilters, 0, currentFilters.length);
                currentFilters[currentFilters.length] = new InputFilter.LengthFilter(maxLength.intValue());
            }
        } else {
            newFilters = new InputFilter[]{new InputFilter.LengthFilter(maxLength.intValue())};
        }
        view.setFilters(newFilters);
    }

    @ReactProp(name="autoComplete")
    public void setTextContentType(ReactEditText view, @Nullable String autoComplete) {
        if (autoComplete == null) {
            this.setImportantForAutofill(view, 2);
        } else if ("off".equals(autoComplete)) {
            this.setImportantForAutofill(view, 2);
        } else if (REACT_PROPS_AUTOFILL_HINTS_MAP.containsKey(autoComplete)) {
            this.setAutofillHints(view, REACT_PROPS_AUTOFILL_HINTS_MAP.get(autoComplete));
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid autoComplete: " + autoComplete));
            this.setImportantForAutofill(view, 2);
        }
    }

    @ReactProp(name="autoCorrect")
    public void setAutoCorrect(ReactEditText view, @Nullable Boolean autoCorrect) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, 557056, autoCorrect != null ? (autoCorrect.booleanValue() ? 32768 : 524288) : 0);
    }

    @ReactProp(name="multiline", defaultBoolean=false)
    public void setMultiline(ReactEditText view, boolean multiline) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, multiline ? 0 : 131072, multiline ? 131072 : 0);
    }

    @ReactProp(name="secureTextEntry", defaultBoolean=false)
    public void setSecureTextEntry(ReactEditText view, boolean password) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, password ? 144 : 144, password ? 128 : 0);
        ReactTextInputManager.checkPasswordType(view);
    }

    @ReactProp(name="autoCapitalize")
    public void setAutoCapitalize(ReactEditText view, Dynamic autoCapitalize) {
        int autoCapitalizeValue = 16384;
        if (autoCapitalize.getType() == ReadableType.Number) {
            autoCapitalizeValue = autoCapitalize.asInt();
        } else if (autoCapitalize.getType() == ReadableType.String) {
            String autoCapitalizeStr;
            switch (autoCapitalizeStr = autoCapitalize.asString()) {
                case "none": {
                    autoCapitalizeValue = 0;
                    break;
                }
                case "characters": {
                    autoCapitalizeValue = 4096;
                    break;
                }
                case "words": {
                    autoCapitalizeValue = 8192;
                    break;
                }
                case "sentences": {
                    autoCapitalizeValue = 16384;
                }
            }
        }
        ReactTextInputManager.updateStagedInputTypeFlag(view, 28672, autoCapitalizeValue);
    }

    @ReactProp(name="keyboardType")
    public void setKeyboardType(ReactEditText view, @Nullable String keyboardType) {
        int flagsToSet = 1;
        if (KEYBOARD_TYPE_NUMERIC.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 12290;
        } else if (KEYBOARD_TYPE_NUMBER_PAD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 2;
        } else if (KEYBOARD_TYPE_DECIMAL_PAD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 8194;
        } else if (KEYBOARD_TYPE_EMAIL_ADDRESS.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 33;
            if (ReactTextInputManager.shouldHideCursorForEmailTextInput()) {
                view.setCursorVisible(false);
            }
        } else if (KEYBOARD_TYPE_PHONE_PAD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 3;
        } else if (KEYBOARD_TYPE_VISIBLE_PASSWORD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 144;
        } else if (KEYBOARD_TYPE_URI.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 16;
        }
        ReactTextInputManager.updateStagedInputTypeFlag(view, 15, flagsToSet);
        ReactTextInputManager.checkPasswordType(view);
    }

    @ReactProp(name="returnKeyType")
    public void setReturnKeyType(ReactEditText view, String returnKeyType) {
        view.setReturnKeyType(returnKeyType);
    }

    @ReactProp(name="disableFullscreenUI", defaultBoolean=false)
    public void setDisableFullscreenUI(ReactEditText view, boolean disableFullscreenUI) {
        view.setDisableFullscreenUI(disableFullscreenUI);
    }

    @ReactProp(name="returnKeyLabel")
    public void setReturnKeyLabel(ReactEditText view, String returnKeyLabel) {
        view.setImeActionLabel(returnKeyLabel, 1648);
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public void setBorderRadius(ReactEditText view, int index, float borderRadius) {
        if (!YogaConstants.isUndefined(borderRadius)) {
            borderRadius = PixelUtil.toPixelFromDIP(borderRadius);
        }
        if (index == 0) {
            view.setBorderRadius(borderRadius);
        } else {
            view.setBorderRadius(borderRadius, index - 1);
        }
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(ReactEditText view, @Nullable String borderStyle) {
        view.setBorderStyle(borderStyle);
    }

    @ReactProp(name="showSoftInputOnFocus", defaultBoolean=true)
    public void showKeyboardOnFocus(ReactEditText view, boolean showKeyboardOnFocus) {
        view.setShowSoftInputOnFocus(showKeyboardOnFocus);
    }

    @ReactProp(name="autoFocus", defaultBoolean=false)
    public void setAutoFocus(ReactEditText view, boolean autoFocus) {
        view.setAutoFocus(autoFocus);
    }

    @ReactProp(name="textDecorationLine")
    public void setTextDecorationLine(ReactEditText view, @Nullable String textDecorationLineString) {
        view.setPaintFlags(view.getPaintFlags() & 0xFFFFFFE7);
        for (String token : textDecorationLineString.split(" ")) {
            if (token.equals("underline")) {
                view.setPaintFlags(view.getPaintFlags() | 8);
                continue;
            }
            if (!token.equals("line-through")) continue;
            view.setPaintFlags(view.getPaintFlags() | 0x10);
        }
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public void setBorderWidth(ReactEditText view, int index, float width) {
        if (!YogaConstants.isUndefined(width)) {
            width = PixelUtil.toPixelFromDIP(width);
        }
        view.setBorderWidth(SPACING_TYPES[index], width);
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public void setBorderColor(ReactEditText view, int index, Integer color) {
        float rgbComponent = color == null ? Float.NaN : (float)(color & 0xFFFFFF);
        float alphaComponent = color == null ? Float.NaN : (float)(color >>> 24);
        view.setBorderColor(SPACING_TYPES[index], rgbComponent, alphaComponent);
    }

    @Override
    protected void onAfterUpdateTransaction(ReactEditText view) {
        super.onAfterUpdateTransaction(view);
        view.maybeUpdateTypeface();
        view.commitStagedInputType();
    }

    private static void checkPasswordType(ReactEditText view) {
        if ((view.getStagedInputType() & 0x3002) != 0 && (view.getStagedInputType() & 0x80) != 0) {
            ReactTextInputManager.updateStagedInputTypeFlag(view, 128, 16);
        }
    }

    private static void updateStagedInputTypeFlag(ReactEditText view, int flagsToUnset, int flagsToSet) {
        view.setStagedInputType(view.getStagedInputType() & ~flagsToUnset | flagsToSet);
    }

    private static EventDispatcher getEventDispatcher(ReactContext reactContext, ReactEditText editText) {
        return UIManagerHelper.getEventDispatcherForReactTag(reactContext, editText.getId());
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactEditText editText) {
        editText.setEventDispatcher(ReactTextInputManager.getEventDispatcher(reactContext, editText));
        editText.addTextChangedListener(new ReactTextInputTextWatcher(reactContext, editText));
        editText.setOnFocusChangeListener((v, hasFocus) -> {
            int surfaceId = reactContext.getSurfaceId();
            EventDispatcher eventDispatcher = ReactTextInputManager.getEventDispatcher(reactContext, editText);
            if (hasFocus) {
                eventDispatcher.dispatchEvent(new ReactTextInputFocusEvent(surfaceId, editText.getId()));
            } else {
                eventDispatcher.dispatchEvent(new ReactTextInputBlurEvent(surfaceId, editText.getId()));
                eventDispatcher.dispatchEvent(new ReactTextInputEndEditingEvent(surfaceId, editText.getId(), editText.getText().toString()));
            }
        });
        editText.setOnEditorActionListener((v, actionId, keyEvent) -> {
            if ((actionId & 0xFF) != 0 || actionId == 0) {
                boolean isMultiline = editText.isMultiline();
                boolean shouldSubmit = editText.shouldSubmitOnReturn();
                boolean shouldBlur = editText.shouldBlurOnReturn();
                if (shouldSubmit) {
                    EventDispatcher eventDispatcher = ReactTextInputManager.getEventDispatcher(reactContext, editText);
                    eventDispatcher.dispatchEvent(new ReactTextInputSubmitEditingEvent(reactContext.getSurfaceId(), editText.getId(), editText.getText().toString()));
                }
                if (shouldBlur) {
                    editText.clearFocus();
                }
                if (shouldBlur || shouldSubmit || !isMultiline) {
                    return true;
                }
                return actionId == 5 || actionId == 7;
            }
            return true;
        });
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return MapBuilder.of("AutoCapitalizationType", MapBuilder.of("none", 0, "characters", 4096, "words", 8192, "sentences", 16384));
    }

    @Override
    public void setPadding(ReactEditText view, int left, int top, int right, int bottom) {
        view.setPadding(left, top, right, bottom);
    }

    @Override
    public Object updateState(ReactEditText view, ReactStylesDiffMap props, StateWrapper stateWrapper) {
        StateWrapper stateManager = view.getStateWrapper();
        if (stateManager == null) {
            view.setPadding(0, 0, 0, 0);
        }
        view.setStateWrapper(stateWrapper);
        ReadableMapBuffer stateMapBuffer = stateWrapper.getStateDataMapBuffer();
        if (stateMapBuffer != null) {
            return this.getReactTextUpdate(view, props, stateMapBuffer);
        }
        ReadableNativeMap state = stateWrapper.getStateData();
        if (state == null || !state.hasKey("attributedString")) {
            return null;
        }
        ReadableNativeMap attributedString = state.getMap("attributedString");
        ReadableNativeMap paragraphAttributes = state.getMap("paragraphAttributes");
        if (attributedString == null || paragraphAttributes == null) {
            throw new IllegalArgumentException("Invalid TextInput State was received as a parameters");
        }
        Spannable spanned = TextLayoutManager.getOrCreateSpannableForText(view.getContext(), attributedString, this.mReactTextViewManagerCallback);
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString("textBreakStrategy"));
        int currentJustificationMode = Build.VERSION.SDK_INT < 26 ? 0 : view.getJustificationMode();
        return ReactTextUpdate.buildReactTextUpdateFromState(spanned, state.getInt("mostRecentEventCount"), TextAttributeProps.getTextAlignment(props, TextLayoutManager.isRTL(attributedString), view.getGravityHorizontal()), textBreakStrategy, TextAttributeProps.getJustificationMode(props, currentJustificationMode));
    }

    @Nullable
    public Object getReactTextUpdate(ReactEditText view, ReactStylesDiffMap props, MapBuffer state) {
        if (state.getCount() == 0) {
            return null;
        }
        MapBuffer attributedString = state.getMapBuffer(0);
        MapBuffer paragraphAttributes = state.getMapBuffer(1);
        Spannable spanned = TextLayoutManagerMapBuffer.getOrCreateSpannableForText(view.getContext(), attributedString, this.mReactTextViewManagerCallback);
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString(2));
        int currentJustificationMode = Build.VERSION.SDK_INT < 26 ? 0 : view.getJustificationMode();
        return ReactTextUpdate.buildReactTextUpdateFromState(spanned, state.getInt(3), TextAttributeProps.getTextAlignment(props, TextLayoutManagerMapBuffer.isRTL(attributedString), view.getGravityHorizontal()), textBreakStrategy, TextAttributeProps.getJustificationMode(props, currentJustificationMode));
    }

    private static class ReactSelectionWatcher
    implements SelectionWatcher {
        private final ReactEditText mReactEditText;
        private final EventDispatcher mEventDispatcher;
        private final int mSurfaceId;
        private int mPreviousSelectionStart;
        private int mPreviousSelectionEnd;

        public ReactSelectionWatcher(ReactEditText editText) {
            this.mReactEditText = editText;
            ReactContext reactContext = UIManagerHelper.getReactContext((View)editText);
            this.mEventDispatcher = ReactTextInputManager.getEventDispatcher(reactContext, editText);
            this.mSurfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
        }

        @Override
        public void onSelectionChanged(int start, int end) {
            int realStart = Math.min(start, end);
            int realEnd = Math.max(start, end);
            if (this.mPreviousSelectionStart != realStart || this.mPreviousSelectionEnd != realEnd) {
                this.mEventDispatcher.dispatchEvent(new ReactTextInputSelectionEvent(this.mSurfaceId, this.mReactEditText.getId(), realStart, realEnd));
                this.mPreviousSelectionStart = realStart;
                this.mPreviousSelectionEnd = realEnd;
            }
        }
    }

    private static class ReactContentSizeWatcher
    implements ContentSizeWatcher {
        private final ReactEditText mEditText;
        private final EventDispatcher mEventDispatcher;
        private final int mSurfaceId;
        private int mPreviousContentWidth = 0;
        private int mPreviousContentHeight = 0;

        public ReactContentSizeWatcher(ReactEditText editText) {
            this.mEditText = editText;
            ReactContext reactContext = UIManagerHelper.getReactContext((View)editText);
            this.mEventDispatcher = ReactTextInputManager.getEventDispatcher(reactContext, editText);
            this.mSurfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
        }

        @Override
        public void onLayout() {
            if (this.mEventDispatcher == null) {
                return;
            }
            int contentWidth = this.mEditText.getWidth();
            int contentHeight = this.mEditText.getHeight();
            if (this.mEditText.getLayout() != null) {
                contentWidth = this.mEditText.getCompoundPaddingLeft() + this.mEditText.getLayout().getWidth() + this.mEditText.getCompoundPaddingRight();
                contentHeight = this.mEditText.getCompoundPaddingTop() + this.mEditText.getLayout().getHeight() + this.mEditText.getCompoundPaddingBottom();
            }
            if (contentWidth != this.mPreviousContentWidth || contentHeight != this.mPreviousContentHeight) {
                this.mPreviousContentHeight = contentHeight;
                this.mPreviousContentWidth = contentWidth;
                this.mEventDispatcher.dispatchEvent(new ReactContentSizeChangedEvent(this.mSurfaceId, this.mEditText.getId(), PixelUtil.toDIPFromPixel(contentWidth), PixelUtil.toDIPFromPixel(contentHeight)));
            }
        }
    }

    private static class ReactScrollWatcher
    implements ScrollWatcher {
        private final ReactEditText mReactEditText;
        private final EventDispatcher mEventDispatcher;
        private final int mSurfaceId;
        private int mPreviousHorizontal;
        private int mPreviousVert;

        public ReactScrollWatcher(ReactEditText editText) {
            this.mReactEditText = editText;
            ReactContext reactContext = UIManagerHelper.getReactContext((View)editText);
            this.mEventDispatcher = ReactTextInputManager.getEventDispatcher(reactContext, editText);
            this.mSurfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
        }

        @Override
        public void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
            if (this.mPreviousHorizontal != horiz || this.mPreviousVert != vert) {
                ScrollEvent event = ScrollEvent.obtain(this.mSurfaceId, this.mReactEditText.getId(), ScrollEventType.SCROLL, horiz, vert, 0.0f, 0.0f, 0, 0, this.mReactEditText.getWidth(), this.mReactEditText.getHeight());
                this.mEventDispatcher.dispatchEvent(event);
                this.mPreviousHorizontal = horiz;
                this.mPreviousVert = vert;
            }
        }
    }

    private final class ReactTextInputTextWatcher
    implements TextWatcher {
        private final ReactEditText mEditText;
        private final EventDispatcher mEventDispatcher;
        private final int mSurfaceId;
        @Nullable
        private String mPreviousText;

        public ReactTextInputTextWatcher(ReactContext reactContext, ReactEditText editText) {
            this.mEventDispatcher = ReactTextInputManager.getEventDispatcher(reactContext, editText);
            this.mEditText = editText;
            this.mPreviousText = null;
            this.mSurfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            this.mPreviousText = s.toString();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (this.mEditText.mDisableTextDiffing) {
                return;
            }
            if (count == 0 && before == 0) {
                return;
            }
            Assertions.assertNotNull((Object)this.mPreviousText);
            String newText = s.toString().substring(start, start + count);
            String oldText = this.mPreviousText.substring(start, start + before);
            if (count == before && newText.equals(oldText)) {
                return;
            }
            StateWrapper stateWrapper = this.mEditText.getStateWrapper();
            if (stateWrapper != null) {
                WritableNativeMap newStateData = new WritableNativeMap();
                newStateData.putInt("mostRecentEventCount", this.mEditText.incrementAndGetEventCounter());
                newStateData.putInt("opaqueCacheId", this.mEditText.getId());
                stateWrapper.updateState(newStateData);
            }
            this.mEventDispatcher.dispatchEvent(new ReactTextChangedEvent(this.mSurfaceId, this.mEditText.getId(), s.toString(), this.mEditText.incrementAndGetEventCounter()));
        }

        public void afterTextChanged(Editable s) {
        }
    }
}

