/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import android.os.Looper;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.MessageQueueThreadImpl;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;

public class ReactQueueConfigurationImpl
implements ReactQueueConfiguration {
    private final MessageQueueThreadImpl mUIQueueThread;
    private final MessageQueueThreadImpl mNativeModulesQueueThread;
    private final MessageQueueThreadImpl mJSQueueThread;

    private ReactQueueConfigurationImpl(MessageQueueThreadImpl uiQueueThread, MessageQueueThreadImpl nativeModulesQueueThread, MessageQueueThreadImpl jsQueueThread) {
        this.mUIQueueThread = uiQueueThread;
        this.mNativeModulesQueueThread = nativeModulesQueueThread;
        this.mJSQueueThread = jsQueueThread;
    }

    @Override
    public MessageQueueThread getUIQueueThread() {
        return this.mUIQueueThread;
    }

    @Override
    public MessageQueueThread getNativeModulesQueueThread() {
        return this.mNativeModulesQueueThread;
    }

    @Override
    public MessageQueueThread getJSQueueThread() {
        return this.mJSQueueThread;
    }

    @Override
    public void destroy() {
        if (this.mNativeModulesQueueThread.getLooper() != Looper.getMainLooper()) {
            this.mNativeModulesQueueThread.quitSynchronous();
        }
        if (this.mJSQueueThread.getLooper() != Looper.getMainLooper()) {
            this.mJSQueueThread.quitSynchronous();
        }
    }

    public static ReactQueueConfigurationImpl create(ReactQueueConfigurationSpec spec, QueueThreadExceptionHandler exceptionHandler) {
        MessageQueueThreadImpl uiThread = MessageQueueThreadImpl.create(MessageQueueThreadSpec.mainThreadSpec(), exceptionHandler);
        MessageQueueThreadImpl jsThread = MessageQueueThreadImpl.create(spec.getJSQueueThreadSpec(), exceptionHandler);
        MessageQueueThreadImpl nativeModulesThread = MessageQueueThreadImpl.create(spec.getNativeModulesQueueThreadSpec(), exceptionHandler);
        return new ReactQueueConfigurationImpl(uiThread, nativeModulesThread, jsThread);
    }
}

