/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.jstasks;

import com.facebook.react.bridge.WritableMap;
import com.facebook.react.jstasks.HeadlessJsTaskRetryPolicy;
import com.facebook.react.jstasks.NoRetryPolicy;

public class HeadlessJsTaskConfig {
    private final String mTaskKey;
    private final WritableMap mData;
    private final long mTimeout;
    private final boolean mAllowedInForeground;
    private final HeadlessJsTaskRetryPolicy mRetryPolicy;

    public HeadlessJsTaskConfig(String taskKey, WritableMap data) {
        this(taskKey, data, 0L, false);
    }

    public HeadlessJsTaskConfig(String taskKey, WritableMap data, long timeout) {
        this(taskKey, data, timeout, false);
    }

    public HeadlessJsTaskConfig(String taskKey, WritableMap data, long timeout, boolean allowedInForeground) {
        this(taskKey, data, timeout, allowedInForeground, NoRetryPolicy.INSTANCE);
    }

    public HeadlessJsTaskConfig(String taskKey, WritableMap data, long timeout, boolean allowedInForeground, HeadlessJsTaskRetryPolicy retryPolicy) {
        this.mTaskKey = taskKey;
        this.mData = data;
        this.mTimeout = timeout;
        this.mAllowedInForeground = allowedInForeground;
        this.mRetryPolicy = retryPolicy;
    }

    public HeadlessJsTaskConfig(HeadlessJsTaskConfig source) {
        this.mTaskKey = source.mTaskKey;
        this.mData = source.mData.copy();
        this.mTimeout = source.mTimeout;
        this.mAllowedInForeground = source.mAllowedInForeground;
        HeadlessJsTaskRetryPolicy retryPolicy = source.mRetryPolicy;
        this.mRetryPolicy = retryPolicy != null ? retryPolicy.copy() : null;
    }

    String getTaskKey() {
        return this.mTaskKey;
    }

    WritableMap getData() {
        return this.mData;
    }

    long getTimeout() {
        return this.mTimeout;
    }

    boolean isAllowedInForeground() {
        return this.mAllowedInForeground;
    }

    HeadlessJsTaskRetryPolicy getRetryPolicy() {
        return this.mRetryPolicy;
    }
}

