/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.appstate;

import com.facebook.fbreact.specs.NativeAppStateSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.WindowFocusChangeListener;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.module.annotations.ReactModule;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="AppState")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0007\u0018\u0000 \"2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\"B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0002J\u001a\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/facebook/react/modules/appstate/AppStateModule;", "Lcom/facebook/fbreact/specs/NativeAppStateSpec;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "Lcom/facebook/react/bridge/WindowFocusChangeListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "appState", "", "addListener", "", "eventName", "createAppStateEventMap", "Lcom/facebook/react/bridge/WritableMap;", "getCurrentAppState", "success", "Lcom/facebook/react/bridge/Callback;", "error", "getTypedExportedConstants", "", "", "invalidate", "onHostDestroy", "onHostPause", "onHostResume", "onWindowFocusChange", "hasFocus", "", "removeListeners", "count", "", "sendAppStateChangeEvent", "sendEvent", "data", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nAppStateModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppStateModule.kt\ncom/facebook/react/modules/appstate/AppStateModule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class AppStateModule
extends NativeAppStateSpec
implements LifecycleEventListener,
WindowFocusChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String appState;
    @NotNull
    public static final String NAME = "AppState";
    @NotNull
    public static final String APP_STATE_ACTIVE = "active";
    @NotNull
    public static final String APP_STATE_BACKGROUND = "background";
    @NotNull
    private static final String INITIAL_STATE = "initialAppState";

    public AppStateModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        reactContext.addLifecycleEventListener(this);
        reactContext.addWindowFocusChangeListener(this);
        this.appState = reactContext.getLifecycleState() == LifecycleState.RESUMED ? APP_STATE_ACTIVE : APP_STATE_BACKGROUND;
    }

    @Override
    @NotNull
    public Map<String, Object> getTypedExportedConstants() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)INITIAL_STATE, (Object)this.appState));
    }

    @Override
    public void getCurrentAppState(@NotNull Callback success, @Nullable Callback error) {
        Intrinsics.checkNotNullParameter((Object)success, (String)"success");
        Object[] objectArray = new Object[]{this.createAppStateEventMap()};
        success.invoke(objectArray);
    }

    @Override
    public void onHostResume() {
        this.appState = APP_STATE_ACTIVE;
        this.sendAppStateChangeEvent();
    }

    @Override
    public void onHostPause() {
        this.appState = APP_STATE_BACKGROUND;
        this.sendAppStateChangeEvent();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void onWindowFocusChange(boolean hasFocus) {
        this.sendEvent("appStateFocusChange", hasFocus);
    }

    private final WritableMap createAppStateEventMap() {
        WritableMap writableMap;
        WritableMap $this$createAppStateEventMap_u24lambda_u240 = writableMap = Arguments.createMap();
        boolean bl = false;
        $this$createAppStateEventMap_u24lambda_u240.putString("app_state", this.appState);
        WritableMap writableMap2 = writableMap;
        Intrinsics.checkNotNullExpressionValue((Object)writableMap2, (String)"apply(...)");
        return writableMap2;
    }

    private final void sendEvent(String eventName, Object data) {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        if (reactApplicationContext == null) {
            return;
        }
        ReactApplicationContext reactApplicationContext2 = reactApplicationContext;
        if (!reactApplicationContext2.hasActiveReactInstance()) {
            return;
        }
        reactApplicationContext2.emitDeviceEvent(eventName, data);
    }

    private final void sendAppStateChangeEvent() {
        this.sendEvent("appStateDidChange", this.createAppStateEventMap());
    }

    @Override
    public void addListener(@Nullable String eventName) {
    }

    @Override
    public void removeListeners(double count) {
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.getReactApplicationContext().removeLifecycleEventListener(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/modules/appstate/AppStateModule$Companion;", "", "()V", "APP_STATE_ACTIVE", "", "APP_STATE_BACKGROUND", "INITIAL_STATE", "NAME", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

