/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.Nullable;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.JavaMethodWrapper;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DoNotStrip
class JavaModuleWrapper {
    private final JSInstance mJSInstance;
    private final ModuleHolder mModuleHolder;
    private final ArrayList<NativeMethod> mMethods;
    private final ArrayList<MethodDescriptor> mDescs;

    public JavaModuleWrapper(JSInstance jsInstance, ModuleHolder moduleHolder) {
        this.mJSInstance = jsInstance;
        this.mModuleHolder = moduleHolder;
        this.mMethods = new ArrayList();
        this.mDescs = new ArrayList();
    }

    @DoNotStrip
    public BaseJavaModule getModule() {
        return (BaseJavaModule)this.mModuleHolder.getModule();
    }

    @DoNotStrip
    public String getName() {
        return this.mModuleHolder.getName();
    }

    @DoNotStrip
    private void findMethods() {
        Method[] targetMethods;
        Systrace.beginSection(0L, "findMethods");
        Class<?> classForMethods = this.mModuleHolder.getModule().getClass();
        Class<?> superClass = classForMethods.getSuperclass();
        if (TurboModule.class.isAssignableFrom(superClass)) {
            classForMethods = superClass;
        }
        for (Method targetMethod : targetMethods = classForMethods.getDeclaredMethods()) {
            ReactMethod annotation = targetMethod.getAnnotation(ReactMethod.class);
            if (annotation == null) continue;
            String methodName = targetMethod.getName();
            MethodDescriptor md = new MethodDescriptor();
            JavaMethodWrapper method = new JavaMethodWrapper(this, targetMethod, annotation.isBlockingSynchronousMethod());
            md.name = methodName;
            md.type = method.getType();
            if ("sync".equals(md.type)) {
                md.signature = method.getSignature();
                md.method = targetMethod;
            }
            this.mMethods.add(method);
            this.mDescs.add(md);
        }
        Systrace.endSection(0L);
    }

    @DoNotStrip
    public List<MethodDescriptor> getMethodDescriptors() {
        if (this.mDescs.isEmpty()) {
            this.findMethods();
        }
        return this.mDescs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    @Nullable
    public NativeMap getConstants() {
        String moduleName = this.getName();
        SystraceMessage.beginSection(0L, "JavaModuleWrapper.getConstants").arg("moduleName", moduleName).flush();
        ReactMarker.logMarker(ReactMarkerConstants.GET_CONSTANTS_START, moduleName);
        BaseJavaModule baseJavaModule = this.getModule();
        Systrace.beginSection(0L, "module.getConstants");
        Map<String, Object> map = baseJavaModule.getConstants();
        Systrace.endSection(0L);
        Systrace.beginSection(0L, "create WritableNativeMap");
        ReactMarker.logMarker(ReactMarkerConstants.CONVERT_CONSTANTS_START, moduleName);
        try {
            WritableNativeMap writableNativeMap = Arguments.makeNativeMap(map);
            return writableNativeMap;
        }
        finally {
            ReactMarker.logMarker(ReactMarkerConstants.CONVERT_CONSTANTS_END, moduleName);
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.GET_CONSTANTS_END, moduleName);
            SystraceMessage.endSection(0L).flush();
        }
    }

    @DoNotStrip
    public void invoke(int methodId, ReadableNativeArray parameters) {
        if (methodId >= this.mMethods.size()) {
            return;
        }
        this.mMethods.get(methodId).invoke(this.mJSInstance, parameters);
    }

    @DoNotStrip
    public static class MethodDescriptor {
        @DoNotStrip
        Method method;
        @DoNotStrip
        String signature;
        @DoNotStrip
        String name;
        @DoNotStrip
        String type;
    }

    static interface NativeMethod {
        public void invoke(JSInstance var1, ReadableArray var2);

        public String getType();
    }
}

