/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common;

import android.net.Uri;
import com.facebook.common.logging.FLog;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0006\u0018\u0000 \u00132\u00060\u0001j\u0002`\u0002:\u0001\u0013B)\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u000bB\u001b\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\t\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/common/DebugServerException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "description", "", "fileName", "lineNumber", "", "column", "<init>", "(Ljava/lang/String;Ljava/lang/String;II)V", "(Ljava/lang/String;)V", "detailMessage", "throwable", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "originalMessage", "getOriginalMessage", "()Ljava/lang/String;", "Companion", "ReactAndroid_release"})
public final class DebugServerException
extends RuntimeException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String originalMessage;
    @NotNull
    private static final String GENERIC_ERROR_MESSAGE = "\n\nTry the following to fix the issue:\n\\u2022 Ensure that Metro is running\n\\u2022 Ensure that your device/emulator is connected to your machine and has USB debugging enabled - run 'adb devices' to see a list of connected devices\n\\u2022 Ensure Airplane Mode is disabled\n\\u2022 If you're on a physical device connected to the same machine, run 'adb reverse tcp:<PORT> tcp:<PORT> to forward requests from your device\n\\u2022 If your device is on the same Wi-Fi network, set 'Debug server host & port for device' in 'Dev settings' to your machine's IP address and the port of the local dev server - e.g. 10.0.1.1:<PORT>\n\n";

    @NotNull
    public final String getOriginalMessage() {
        return this.originalMessage;
    }

    private DebugServerException(String description, String fileName, int lineNumber, int column) {
        super(description + "\n  at " + fileName + ":" + lineNumber + ":" + column);
        this.originalMessage = description;
    }

    public DebugServerException(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        super(description);
        this.originalMessage = description;
    }

    public DebugServerException(@NotNull String detailMessage, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)detailMessage, (String)"detailMessage");
        super(detailMessage, throwable);
        this.originalMessage = detailMessage;
    }

    @JvmStatic
    @NotNull
    public static final DebugServerException makeGeneric(@NotNull String url, @NotNull String reason, @Nullable Throwable t) {
        return Companion.makeGeneric(url, reason, t);
    }

    @JvmStatic
    @NotNull
    public static final DebugServerException makeGeneric(@NotNull String url, @NotNull String reason, @NotNull String extra, @Nullable Throwable t) {
        return Companion.makeGeneric(url, reason, extra, t);
    }

    @JvmStatic
    @Nullable
    public static final DebugServerException parse(@Nullable String url, @Nullable String str) {
        return Companion.parse(url, str);
    }

    public /* synthetic */ DebugServerException(String description, String fileName, int lineNumber, int column, DefaultConstructorMarker $constructor_marker) {
        this(description, fileName, lineNumber, column);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u001e\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/common/DebugServerException$Companion;", "", "<init>", "()V", "GENERIC_ERROR_MESSAGE", "", "makeGeneric", "Lcom/facebook/react/common/DebugServerException;", "url", "reason", "t", "", "extra", "parse", "str", "shortenFileName", "fullFileName", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nDebugServerException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugServerException.kt\ncom/facebook/react/common/DebugServerException$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,108:1\n739#2,9:109\n37#3,2:118\n*S KotlinDebug\n*F\n+ 1 DebugServerException.kt\ncom/facebook/react/common/DebugServerException$Companion\n*L\n103#1:109,9\n103#1:118,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DebugServerException makeGeneric(@NotNull String url, @NotNull String reason, @Nullable Throwable t) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return this.makeGeneric(url, reason, "", t);
        }

        @JvmStatic
        @NotNull
        public final DebugServerException makeGeneric(@NotNull String url, @NotNull String reason, @NotNull String extra, @Nullable Throwable t) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)extra, (String)"extra");
            Uri uri = Uri.parse((String)url);
            String message = StringsKt.replace$default((String)GENERIC_ERROR_MESSAGE, (String)"<PORT>", (String)String.valueOf(uri.getPort()), (boolean)false, (int)4, null);
            return new DebugServerException(reason + message + extra, t);
        }

        @JvmStatic
        @Nullable
        public final DebugServerException parse(@Nullable String url, @Nullable String str) {
            CharSequence charSequence = str;
            if (charSequence == null || charSequence.length() == 0) {
                return null;
            }
            try {
                JSONObject jsonObject = new JSONObject(str);
                String fullFileName = jsonObject.getString("filename");
                String string = jsonObject.getString("message");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                Intrinsics.checkNotNull((Object)fullFileName);
                return new DebugServerException(string, this.shortenFileName(fullFileName), jsonObject.getInt("lineNumber"), jsonObject.getInt("column"), null);
            }
            catch (JSONException e) {
                FLog.w((String)"ReactNative", (String)("Could not parse DebugServerException from: " + str), (Throwable)e);
                return null;
            }
        }

        private final String shortenFileName(String fullFileName) {
            List list;
            CharSequence charSequence = fullFileName;
            Regex regex = new Regex("/");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] parts = thisCollection$iv.toArray(new String[0]);
            return (String)ArraysKt.last((Object[])parts);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

